/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.Faceable;

public abstract class BlockAmethystBud
extends BlockTransparentMeta
implements Faceable {
    public BlockAmethystBud() {
        this(0);
    }

    public BlockAmethystBud(int meta) {
        super(meta);
    }

    protected abstract String getSizeName();

    @Override
    public String getName() {
        return this.getSizeName() + " Amethyst Bud";
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (Block.canConnectToFullSolid(this.getSide(face.getOpposite()))) {
            this.setDamage(face.getIndex());
            return this.getLevel().setBlock(this, this, true, true);
        }
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage());
    }

    public void setBlockFace(BlockFace face) {
        this.setDamage(face.getIndex());
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        switch (this.getBlockFace()) {
            case UP: {
                return BlockAmethystBud.boundingBox(this.getCrystalOffset(), 0.0, this.getCrystalOffset(), 16 - this.getCrystalOffset(), this.getCrystalHeight(), 16 - this.getCrystalOffset());
            }
            case DOWN: {
                return BlockAmethystBud.boundingBox(this.getCrystalOffset(), 16 - this.getCrystalHeight(), this.getCrystalOffset(), 16 - this.getCrystalOffset(), 16.0, 16 - this.getCrystalOffset());
            }
            case NORTH: {
                return BlockAmethystBud.boundingBox(this.getCrystalOffset(), this.getCrystalOffset(), 16 - this.getCrystalHeight(), 16 - this.getCrystalOffset(), 16 - this.getCrystalOffset(), 16.0);
            }
            case SOUTH: {
                return BlockAmethystBud.boundingBox(this.getCrystalOffset(), this.getCrystalOffset(), 0.0, 16 - this.getCrystalOffset(), 16 - this.getCrystalOffset(), this.getCrystalHeight());
            }
            case EAST: {
                return BlockAmethystBud.boundingBox(0.0, this.getCrystalOffset(), this.getCrystalOffset(), this.getCrystalHeight(), 16 - this.getCrystalOffset(), 16 - this.getCrystalOffset());
            }
            case WEST: {
                return BlockAmethystBud.boundingBox(16 - this.getCrystalHeight(), this.getCrystalOffset(), this.getCrystalHeight(), 16.0, 16 - this.getCrystalOffset(), 16 - this.getCrystalOffset());
            }
        }
        return super.recalculateBoundingBox();
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public double getResistance() {
        return 1.5;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    protected abstract int getCrystalHeight();

    protected abstract int getCrystalOffset();

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId()), 0, 1);
    }

    protected static AxisAlignedBB boundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new SimpleAxisAlignedBB(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }
}

