/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.IPlayer;
import cn.nukkit.InterruptibleThread;
import cn.nukkit.Nukkit;
import cn.nukkit.OfflinePlayer;
import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBanner;
import cn.nukkit.blockentity.BlockEntityBarrel;
import cn.nukkit.blockentity.BlockEntityBeacon;
import cn.nukkit.blockentity.BlockEntityBed;
import cn.nukkit.blockentity.BlockEntityBell;
import cn.nukkit.blockentity.BlockEntityBlastFurnace;
import cn.nukkit.blockentity.BlockEntityBrewingStand;
import cn.nukkit.blockentity.BlockEntityCampfire;
import cn.nukkit.blockentity.BlockEntityCauldron;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.blockentity.BlockEntityComparator;
import cn.nukkit.blockentity.BlockEntityDispenser;
import cn.nukkit.blockentity.BlockEntityDropper;
import cn.nukkit.blockentity.BlockEntityEnchantTable;
import cn.nukkit.blockentity.BlockEntityEnderChest;
import cn.nukkit.blockentity.BlockEntityFlowerPot;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.blockentity.BlockEntityHopper;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.blockentity.BlockEntityItemFrameGlow;
import cn.nukkit.blockentity.BlockEntityJukebox;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.blockentity.BlockEntityMusic;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.blockentity.BlockEntitySkull;
import cn.nukkit.blockentity.BlockEntitySmoker;
import cn.nukkit.blockentity.BlockEntitySpawner;
import cn.nukkit.blockentity.PersistentDataContainerBlockEntity;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.command.PluginIdentifiableCommand;
import cn.nukkit.command.SimpleCommandMap;
import cn.nukkit.console.NukkitConsole;
import cn.nukkit.dispenser.DispenseBehaviorRegister;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.custom.EntityManager;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.entity.item.EntityAreaEffectCloud;
import cn.nukkit.entity.item.EntityArmorStand;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.entity.item.EntityChestBoat;
import cn.nukkit.entity.item.EntityEndCrystal;
import cn.nukkit.entity.item.EntityExpBottle;
import cn.nukkit.entity.item.EntityFallingBlock;
import cn.nukkit.entity.item.EntityFirework;
import cn.nukkit.entity.item.EntityFishingHook;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityMinecartChest;
import cn.nukkit.entity.item.EntityMinecartEmpty;
import cn.nukkit.entity.item.EntityMinecartHopper;
import cn.nukkit.entity.item.EntityMinecartTNT;
import cn.nukkit.entity.item.EntityPainting;
import cn.nukkit.entity.item.EntityPotion;
import cn.nukkit.entity.item.EntityPotionLingering;
import cn.nukkit.entity.item.EntityPrimedTNT;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.mob.EntityBlaze;
import cn.nukkit.entity.mob.EntityBogged;
import cn.nukkit.entity.mob.EntityBreeze;
import cn.nukkit.entity.mob.EntityCaveSpider;
import cn.nukkit.entity.mob.EntityCreeper;
import cn.nukkit.entity.mob.EntityDrowned;
import cn.nukkit.entity.mob.EntityElderGuardian;
import cn.nukkit.entity.mob.EntityEnderDragon;
import cn.nukkit.entity.mob.EntityEnderman;
import cn.nukkit.entity.mob.EntityEndermite;
import cn.nukkit.entity.mob.EntityEvoker;
import cn.nukkit.entity.mob.EntityGhast;
import cn.nukkit.entity.mob.EntityGuardian;
import cn.nukkit.entity.mob.EntityHoglin;
import cn.nukkit.entity.mob.EntityHusk;
import cn.nukkit.entity.mob.EntityMagmaCube;
import cn.nukkit.entity.mob.EntityPhantom;
import cn.nukkit.entity.mob.EntityPiglin;
import cn.nukkit.entity.mob.EntityPiglinBrute;
import cn.nukkit.entity.mob.EntityPillager;
import cn.nukkit.entity.mob.EntityRavager;
import cn.nukkit.entity.mob.EntityShulker;
import cn.nukkit.entity.mob.EntitySilverfish;
import cn.nukkit.entity.mob.EntitySkeleton;
import cn.nukkit.entity.mob.EntitySlime;
import cn.nukkit.entity.mob.EntitySnowGolem;
import cn.nukkit.entity.mob.EntitySpider;
import cn.nukkit.entity.mob.EntityStray;
import cn.nukkit.entity.mob.EntityVex;
import cn.nukkit.entity.mob.EntityVindicator;
import cn.nukkit.entity.mob.EntityWarden;
import cn.nukkit.entity.mob.EntityWitch;
import cn.nukkit.entity.mob.EntityWither;
import cn.nukkit.entity.mob.EntityWitherSkeleton;
import cn.nukkit.entity.mob.EntityZoglin;
import cn.nukkit.entity.mob.EntityZombie;
import cn.nukkit.entity.mob.EntityZombiePigman;
import cn.nukkit.entity.mob.EntityZombieVillager;
import cn.nukkit.entity.mob.EntityZombieVillagerV1;
import cn.nukkit.entity.passive.EntityAllay;
import cn.nukkit.entity.passive.EntityArmadillo;
import cn.nukkit.entity.passive.EntityAxolotl;
import cn.nukkit.entity.passive.EntityBat;
import cn.nukkit.entity.passive.EntityBee;
import cn.nukkit.entity.passive.EntityCamel;
import cn.nukkit.entity.passive.EntityCat;
import cn.nukkit.entity.passive.EntityChicken;
import cn.nukkit.entity.passive.EntityCod;
import cn.nukkit.entity.passive.EntityCow;
import cn.nukkit.entity.passive.EntityDolphin;
import cn.nukkit.entity.passive.EntityDonkey;
import cn.nukkit.entity.passive.EntityFox;
import cn.nukkit.entity.passive.EntityFrog;
import cn.nukkit.entity.passive.EntityGlowSquid;
import cn.nukkit.entity.passive.EntityGoat;
import cn.nukkit.entity.passive.EntityHorse;
import cn.nukkit.entity.passive.EntityIronGolem;
import cn.nukkit.entity.passive.EntityLlama;
import cn.nukkit.entity.passive.EntityMooshroom;
import cn.nukkit.entity.passive.EntityMule;
import cn.nukkit.entity.passive.EntityOcelot;
import cn.nukkit.entity.passive.EntityPanda;
import cn.nukkit.entity.passive.EntityParrot;
import cn.nukkit.entity.passive.EntityPig;
import cn.nukkit.entity.passive.EntityPolarBear;
import cn.nukkit.entity.passive.EntityPufferfish;
import cn.nukkit.entity.passive.EntityRabbit;
import cn.nukkit.entity.passive.EntitySalmon;
import cn.nukkit.entity.passive.EntitySheep;
import cn.nukkit.entity.passive.EntitySkeletonHorse;
import cn.nukkit.entity.passive.EntitySniffer;
import cn.nukkit.entity.passive.EntitySquid;
import cn.nukkit.entity.passive.EntityStrider;
import cn.nukkit.entity.passive.EntityTadpole;
import cn.nukkit.entity.passive.EntityTropicalFish;
import cn.nukkit.entity.passive.EntityTurtle;
import cn.nukkit.entity.passive.EntityVillager;
import cn.nukkit.entity.passive.EntityVillagerV1;
import cn.nukkit.entity.passive.EntityWanderingTrader;
import cn.nukkit.entity.passive.EntityWolf;
import cn.nukkit.entity.passive.EntityZombieHorse;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityEgg;
import cn.nukkit.entity.projectile.EntityEnderEye;
import cn.nukkit.entity.projectile.EntityEnderPearl;
import cn.nukkit.entity.projectile.EntitySnowball;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.entity.weather.EntityLightning;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.level.LevelInitEvent;
import cn.nukkit.event.level.LevelLoadEvent;
import cn.nukkit.event.server.PlayerDataSerializeEvent;
import cn.nukkit.event.server.QueryRegenerateEvent;
import cn.nukkit.event.server.ServerStopEvent;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.item.Item;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.item.custom.CustomItemManager;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.lang.BaseLang;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.EnumLevel;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Level;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.LevelProviderManager;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.leveldb.LevelDBProvider;
import cn.nukkit.level.generator.Flat;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.Nether;
import cn.nukkit.level.generator.Normal;
import cn.nukkit.level.generator.TheEnd;
import cn.nukkit.level.generator.Void;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.metadata.EntityMetadataStore;
import cn.nukkit.metadata.LevelMetadataStore;
import cn.nukkit.metadata.PlayerMetadataStore;
import cn.nukkit.metrics.NukkitMetrics;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.BatchingHelper;
import cn.nukkit.network.Network;
import cn.nukkit.network.RakNetInterface;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.BiomeDefinitionListPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.PlayerListPacket;
import cn.nukkit.network.query.QueryHandler;
import cn.nukkit.network.rcon.RCON;
import cn.nukkit.permission.BanEntry;
import cn.nukkit.permission.BanList;
import cn.nukkit.permission.DefaultPermissions;
import cn.nukkit.permission.Permissible;
import cn.nukkit.plugin.JavaPluginLoader;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginLoadOrder;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.plugin.service.NKServiceManager;
import cn.nukkit.plugin.service.ServiceManager;
import cn.nukkit.potion.Effect;
import cn.nukkit.potion.Potion;
import cn.nukkit.resourcepacks.ResourcePackManager;
import cn.nukkit.resourcepacks.loader.JarPluginResourcePackLoader;
import cn.nukkit.resourcepacks.loader.ZippedResourcePackLoader;
import cn.nukkit.scheduler.ServerScheduler;
import cn.nukkit.scheduler.Task;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import cn.nukkit.utils.DefaultPlayerDataSerializer;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.PlayerDataSerializer;
import cn.nukkit.utils.ServerException;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Watchdog;
import cn.nukkit.utils.bugreport.ExceptionHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;

public class Server {
    @Generated
    private static final Logger log = LogManager.getLogger(Server.class);
    public static final String BROADCAST_CHANNEL_ADMINISTRATIVE = "nukkit.broadcast.admin";
    public static final String BROADCAST_CHANNEL_USERS = "nukkit.broadcast.user";
    private static Server instance;
    private final BanList banByName;
    private final BanList banByIP;
    private final Config operators;
    private final Config whitelist;
    private final Config properties;
    private final Config config;
    private final String filePath;
    private final String dataPath;
    private final String pluginPath;
    private final PluginManager pluginManager;
    private final ServerScheduler scheduler;
    private final BaseLang baseLang;
    private final NukkitConsole console;
    private final ConsoleThread consoleThread;
    private final SimpleCommandMap commandMap;
    private final CraftingManager craftingManager;
    private final ResourcePackManager resourcePackManager;
    private final ConsoleCommandSender consoleSender;
    private boolean hasStopped;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private int tickCounter;
    private long nextTick;
    private final float[] tickAverage = new float[]{20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f};
    private final float[] useAverage = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private float maxTick = 20.0f;
    private float maxUse;
    private int baseTickRate;
    private int autoSaveTicker;
    private int maxPlayers;
    private boolean autoSave = true;
    private int difficulty;
    int spawnThresholdRadius;
    private String ip;
    private int port;
    private final UUID serverID = UUID.randomUUID();
    private RCON rcon;
    private final Network network;
    private QueryHandler queryHandler;
    private QueryRegenerateEvent queryRegenerateEvent;
    private final EntityMetadataStore entityMetadata;
    private final PlayerMetadataStore playerMetadata;
    private final LevelMetadataStore levelMetadata;
    private final Map<InetSocketAddress, Player> players = new HashMap<InetSocketAddress, Player>();
    final Map<UUID, Player> playerList = new HashMap<UUID, Player>();
    private static final Pattern UUID_PATTERN;
    private final Map<Integer, Level> levels = new HashMap<Integer, Level>(){

        @Override
        public Level put(Integer key, Level value) {
            Level result = super.put(key, value);
            Server.access$002(Server.this, Server.this.levels.values().toArray(new Level[0]));
            return result;
        }

        @Override
        public boolean remove(Object key, Object value) {
            boolean result = super.remove(key, value);
            Server.access$002(Server.this, Server.this.levels.values().toArray(new Level[0]));
            return result;
        }

        @Override
        public Level remove(Object key) {
            Level result = (Level)super.remove(key);
            Server.access$002(Server.this, Server.this.levels.values().toArray(new Level[0]));
            return result;
        }
    };
    private Level[] levelArray = new Level[0];
    private final ServiceManager serviceManager = new NKServiceManager();
    private Level defaultLevel;
    private final Thread currentThread;
    private Watchdog watchdog;
    private final DB nameLookup;
    private PlayerDataSerializer playerDataSerializer;
    private final BatchingHelper batchingHelper;
    private final Set<String> ignoredPackets = new HashSet<String>();
    private String motd;
    boolean shouldSavePlayerData;
    private boolean allowFlight;
    private boolean isHardcore;
    private boolean forceResources;
    private boolean forceGamemode;
    public boolean whitelistEnabled;
    public boolean xboxAuth;
    boolean achievementsEnabled;
    boolean pvpEnabled;
    boolean announceAchievements;
    public int chunksPerTick;
    int spawnThreshold;
    public int networkCompressionLevel;
    private int viewDistance;
    public int gamemode;
    private int skinChangeCooldown;
    private int spawnRadius;
    private int autoSaveTicks;
    private int autoTickRateLimit;
    public boolean queryPlugins;
    public boolean cacheChunks;
    boolean attackStopSprint;
    private boolean autoTickRate;
    private boolean forceLanguage;
    private boolean alwaysTickPlayers;
    boolean forceResourcesAllowOwnPacks;
    boolean encryptionEnabled;
    public final boolean useSnappy;
    public int networkCompressionThreshold;
    public boolean holdWorldSave;
    private static final byte[] QUERY_PREFIX;
    private int lastLevelGC;

    /*
     * WARNING - void declaration
     */
    Server(String filePath, String dataPath, String pluginPath, String predefinedLanguage) {
        void var7_21;
        Preconditions.checkState(instance == null, "Already initialized!");
        this.currentThread = Thread.currentThread();
        instance = this;
        this.filePath = filePath;
        if (!new File(dataPath + "worlds/").exists()) {
            new File(dataPath + "worlds/").mkdirs();
        }
        if (!new File(dataPath + "players/").exists()) {
            new File(dataPath + "players/").mkdirs();
        }
        if (!new File(pluginPath).exists()) {
            new File(pluginPath).mkdirs();
        }
        this.dataPath = new File(dataPath).getAbsolutePath() + '/';
        this.pluginPath = new File(pluginPath).getAbsolutePath() + '/';
        this.playerDataSerializer = new DefaultPlayerDataSerializer(this);
        this.console = new NukkitConsole();
        this.consoleThread = new ConsoleThread();
        this.consoleThread.start();
        if (!new File(this.dataPath + "nukkit.yml").exists()) {
            this.getLogger().info((Object)((Object)TextFormat.GREEN) + "Welcome! Please choose a language first!");
            try {
                String[] lines;
                InputStream languageList = this.getClass().getClassLoader().getResourceAsStream("lang/language.list");
                if (languageList == null) {
                    throw new IllegalStateException("lang/language.list is missing. If you are running a development version, make sure you have run 'git submodule update --init'.");
                }
                String[] stringArray = lines = Utils.readFile(languageList).split("\n");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String line = stringArray[i];
                    this.getLogger().info(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String fallback = "eng";
            String language = null;
            while (language == null) {
                void var7_13;
                if (predefinedLanguage != null) {
                    log.info("Trying to load language from predefined language: " + predefinedLanguage);
                    String string = predefinedLanguage;
                } else {
                    String string = this.console.readLine();
                }
                InputStream conf = this.getClass().getClassLoader().getResourceAsStream("lang/" + (String)var7_13 + "/lang.ini");
                if (conf != null) {
                    language = var7_13;
                    continue;
                }
                if (predefinedLanguage == null) continue;
                log.warn("No language found for predefined language: " + predefinedLanguage + ", please choose a valid language");
                predefinedLanguage = null;
            }
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("lang/" + language + "/nukkit.yml");
            if (inputStream == null) {
                InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("lang/" + fallback + "/nukkit.yml");
            }
            try {
                void var7_16;
                Utils.writeFile(this.dataPath + "nukkit.yml", (InputStream)var7_16);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.config = new Config(this.dataPath + "nukkit.yml", 2);
        log.info("Loading server properties...");
        Nukkit.DEBUG = NukkitMath.clamp(this.getConfig("debug.level", 1), 1, 3);
        int logLevel = (Nukkit.DEBUG + 3) * 100;
        org.apache.logging.log4j.Level currentLevel = Nukkit.getLogLevel();
        for (org.apache.logging.log4j.Level level : org.apache.logging.log4j.Level.values()) {
            if (level.intLevel() != logLevel || level.intLevel() <= currentLevel.intLevel()) continue;
            Nukkit.setLogLevel(level);
            break;
        }
        this.ignoredPackets.addAll(this.getConfig().getStringList("debug.ignored-packets"));
        this.properties = new Config(this.dataPath + "server.properties", 0, (ConfigSection)new ServerProperties());
        this.useSnappy = this.getConfig("network.compression-use-snappy", false);
        this.baseLang = new BaseLang(this.getConfig("settings.language", "eng"));
        this.loadSettings();
        log.info(this.getLanguage().translateString("language.selected", new String[]{this.getLanguage().getName(), this.getLanguage().getLang()}));
        log.info(this.getLanguage().translateString("nukkit.server.start", (Object)((Object)TextFormat.AQUA) + this.getVersion() + (Object)((Object)TextFormat.RESET)));
        String string = this.getConfig("settings.async-workers", "auto");
        if (!(string instanceof Integer)) {
            try {
                Integer n = Integer.valueOf(string);
            }
            catch (Exception e) {
                Integer n = Math.max(Runtime.getRuntime().availableProcessors() + 1, 4);
            }
        }
        ServerScheduler.WORKERS = (Integer)var7_21;
        this.scheduler = new ServerScheduler();
        this.console.setExecutingCommands(true);
        this.batchingHelper = new BatchingHelper();
        if (this.getPropertyBoolean("enable-rcon", false)) {
            try {
                this.rcon = new RCON(this, this.getPropertyString("rcon.password", ""), !this.getIp().isEmpty() ? this.getIp() : "0.0.0.0", this.getPropertyInt("rcon.port", this.getPort()));
            }
            catch (IllegalArgumentException e) {
                log.error(this.baseLang.translateString(e.getMessage(), e.getCause().getMessage()));
            }
        }
        this.entityMetadata = new EntityMetadataStore();
        this.playerMetadata = new PlayerMetadataStore();
        this.levelMetadata = new LevelMetadataStore();
        this.operators = new Config(this.dataPath + "ops.txt", 5);
        this.whitelist = new Config(this.dataPath + "white-list.txt", 5);
        this.banByName = new BanList(this.dataPath + "banned-players.json");
        this.banByName.load();
        this.banByIP = new BanList(this.dataPath + "banned-ips.json");
        this.banByIP.load();
        this.consoleSender = new ConsoleCommandSender();
        this.commandMap = new SimpleCommandMap(this);
        Server.registerEntities();
        Server.registerBlockEntities();
        Block.init();
        Enchantment.init();
        GlobalBlockPalette.init();
        RuntimeItems.init();
        Item.init();
        EnumBiome.values();
        Effect.init();
        Potion.init();
        Attribute.init();
        DispenseBehaviorRegister.init();
        EntityManager.get();
        BiomeDefinitionListPacket.getCachedPacket();
        try {
            this.nameLookup = Iq80DBFactory.factory.open(new File(dataPath, "players"), new Options().createIfMissing(true).compressionType(CompressionType.ZLIB_RAW));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.convertLegacyPlayerData();
        this.craftingManager = new CraftingManager();
        this.resourcePackManager = new ResourcePackManager(new ZippedResourcePackLoader(new File(Nukkit.DATA_PATH, "resource_packs")), new JarPluginResourcePackLoader(new File(this.pluginPath)));
        this.pluginManager = new PluginManager(this, this.commandMap);
        this.pluginManager.subscribeToPermission(BROADCAST_CHANNEL_ADMINISTRATIVE, this.consoleSender);
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        this.queryRegenerateEvent = new QueryRegenerateEvent(this, 5);
        log.info(this.baseLang.translateString("nukkit.server.networkStart", new String[]{this.getIp().isEmpty() ? "*" : this.getIp(), String.valueOf(this.getPort())}));
        this.network = new Network(this);
        this.network.setName(this.getMotd());
        this.network.setSubName(this.getSubMotd());
        this.network.registerInterface(new RakNetInterface(this));
        if (!this.encryptionEnabled) {
            this.getLogger().warning("Encryption is not enabled! For better security, it's recommended to enable it (network.encryption: true in nukkit.yml) if you don't use a proxy software.");
        }
        if (!this.xboxAuth) {
            this.getLogger().warning("Xbox authentication is not enabled! It's recommended to enable it (xbox-auth=on in server.properties) if you don't use a proxy software or an authentication plugin.");
        }
        log.info(this.getLanguage().translateString("nukkit.server.info", this.getName(), (Object)((Object)TextFormat.YELLOW) + this.getNukkitVersion() + (Object)((Object)TextFormat.WHITE), (Object)((Object)TextFormat.AQUA) + this.getCodename() + (Object)((Object)TextFormat.WHITE), this.getApiVersion()));
        log.info(this.getLanguage().translateString("nukkit.server.license", this.getName()));
        ExceptionHandler.registerExceptionHandler();
        this.pluginManager.loadPlugins(this.pluginPath);
        this.enablePlugins(PluginLoadOrder.STARTUP);
        boolean regenerateItemPalette = false;
        if (CustomItemManager.get().closeRegistry()) {
            regenerateItemPalette = true;
        }
        if (regenerateItemPalette) {
            RuntimeItems.getMapping().generatePalette();
        }
        EntityManager.get().closeRegistry();
        Item.initCreativeItems();
        this.craftingManager.rebuildPacket();
        LevelProviderManager.addProvider(this, Anvil.class);
        LevelProviderManager.addProvider(this, LevelDBProvider.class);
        Generator.addGenerator(Flat.class, "flat", 2);
        Generator.addGenerator(Normal.class, "normal", 1);
        Generator.addGenerator(Normal.class, "default", 1);
        Generator.addGenerator(Nether.class, "nether", 3);
        Generator.addGenerator(TheEnd.class, "the_end", 4);
        Generator.addGenerator(Void.class, "void", 5);
        for (String name : this.getConfig("worlds", new HashMap()).keySet()) {
            long seed;
            if (this.loadLevel(name)) continue;
            String seedString = String.valueOf(this.getConfig("worlds." + name + ".seed", System.currentTimeMillis()));
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                seed = seedString.hashCode();
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            String[] opts = this.getConfig("worlds." + name + ".generator", Generator.getGenerator("default").getSimpleName()).split(":");
            Class<? extends Generator> generator = Generator.getGenerator(opts[0]);
            if (opts.length > 1) {
                StringBuilder preset = new StringBuilder();
                for (int i = 1; i < opts.length; ++i) {
                    preset.append(opts[i]).append(":");
                }
                preset = new StringBuilder(preset.substring(0, preset.length() - 1));
                options.put("preset", preset.toString());
            }
            this.generateLevel(name, seed, generator, options);
        }
        if (this.getDefaultLevel() == null) {
            String defaultName = this.getPropertyString("level-name", "world");
            if (defaultName == null || defaultName.trim().isEmpty()) {
                this.getLogger().warning("level-name cannot be null, using default");
                defaultName = "world";
                this.setPropertyString("level-name", defaultName);
            }
            if (!this.loadLevel(defaultName)) {
                long seed;
                String seedString = String.valueOf(this.getProperty("level-seed", System.currentTimeMillis()));
                try {
                    seed = Long.parseLong(seedString);
                }
                catch (NumberFormatException e) {
                    seed = seedString.hashCode();
                }
                this.generateLevel(defaultName, seed == 0L ? System.currentTimeMillis() : seed);
            }
            this.setDefaultLevel(this.getLevelByName(defaultName));
        }
        if (this.defaultLevel == null) {
            this.getLogger().emergency(this.baseLang.translateString("nukkit.level.defaultError"));
            this.forceShutdown();
            return;
        }
        this.properties.save(true);
        Level level = this.defaultLevel;
        this.getLogger().debug("Preparing spawn region for level " + level.getName());
        Vector3 spawn = level.getProvider().getSpawn();
        level.populateChunk(spawn.getChunkX(), spawn.getChunkZ(), true);
        EnumLevel.initLevels();
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        if (Nukkit.DEBUG < 2) {
            this.watchdog = new Watchdog(this, 60000L);
            this.watchdog.start();
        }
        new NukkitMetrics(this);
        this.start();
    }

    public int broadcastMessage(String message) {
        return this.broadcast(message, BROADCAST_CHANNEL_USERS);
    }

    public int broadcastMessage(TextContainer message) {
        return this.broadcast(message, BROADCAST_CHANNEL_USERS);
    }

    public int broadcastMessage(String message, CommandSender[] recipients) {
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.length;
    }

    public int broadcastMessage(String message, Collection<? extends CommandSender> recipients) {
        for (CommandSender commandSender : recipients) {
            commandSender.sendMessage(message);
        }
        return recipients.size();
    }

    public int broadcastMessage(TextContainer message, Collection<? extends CommandSender> recipients) {
        for (CommandSender commandSender : recipients) {
            commandSender.sendMessage(message);
        }
        return recipients.size();
    }

    public int broadcast(String message, String permissions) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (String permission : permissions.split(";")) {
            for (Permissible permissible : this.pluginManager.getPermissionSubscriptions(permission)) {
                if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
                recipients.add((CommandSender)permissible);
            }
        }
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    public int broadcast(TextContainer message, String permissions) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (String permission : permissions.split(";")) {
            for (Permissible permissible : this.pluginManager.getPermissionSubscriptions(permission)) {
                if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
                recipients.add((CommandSender)permissible);
            }
        }
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    public static void broadcastPacket(Collection<Player> players, DataPacket packet) {
        packet.tryEncode();
        for (Player player : players) {
            player.dataPacket(packet);
        }
    }

    public static void broadcastPacket(Player[] players, DataPacket packet) {
        packet.tryEncode();
        for (Player player : players) {
            player.dataPacket(packet);
        }
    }

    public void batchPackets(Player[] players, DataPacket[] packets) {
        this.batchingHelper.batchPackets(this, players, packets);
    }

    public void enablePlugins(PluginLoadOrder type) {
        for (Plugin plugin : new ArrayList<Plugin>(this.pluginManager.getPlugins().values())) {
            if (plugin.isEnabled() || type != plugin.getDescription().getOrder()) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
        }
    }

    public void enablePlugin(Plugin plugin) {
        this.pluginManager.enablePlugin(plugin);
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) throws ServerException {
        if (!this.isPrimaryThread()) {
            this.getLogger().warning("Command dispatched asynchronously: " + commandLine);
        }
        if (sender == null) {
            throw new ServerException("CommandSender is not valid");
        }
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.unknown", commandLine));
        return false;
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.consoleSender;
    }

    public void reload() {
        log.info("Saving levels...");
        for (Level level : this.levelArray) {
            level.save();
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        log.info("Reloading server properties...");
        this.properties.reload();
        this.loadSettings();
        this.banByIP.load();
        this.banByName.load();
        this.reloadWhitelist();
        this.operators.reload();
        for (BanEntry entry : this.banByIP.getEntires().values()) {
            try {
                this.network.blockAddress(InetAddress.getByName(entry.getName()));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        log.info("Reloading plugins...");
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        this.pluginManager.loadPlugins(this.pluginPath);
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    public void shutdown() {
        this.isRunning.compareAndSet(true, false);
    }

    public void forceShutdown() {
        this.forceShutdown(this.getConfig("settings.shutdown-message", "Server closed"));
    }

    public void forceShutdown(String reason) {
        if (this.hasStopped) {
            return;
        }
        try {
            this.isRunning.compareAndSet(true, false);
            this.hasStopped = true;
            ServerStopEvent serverStopEvent = new ServerStopEvent();
            this.pluginManager.callEvent(serverStopEvent);
            if (this.holdWorldSave) {
                this.getLogger().warning("World save hold was not released! Any backup currently being taken may be invalid");
            }
            if (this.rcon != null) {
                this.getLogger().debug("Closing RCON...");
                this.rcon.close();
            }
            this.getLogger().debug("Disconnecting all players...");
            for (Player player : new ArrayList<Player>(this.players.values())) {
                player.close(player.getLeaveMessage(), reason);
            }
            this.getLogger().debug("Disabling all plugins...");
            this.disablePlugins();
            this.getLogger().debug("Removing event handlers...");
            HandlerList.unregisterAll();
            this.getLogger().debug("Stopping all tasks...");
            this.scheduler.cancelAllTasks();
            this.scheduler.mainThreadHeartbeat(Integer.MAX_VALUE);
            this.getLogger().debug("Unloading all levels...");
            for (Level level : this.levelArray) {
                this.unloadLevel(level, true);
                this.nextTick = System.currentTimeMillis();
            }
            this.getLogger().debug("Closing console...");
            this.consoleThread.interrupt();
            this.getLogger().debug("Closing BatchingHelper...");
            this.batchingHelper.shutdown();
            this.getLogger().debug("Stopping network interfaces...");
            for (SourceInterface interfaz : this.network.getInterfaces()) {
                interfaz.shutdown();
                this.network.unregisterInterface(interfaz);
            }
            if (this.nameLookup != null) {
                this.getLogger().debug("Closing name lookup DB...");
                this.nameLookup.close();
            }
            if (this.watchdog != null) {
                this.getLogger().debug("Stopping Watchdog...");
                this.watchdog.kill();
            }
        }
        catch (Exception e) {
            log.fatal("Exception happened while shutting down, exiting the process", (Throwable)e);
            System.exit(1);
        }
    }

    public void start() {
        if (this.getPropertyBoolean("enable-query", false)) {
            this.queryHandler = new QueryHandler();
        }
        for (BanEntry entry : this.banByIP.getEntires().values()) {
            try {
                this.network.blockAddress(InetAddress.getByName(entry.getName()));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        this.tickCounter = 0;
        log.info(this.baseLang.translateString("nukkit.server.startFinished", String.valueOf((double)(System.currentTimeMillis() - Nukkit.START_TIME) / 1000.0)));
        this.tickProcessor();
        this.forceShutdown();
    }

    public void handlePacket(InetSocketAddress address, ByteBuf payload) {
        try {
            if (this.queryHandler == null || !payload.isReadable(3)) {
                return;
            }
            byte[] prefix = new byte[2];
            payload.readBytes(prefix);
            if (Arrays.equals(prefix, QUERY_PREFIX)) {
                this.queryHandler.handle(address, payload);
            }
        }
        catch (Exception e) {
            log.error("Error whilst handling packet", (Throwable)e);
            this.network.blockAddress(address.getAddress(), 300);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tickProcessor() {
        this.nextTick = System.currentTimeMillis();
        try {
            while (this.isRunning.get()) {
                try {
                    this.tick();
                    long next = this.nextTick;
                    long current = System.currentTimeMillis();
                    if (!((double)next - 0.1 > (double)current)) continue;
                    long allocated = next - current - 1L;
                    int offset = 0;
                    for (int i = 0; i < this.levelArray.length; ++i) {
                        offset = (i + this.lastLevelGC) % this.levelArray.length;
                        Level level = this.levelArray[offset];
                        if (!level.isBeingConverted) {
                            level.doGarbageCollection(allocated - 1L);
                        }
                        if ((allocated = next - System.currentTimeMillis()) <= 0L) break;
                    }
                    this.lastLevelGC = offset + 1;
                    if (allocated <= 0L) continue;
                    try {
                        Thread.sleep(allocated, 900000);
                    }
                    catch (Exception e) {
                        this.getLogger().logException(e);
                    }
                }
                catch (RuntimeException e) {
                    this.getLogger().logException(e);
                }
            }
            return;
        }
        catch (Throwable e) {
            log.fatal("Exception happened while ticking server", e);
            log.fatal(Utils.getAllThreadDumps());
        }
    }

    public void onPlayerCompleteLoginSequence(Player player) {
        this.playerList.put(player.getUniqueId(), player);
        this.updatePlayerListData(player.getUniqueId(), player.getId(), player.getDisplayName(), player.getSkin(), player.getLoginChainData().getXUID());
    }

    public void addPlayer(InetSocketAddress socketAddress, Player player) {
        this.players.put(socketAddress, player);
    }

    public void addOnlinePlayer(Player player) {
        this.playerList.put(player.getUniqueId(), player);
        this.updatePlayerListData(player.getUniqueId(), player.getId(), player.getDisplayName(), player.getSkin(), player.getLoginChainData().getXUID());
    }

    public void removeOnlinePlayer(Player player) {
        if (player.getUniqueId() == null) {
            return;
        }
        if (this.playerList.remove(player.getUniqueId()) != null) {
            PlayerListPacket pk = new PlayerListPacket();
            pk.type = 1;
            pk.entries = new PlayerListPacket.Entry[]{new PlayerListPacket.Entry(player.getUniqueId())};
            Server.broadcastPacket(this.playerList.values(), (DataPacket)pk);
        }
    }

    public void updatePlayerListData(UUID uuid, long entityId, String name, Skin skin) {
        this.updatePlayerListData(uuid, entityId, name, skin, "", this.playerList.values());
    }

    public void updatePlayerListData(UUID uuid, long entityId, String name, Skin skin, String xboxUserId) {
        this.updatePlayerListData(uuid, entityId, name, skin, xboxUserId, this.playerList.values());
    }

    public void updatePlayerListData(UUID uuid, long entityId, String name, Skin skin, Player[] players) {
        this.updatePlayerListData(uuid, entityId, name, skin, "", players);
    }

    public void updatePlayerListData(UUID uuid, long entityId, String name, Skin skin, String xboxUserId, Player[] players) {
        PlayerListPacket pk = new PlayerListPacket();
        pk.type = 0;
        pk.entries = new PlayerListPacket.Entry[]{new PlayerListPacket.Entry(uuid, entityId, name, skin, xboxUserId)};
        this.batchPackets(players, new DataPacket[]{pk});
    }

    public void updatePlayerListData(UUID uuid, long entityId, String name, Skin skin, String xboxUserId, Collection<Player> players) {
        this.updatePlayerListData(uuid, entityId, name, skin, xboxUserId, players.toArray(new Player[0]));
    }

    public void removePlayerListData(UUID uuid) {
        this.removePlayerListData(uuid, this.playerList.values());
    }

    public void removePlayerListData(UUID uuid, Player[] players) {
        PlayerListPacket pk = new PlayerListPacket();
        pk.type = 1;
        pk.entries = new PlayerListPacket.Entry[]{new PlayerListPacket.Entry(uuid)};
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void removePlayerListData(UUID uuid, Player player) {
        PlayerListPacket pk = new PlayerListPacket();
        pk.type = 1;
        pk.entries = new PlayerListPacket.Entry[]{new PlayerListPacket.Entry(uuid)};
        player.dataPacket(pk);
    }

    public void removePlayerListData(UUID uuid, Collection<Player> players) {
        this.removePlayerListData(uuid, players.toArray(new Player[0]));
    }

    public void sendFullPlayerListData(Player player) {
        PlayerListPacket pk = new PlayerListPacket();
        pk.type = 0;
        pk.entries = (PlayerListPacket.Entry[])this.playerList.values().stream().map(p -> new PlayerListPacket.Entry(p.getUniqueId(), p.getId(), p.getDisplayName(), p.getSkin(), p.getLoginChainData().getXUID())).toArray(PlayerListPacket.Entry[]::new);
        player.dataPacket(pk);
    }

    public void sendRecipeList(Player player) {
        player.dataPacket(CraftingManager.packet);
    }

    private void checkTickUpdates(int currentTick) {
        if (this.alwaysTickPlayers) {
            for (Player p : new ArrayList<Player>(this.players.values())) {
                p.onUpdate(currentTick);
            }
        }
        for (Player p : this.getOnlinePlayers().values()) {
            p.resetPacketCounters();
        }
        for (Level level : this.levelArray) {
            if (level.isBeingConverted || level.getTickRate() > this.baseTickRate && --level.tickRateCounter > 0) continue;
            try {
                int tickMs;
                long levelTime = System.currentTimeMillis();
                level.doTick(currentTick);
                level.tickRateTime = tickMs = (int)(System.currentTimeMillis() - levelTime);
                if (!this.autoTickRate) continue;
                if (tickMs < 50 && level.getTickRate() > this.baseTickRate) {
                    int r = level.getTickRate() - 1;
                    level.setTickRate(r);
                    if (r > this.baseTickRate) {
                        level.tickRateCounter = level.getTickRate();
                    }
                    this.getLogger().debug("Raising level \"" + level.getName() + "\" tick rate to " + level.getTickRate() + " ticks");
                    continue;
                }
                if (tickMs < 50) continue;
                if (level.getTickRate() == this.baseTickRate) {
                    level.setTickRate(Math.max(this.baseTickRate + 1, Math.min(this.autoTickRateLimit, tickMs / 50)));
                    this.getLogger().debug("Level \"" + level.getName() + "\" took " + tickMs + "ms, setting tick rate to " + level.getTickRate() + " ticks");
                } else if (tickMs / level.getTickRate() >= 50 && level.getTickRate() < this.autoTickRateLimit) {
                    level.setTickRate(level.getTickRate() + 1);
                    this.getLogger().debug("Level \"" + level.getName() + "\" took " + tickMs + "ms, setting tick rate to " + level.getTickRate() + " ticks");
                }
                level.tickRateCounter = level.getTickRate();
            }
            catch (Exception e) {
                log.error(this.baseLang.translateString("nukkit.level.tickError", new String[]{level.getFolderName(), Utils.getExceptionMessage(e)}));
            }
        }
    }

    public void doAutoSave() {
        if (this.autoSave) {
            log.debug("Running auto save...");
            for (Player player : this.players.values()) {
                if (!player.isOnline()) continue;
                player.save(true);
            }
            for (Level level : this.levelArray) {
                if (!level.getAutoSave() || level.getProvider() == null) continue;
                try {
                    level.save();
                }
                catch (Exception ex) {
                    this.getLogger().error("Failed to auto save " + level.getName(), ex);
                }
            }
        }
    }

    private void tick() {
        long tickTime = System.currentTimeMillis();
        long time = tickTime - this.nextTick;
        if (time < -25L) {
            try {
                Thread.sleep(Math.max(5L, -time - 25L));
            }
            catch (InterruptedException e) {
                this.getLogger().logException(e);
            }
        }
        long tickTimeNano = System.nanoTime();
        if (tickTime - this.nextTick < -25L) {
            return;
        }
        ++this.tickCounter;
        this.network.processInterfaces();
        if (this.rcon != null) {
            this.rcon.check();
        }
        this.scheduler.mainThreadHeartbeat(this.tickCounter);
        this.checkTickUpdates(this.tickCounter);
        for (Player player : new ArrayList<Player>(this.players.values())) {
            player.checkNetwork();
        }
        if ((this.tickCounter & 0xF) == 0) {
            this.titleTick();
            this.maxTick = 20.0f;
            this.maxUse = 0.0f;
            if ((this.tickCounter & 0x1FF) == 0) {
                try {
                    this.queryRegenerateEvent = new QueryRegenerateEvent(this, 5);
                    this.pluginManager.callEvent(this.queryRegenerateEvent);
                    if (this.queryHandler != null) {
                        this.queryHandler.regenerateInfo();
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            this.network.updateName();
        }
        if (++this.autoSaveTicker >= this.autoSaveTicks) {
            this.autoSaveTicker = 0;
            this.doAutoSave();
        }
        if (this.tickCounter % 100 == 0) {
            for (Level level : this.levelArray) {
                if (level.isBeingConverted) continue;
                level.doChunkGarbageCollection();
            }
        }
        long nowNano = System.nanoTime();
        float tick = (float)Math.min(20.0, 1.0E9 / Math.max(1000000.0, (double)nowNano - (double)tickTimeNano));
        float use = (float)Math.min(1.0, (double)(nowNano - tickTimeNano) / 5.0E7);
        if (this.maxTick > tick) {
            this.maxTick = tick;
        }
        if (this.maxUse < use) {
            this.maxUse = use;
        }
        System.arraycopy(this.tickAverage, 1, this.tickAverage, 0, this.tickAverage.length - 1);
        this.tickAverage[this.tickAverage.length - 1] = tick;
        System.arraycopy(this.useAverage, 1, this.useAverage, 0, this.useAverage.length - 1);
        this.useAverage[this.useAverage.length - 1] = use;
        this.nextTick = this.nextTick - tickTime < -1000L ? tickTime : (this.nextTick += 50L);
    }

    public long getNextTick() {
        return this.nextTick;
    }

    private void titleTick() {
        if (!Nukkit.TITLE) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        double used = NukkitMath.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1024.0 / 1024.0, 2);
        double max = NukkitMath.round((double)runtime.maxMemory() / 1024.0 / 1024.0, 2);
        System.out.print("\u001b]0;Nukkit " + Nukkit.VERSION + " | Online " + this.playerList.size() + '/' + this.maxPlayers + " | Memory " + Math.round(used / max * 100.0) + '%' + " | TPS " + this.getTicksPerSecond() + " | Load " + this.getTickUsage() + '%' + '\u0007');
    }

    public QueryRegenerateEvent getQueryInformation() {
        return this.queryRegenerateEvent;
    }

    public String getName() {
        return "Nukkit";
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public String getNukkitVersion() {
        return Nukkit.VERSION;
    }

    public String getCodename() {
        return "";
    }

    public String getVersion() {
        return "v1.21.50";
    }

    public String getApiVersion() {
        return "1.1.0";
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getPluginPath() {
        return this.pluginPath;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getPort() {
        return this.port;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public String getIp() {
        return this.ip;
    }

    public UUID getServerUniqueId() {
        return this.serverID;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
        for (Level level : this.levelArray) {
            level.setAutoSave(this.autoSave);
        }
    }

    public String getLevelType() {
        return this.getPropertyString("level-type", "default");
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public boolean getForceGamemode() {
        return this.forceGamemode;
    }

    public static String getGamemodeString(int mode) {
        return Server.getGamemodeString(mode, false);
    }

    public static String getGamemodeString(int mode, boolean direct) {
        switch (mode) {
            case 0: {
                return direct ? "Survival" : "%gameMode.survival";
            }
            case 1: {
                return direct ? "Creative" : "%gameMode.creative";
            }
            case 2: {
                return direct ? "Adventure" : "%gameMode.adventure";
            }
            case 3: {
                return direct ? "Spectator" : "%gameMode.spectator";
            }
        }
        return "UNKNOWN";
    }

    public static int getGamemodeFromString(String str) {
        switch (str.trim().toLowerCase()) {
            case "0": 
            case "survival": 
            case "s": {
                return 0;
            }
            case "1": 
            case "creative": 
            case "c": {
                return 1;
            }
            case "2": 
            case "adventure": 
            case "a": {
                return 2;
            }
            case "3": 
            case "spectator": 
            case "spc": 
            case "view": 
            case "v": {
                return 3;
            }
            case "default": {
                return Server.getInstance().getDefaultGamemode();
            }
        }
        return -1;
    }

    public static int getDifficultyFromString(String str) {
        switch (str.trim().toLowerCase()) {
            case "0": 
            case "peaceful": 
            case "p": {
                return 0;
            }
            case "1": 
            case "easy": 
            case "e": {
                return 1;
            }
            case "2": 
            case "normal": 
            case "n": {
                return 2;
            }
            case "3": 
            case "hard": 
            case "h": {
                return 3;
            }
        }
        return -1;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int difficulty) {
        int value = difficulty;
        if (value < 0) {
            value = 0;
        }
        if (value > 3) {
            value = 3;
        }
        this.difficulty = value;
        this.setPropertyInt("difficulty", value);
    }

    public boolean hasWhitelist() {
        return this.whitelistEnabled;
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public boolean isHardcore() {
        return this.isHardcore;
    }

    public int getDefaultGamemode() {
        return this.getGamemode();
    }

    public String getMotd() {
        return this.motd;
    }

    public String getSubMotd() {
        String sub = this.getPropertyString("sub-motd", "Powered by Nukkit");
        if (sub.isEmpty()) {
            sub = "Powered by Nukkit";
        }
        return sub;
    }

    public boolean getForceResources() {
        return this.forceResources;
    }

    public MainLogger getLogger() {
        return MainLogger.getLogger();
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public LevelMetadataStore getLevelMetadata() {
        return this.levelMetadata;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CraftingManager getCraftingManager() {
        return this.craftingManager;
    }

    public ResourcePackManager getResourcePackManager() {
        return this.resourcePackManager;
    }

    public ServerScheduler getScheduler() {
        return this.scheduler;
    }

    public int getTick() {
        return this.tickCounter;
    }

    public float getTicksPerSecond() {
        return (float)Math.round(this.maxTick * 100.0f) / 100.0f;
    }

    public float getTicksPerSecondAverage() {
        float sum = 0.0f;
        int count = this.tickAverage.length;
        for (float aTickAverage : this.tickAverage) {
            sum += aTickAverage;
        }
        return (float)NukkitMath.round(sum / (float)count, 2);
    }

    public float getTickUsage() {
        return (float)NukkitMath.round(this.maxUse * 100.0f, 2);
    }

    public float getTickUsageAverage() {
        float sum = 0.0f;
        for (float aUseAverage : this.useAverage) {
            sum += aUseAverage;
        }
        return (float)Math.round(sum / (float)this.useAverage.length * 100.0f) / 100.0f;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    public Map<UUID, Player> getOnlinePlayers() {
        return ImmutableMap.copyOf(this.playerList);
    }

    public int getOnlinePlayersCount() {
        return this.playerList.size();
    }

    public void addRecipe(Recipe recipe) {
        this.craftingManager.registerRecipe(recipe);
    }

    public Optional<Player> getPlayer(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        return Optional.ofNullable(this.playerList.get(uuid));
    }

    public Optional<UUID> lookupName(String name) {
        byte[] nameBytes = name.toLowerCase().getBytes(StandardCharsets.UTF_8);
        byte[] uuidBytes = this.nameLookup.get(nameBytes);
        if (uuidBytes == null) {
            return Optional.empty();
        }
        if (uuidBytes.length != 16) {
            log.warn("Invalid uuid in name lookup database, removing: " + name);
            this.nameLookup.delete(nameBytes);
            return Optional.empty();
        }
        ByteBuffer buffer = ByteBuffer.wrap(uuidBytes);
        return Optional.of(new UUID(buffer.getLong(), buffer.getLong()));
    }

    void updateName(UUID uuid, String name) {
        byte[] nameBytes = name.toLowerCase().getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        this.nameLookup.put(nameBytes, buffer.array());
    }

    @Deprecated
    public IPlayer getOfflinePlayer(String name) {
        Player result = this.getPlayerExact(name);
        if (result != null) {
            return result;
        }
        return this.lookupName(name).map(uuid -> new OfflinePlayer(this, (UUID)uuid, name)).orElse(new OfflinePlayer(this, name));
    }

    public IPlayer getOfflinePlayer(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        Optional<Player> onlinePlayer = this.getPlayer(uuid);
        if (onlinePlayer.isPresent()) {
            return onlinePlayer.get();
        }
        return new OfflinePlayer(this, uuid);
    }

    public CompoundTag getOfflinePlayerData(UUID uuid) {
        return this.getOfflinePlayerData(uuid, false);
    }

    public CompoundTag getOfflinePlayerData(UUID uuid, boolean create) {
        return this.getOfflinePlayerDataInternal(uuid.toString(), true, create);
    }

    @Deprecated
    public CompoundTag getOfflinePlayerData(String name) {
        return this.getOfflinePlayerData(name, false);
    }

    @Deprecated
    public CompoundTag getOfflinePlayerData(String name, boolean create) {
        Optional<UUID> uuid = this.lookupName(name);
        return this.getOfflinePlayerDataInternal(uuid.map(UUID::toString).orElse(name), true, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundTag getOfflinePlayerDataInternal(String name, boolean runEvent, boolean create) {
        Preconditions.checkNotNull(name, "name");
        PlayerDataSerializeEvent event = new PlayerDataSerializeEvent(name, this.playerDataSerializer);
        if (runEvent) {
            this.pluginManager.callEvent(event);
        }
        Optional<Object> dataStream = Optional.empty();
        try {
            dataStream = event.getSerializer().read(name, event.getUuid().orElse(null));
            if (dataStream.isPresent()) {
                CompoundTag compoundTag = NBTIO.readCompressed((InputStream)dataStream.get());
                return compoundTag;
            }
        }
        catch (IOException e) {
            log.warn(this.getLanguage().translateString("nukkit.data.playerCorrupted", name), (Throwable)e);
        }
        finally {
            if (dataStream.isPresent()) {
                try {
                    ((InputStream)dataStream.get()).close();
                }
                catch (IOException e) {
                    log.throwing(e);
                }
            }
        }
        CompoundTag nbt = null;
        if (create) {
            if (this.shouldSavePlayerData()) {
                log.info(this.getLanguage().translateString("nukkit.data.playerNotFound", name));
            }
            Vector3 spawn = this.getDefaultLevel().getProvider().getSpawn();
            long time = System.currentTimeMillis();
            nbt = new CompoundTag().putLong("firstPlayed", time / 1000L).putLong("lastPlayed", time / 1000L).putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("0", spawn.x)).add(new DoubleTag("1", spawn.y)).add(new DoubleTag("2", spawn.z))).putString("Level", this.getDefaultLevel().getName()).putList(new ListTag("Inventory")).putCompound("Achievements", new CompoundTag()).putInt("playerGameType", this.getGamemode()).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("0", 0.0)).add(new DoubleTag("1", 0.0)).add(new DoubleTag("2", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("0", 0.0f)).add(new FloatTag("1", 0.0f))).putFloat("FallDistance", 0.0f).putShort("Fire", 0).putShort("Air", 400).putBoolean("OnGround", true).putBoolean("Invulnerable", false);
            this.saveOfflinePlayerData(name, nbt, true, runEvent);
        }
        return nbt;
    }

    public void saveOfflinePlayerData(UUID uuid, CompoundTag tag) {
        this.saveOfflinePlayerData(uuid, tag, false);
    }

    public void saveOfflinePlayerData(String name, CompoundTag tag) {
        this.saveOfflinePlayerData(name, tag, false);
    }

    public void saveOfflinePlayerData(UUID uuid, CompoundTag tag, boolean async) {
        this.saveOfflinePlayerData(uuid.toString(), tag, async);
    }

    public void saveOfflinePlayerData(String name, CompoundTag tag, boolean async) {
        Optional<UUID> uuid = this.lookupName(name);
        this.saveOfflinePlayerData(uuid.map(UUID::toString).orElse(name), tag, async, true);
    }

    private void saveOfflinePlayerData(String name, final CompoundTag tag, boolean async, boolean runEvent) {
        if (this.shouldSavePlayerData()) {
            final String nameLower = name.toLowerCase();
            final PlayerDataSerializeEvent event = new PlayerDataSerializeEvent(nameLower, this.playerDataSerializer);
            if (runEvent) {
                this.pluginManager.callEvent(event);
            }
            if (async) {
                this.getScheduler().scheduleTask(null, new Task(){
                    private volatile boolean hasRun = false;

                    @Override
                    public void onRun(int currentTick) {
                        this.onCancel();
                    }

                    @Override
                    public void onCancel() {
                        if (!this.hasRun) {
                            this.hasRun = true;
                            Server.this.saveOfflinePlayerDataInternal(event.getSerializer(), tag, nameLower, event.getUuid().orElse(null));
                        }
                    }
                }, true);
            } else {
                this.saveOfflinePlayerDataInternal(event.getSerializer(), tag, nameLower, event.getUuid().orElse(null));
            }
        }
    }

    private void saveOfflinePlayerDataInternal(PlayerDataSerializer serializer, CompoundTag tag, String name, UUID uuid) {
        try (OutputStream dataStream = serializer.write(name, uuid);){
            NBTIO.writeGZIPCompressed(tag, dataStream, ByteOrder.BIG_ENDIAN);
        }
        catch (Exception e) {
            log.error(this.getLanguage().translateString("nukkit.data.saveError", name, e), (Throwable)e);
        }
    }

    private void convertLegacyPlayerData() {
        File dataDirectory = new File(this.getDataPath(), "players/");
        File[] files = dataDirectory.listFiles(file -> {
            String name = file.getName();
            return !UUID_PATTERN.matcher(name).matches() && name.endsWith(".dat");
        });
        if (files == null) {
            return;
        }
        for (File legacyData : files) {
            String name = legacyData.getName();
            name = name.substring(0, name.length() - 4);
            log.debug("Attempting legacy player data conversion for {}", (Object)name);
            CompoundTag tag = this.getOfflinePlayerDataInternal(name, false, false);
            if (tag == null || !tag.contains("UUIDLeast") || !tag.contains("UUIDMost")) continue;
            UUID uuid = new UUID(tag.getLong("UUIDMost"), tag.getLong("UUIDLeast"));
            if (!tag.contains("NameTag")) {
                tag.putString("NameTag", name);
            }
            if (new File(this.getDataPath() + "players/" + uuid.toString() + ".dat").exists()) continue;
            this.saveOfflinePlayerData(uuid.toString(), tag, false, false);
            this.updateName(uuid, name);
            if (legacyData.delete()) continue;
            log.warn("Unable to delete legacy data for {}", (Object)name);
        }
    }

    public Player getPlayer(String name) {
        Player found = null;
        name = name.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (Player player : this.getOnlinePlayers().values()) {
            if (!player.getName().toLowerCase().startsWith(name)) continue;
            int curDelta = player.getName().length() - name.length();
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    public Player getPlayerExact(String name) {
        for (Player player : this.getOnlinePlayers().values()) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return player;
        }
        return null;
    }

    public Player[] matchPlayer(String partialName) {
        partialName = partialName.toLowerCase();
        ArrayList<Player> matchedPlayer = new ArrayList<Player>();
        for (Player player : this.getOnlinePlayers().values()) {
            if (player.getName().toLowerCase().equals(partialName)) {
                return new Player[]{player};
            }
            if (!player.getName().toLowerCase().contains(partialName)) continue;
            matchedPlayer.add(player);
        }
        return matchedPlayer.toArray(new Player[0]);
    }

    public void removePlayer(Player player) {
        if (this.players.remove(player.getSocketAddress()) != null) {
            return;
        }
        for (InetSocketAddress socketAddress : new ArrayList<InetSocketAddress>(this.players.keySet())) {
            if (player != this.players.get(socketAddress)) continue;
            this.players.remove(socketAddress);
            break;
        }
    }

    public Map<Integer, Level> getLevels() {
        return this.levels;
    }

    public Level getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Level defaultLevel) {
        if (defaultLevel == null || this.isLevelLoaded(defaultLevel.getFolderName()) && defaultLevel != this.defaultLevel) {
            this.defaultLevel = defaultLevel;
        }
    }

    public boolean isLevelLoaded(String name) {
        return this.getLevelByName(name) != null;
    }

    public Level getLevel(int levelId) {
        return this.levels.get(levelId);
    }

    public Level getLevelByName(String name) {
        for (Level level : this.levelArray) {
            if (!level.getFolderName().equalsIgnoreCase(name)) continue;
            return level;
        }
        return null;
    }

    public boolean unloadLevel(Level level) {
        return this.unloadLevel(level, false);
    }

    public boolean unloadLevel(Level level, boolean forceUnload) {
        if (level == this.defaultLevel && !forceUnload) {
            throw new IllegalStateException("The default level cannot be unloaded while running, please switch levels.");
        }
        return level.unload(forceUnload);
    }

    public boolean loadLevel(String name) {
        Level level;
        if (Objects.equals(name.trim(), "")) {
            throw new LevelException("Invalid empty level name");
        }
        if (!this.isPrimaryThread()) {
            this.getLogger().warning("Level loaded asynchronously: " + name);
        }
        if (this.isLevelLoaded(name)) {
            return true;
        }
        if (!this.isLevelGenerated(name)) {
            log.warn(this.baseLang.translateString("nukkit.level.notFound", name));
            return false;
        }
        String path = name.contains("/") || name.contains("\\") ? name : this.dataPath + "worlds/" + name + '/';
        Class<? extends LevelProvider> provider = LevelProviderManager.getProvider(path);
        if (provider == null) {
            log.error(this.baseLang.translateString("nukkit.level.loadError", new String[]{name, "Unknown provider"}));
            return false;
        }
        try {
            level = new Level(this, name, path, provider);
        }
        catch (Exception e) {
            log.error(this.baseLang.translateString("nukkit.level.loadError", new String[]{name, e.getMessage()}));
            return false;
        }
        level.initLevel();
        this.levels.put(level.getId(), level);
        level.setTickRate(this.baseTickRate);
        this.pluginManager.callEvent(new LevelLoadEvent(level));
        return true;
    }

    public boolean generateLevel(String name) {
        return this.generateLevel(name, Utils.random.nextLong());
    }

    public boolean generateLevel(String name, long seed) {
        return this.generateLevel(name, seed, null);
    }

    public boolean generateLevel(String name, long seed, Class<? extends Generator> generator) {
        return this.generateLevel(name, seed, generator, new HashMap<String, Object>());
    }

    public boolean generateLevel(String name, long seed, Class<? extends Generator> generator, Map<String, Object> options) {
        return this.generateLevel(name, seed, generator, options, null);
    }

    public boolean generateLevel(String name, long seed, Class<? extends Generator> generator, Map<String, Object> options, Class<? extends LevelProvider> provider) {
        Level level;
        if (Objects.equals(name.trim(), "") || this.isLevelGenerated(name)) {
            return false;
        }
        if (!options.containsKey("preset")) {
            options.put("preset", this.getPropertyString("generator-settings", ""));
        }
        if (generator == null) {
            generator = Generator.getGenerator(this.getLevelType());
        }
        if (provider == null) {
            provider = LevelProviderManager.getProviderByName("leveldb");
        }
        String path = name.contains("/") || name.contains("\\") ? name : this.dataPath + "worlds/" + name + '/';
        try {
            provider.getMethod("generate", String.class, String.class, Long.TYPE, Class.class, Map.class).invoke(null, path, name, seed, generator, options);
            level = new Level(this, name, path, provider);
            level.initLevel();
            this.levels.put(level.getId(), level);
            level.setTickRate(this.baseTickRate);
        }
        catch (Exception e) {
            log.error(this.baseLang.translateString("nukkit.level.generationError", new String[]{name, Utils.getExceptionMessage(e)}));
            return false;
        }
        this.pluginManager.callEvent(new LevelInitEvent(level));
        this.pluginManager.callEvent(new LevelLoadEvent(level));
        return true;
    }

    public boolean isLevelGenerated(String name) {
        if (Objects.equals(name.trim(), "")) {
            return false;
        }
        if (this.getLevelByName(name) == null) {
            String path = name.contains("/") || name.contains("\\") ? name : this.dataPath + "worlds/" + name + '/';
            return LevelProviderManager.getProvider(path) != null;
        }
        return true;
    }

    public BaseLang getLanguage() {
        return this.baseLang;
    }

    public boolean isLanguageForced() {
        return this.forceLanguage;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Config getConfig() {
        return this.config;
    }

    public <T> T getConfig(String variable) {
        return this.getConfig(variable, null);
    }

    public <T> T getConfig(String variable, T defaultValue) {
        Object value = this.config.get(variable);
        return (T)(value == null ? defaultValue : value);
    }

    public Config getProperties() {
        return this.properties;
    }

    public Object getProperty(String variable) {
        return this.getProperty(variable, null);
    }

    public Object getProperty(String variable, Object defaultValue) {
        Object value = this.properties.get(variable);
        return value == null ? defaultValue : value;
    }

    public void setPropertyString(String variable, String value) {
        this.properties.set(variable, value);
        this.properties.save();
    }

    public String getPropertyString(String key) {
        return this.getPropertyString(key, null);
    }

    public String getPropertyString(String key, String defaultValue) {
        Object value = this.properties.get(key);
        return value == null ? defaultValue : value.toString();
    }

    public int getPropertyInt(String variable) {
        return this.getPropertyInt(variable, null);
    }

    public int getPropertyInt(String variable, Integer defaultValue) {
        Object value = this.properties.get(variable);
        return value == null || value instanceof String && ((String)value).isEmpty() ? defaultValue : Integer.parseInt(String.valueOf(value));
    }

    public void setPropertyInt(String variable, int value) {
        this.properties.set(variable, value);
        this.properties.save();
    }

    public boolean getPropertyBoolean(String variable) {
        return this.getPropertyBoolean(variable, null);
    }

    public boolean getPropertyBoolean(String variable, Object defaultValue) {
        Object value = this.properties.get(variable);
        if (value == null) {
            value = defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        switch (String.valueOf(value)) {
            case "on": 
            case "true": 
            case "1": 
            case "yes": {
                return true;
            }
        }
        return false;
    }

    public void setPropertyBoolean(String variable, boolean value) {
        this.properties.set(variable, value ? "1" : "0");
        this.properties.save();
    }

    public PluginIdentifiableCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginIdentifiableCommand) {
            return (PluginIdentifiableCommand)((Object)command);
        }
        return null;
    }

    public BanList getNameBans() {
        return this.banByName;
    }

    public BanList getIPBans() {
        return this.banByIP;
    }

    public void addOp(String name) {
        this.operators.set(name.toLowerCase(), true);
        Player player = this.getPlayerExact(name);
        if (player != null) {
            player.recalculatePermissions();
        }
        this.operators.save(true);
    }

    public void removeOp(String name) {
        this.operators.remove(name.toLowerCase());
        Player player = this.getPlayerExact(name);
        if (player != null) {
            player.recalculatePermissions();
        }
        this.operators.save();
    }

    public void addWhitelist(String name) {
        this.whitelist.set(name.toLowerCase(), true);
        this.whitelist.save(true);
    }

    public void removeWhitelist(String name) {
        this.whitelist.remove(name.toLowerCase());
        this.whitelist.save(true);
    }

    public boolean isWhitelisted(String name) {
        return !this.hasWhitelist() || this.operators.exists(name, true) || this.whitelist.exists(name, true);
    }

    public boolean isOp(String name) {
        return name != null && this.operators.exists(name, true);
    }

    public Config getWhitelist() {
        return this.whitelist;
    }

    public Config getOps() {
        return this.operators;
    }

    public void reloadWhitelist() {
        this.whitelist.reload();
    }

    public Map<String, List<String>> getCommandAliases() {
        Object section = this.getConfig("aliases");
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (section instanceof Map) {
            for (Map.Entry entry : ((Map)section).entrySet()) {
                ArrayList<String> commands = new ArrayList<String>();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    commands.addAll((List)value);
                } else {
                    commands.add((String)value);
                }
                result.put(key, commands);
            }
        }
        return result;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public boolean shouldSavePlayerData() {
        return this.shouldSavePlayerData;
    }

    public int getPlayerSkinChangeCooldown() {
        return this.skinChangeCooldown;
    }

    public final boolean isPrimaryThread() {
        return Thread.currentThread() == this.currentThread;
    }

    public Thread getPrimaryThread() {
        return this.currentThread;
    }

    private static void registerEntities() {
        Entity.registerEntity("Item", EntityItem.class);
        Entity.registerEntity("Painting", EntityPainting.class);
        Entity.registerEntity("XpOrb", EntityXPOrb.class);
        Entity.registerEntity("ArmorStand", EntityArmorStand.class);
        Entity.registerEntity("EndCrystal", EntityEndCrystal.class);
        Entity.registerEntity("FallingSand", EntityFallingBlock.class);
        Entity.registerEntity("PrimedTnt", EntityPrimedTNT.class);
        Entity.registerEntity("Firework", EntityFirework.class);
        Entity.registerEntity("Arrow", EntityArrow.class);
        Entity.registerEntity("Snowball", EntitySnowball.class);
        Entity.registerEntity("EnderPearl", EntityEnderPearl.class);
        Entity.registerEntity("ThrownExpBottle", EntityExpBottle.class);
        Entity.registerEntity("ThrownPotion", EntityPotion.class);
        Entity.registerEntity("Egg", EntityEgg.class);
        Entity.registerEntity("ThrownLingeringPotion", EntityPotionLingering.class);
        Entity.registerEntity("ThrownTrident", EntityThrownTrident.class);
        Entity.registerEntity("FishingHook", EntityFishingHook.class);
        Entity.registerEntity("EnderEye", EntityEnderEye.class);
        Entity.registerEntity("AreaEffectCloud", EntityAreaEffectCloud.class);
        Entity.registerEntity("Blaze", EntityBlaze.class);
        Entity.registerEntity("Creeper", EntityCreeper.class);
        Entity.registerEntity("CaveSpider", EntityCaveSpider.class);
        Entity.registerEntity("Drowned", EntityDrowned.class);
        Entity.registerEntity("ElderGuardian", EntityElderGuardian.class);
        Entity.registerEntity("EnderDragon", EntityEnderDragon.class);
        Entity.registerEntity("Enderman", EntityEnderman.class);
        Entity.registerEntity("Endermite", EntityEndermite.class);
        Entity.registerEntity("Evoker", EntityEvoker.class);
        Entity.registerEntity("Ghast", EntityGhast.class);
        Entity.registerEntity("Guardian", EntityGuardian.class);
        Entity.registerEntity("Husk", EntityHusk.class);
        Entity.registerEntity("MagmaCube", EntityMagmaCube.class);
        Entity.registerEntity("Phantom", EntityPhantom.class);
        Entity.registerEntity("Ravager", EntityRavager.class);
        Entity.registerEntity("Shulker", EntityShulker.class);
        Entity.registerEntity("Silverfish", EntitySilverfish.class);
        Entity.registerEntity("Skeleton", EntitySkeleton.class);
        Entity.registerEntity("SkeletonHorse", EntitySkeletonHorse.class);
        Entity.registerEntity("Slime", EntitySlime.class);
        Entity.registerEntity("Spider", EntitySpider.class);
        Entity.registerEntity("Stray", EntityStray.class);
        Entity.registerEntity("Vindicator", EntityVindicator.class);
        Entity.registerEntity("Vex", EntityVex.class);
        Entity.registerEntity("WitherSkeleton", EntityWitherSkeleton.class);
        Entity.registerEntity("Wither", EntityWither.class);
        Entity.registerEntity("Witch", EntityWitch.class);
        Entity.registerEntity("ZombiePigman", EntityZombiePigman.class);
        Entity.registerEntity("ZombieVillager", EntityZombieVillagerV1.class);
        Entity.registerEntity("Zombie", EntityZombie.class);
        Entity.registerEntity("Pillager", EntityPillager.class);
        Entity.registerEntity("ZombieVillagerV2", EntityZombieVillager.class);
        Entity.registerEntity("Hoglin", EntityHoglin.class);
        Entity.registerEntity("Piglin", EntityPiglin.class);
        Entity.registerEntity("Zoglin", EntityZoglin.class);
        Entity.registerEntity("PiglinBrute", EntityPiglinBrute.class);
        Entity.registerEntity("Warden", EntityWarden.class);
        Entity.registerEntity("Breeze", EntityBreeze.class);
        Entity.registerEntity("Bogged", EntityBogged.class);
        Entity.registerEntity("Bat", EntityBat.class);
        Entity.registerEntity("Cat", EntityCat.class);
        Entity.registerEntity("Chicken", EntityChicken.class);
        Entity.registerEntity("Cod", EntityCod.class);
        Entity.registerEntity("Cow", EntityCow.class);
        Entity.registerEntity("Dolphin", EntityDolphin.class);
        Entity.registerEntity("Donkey", EntityDonkey.class);
        Entity.registerEntity("Horse", EntityHorse.class);
        Entity.registerEntity("IronGolem", EntityIronGolem.class);
        Entity.registerEntity("Llama", EntityLlama.class);
        Entity.registerEntity("Mooshroom", EntityMooshroom.class);
        Entity.registerEntity("Mule", EntityMule.class);
        Entity.registerEntity("Panda", EntityPanda.class);
        Entity.registerEntity("Parrot", EntityParrot.class);
        Entity.registerEntity("PolarBear", EntityPolarBear.class);
        Entity.registerEntity("Pig", EntityPig.class);
        Entity.registerEntity("Pufferfish", EntityPufferfish.class);
        Entity.registerEntity("Rabbit", EntityRabbit.class);
        Entity.registerEntity("Salmon", EntitySalmon.class);
        Entity.registerEntity("Sheep", EntitySheep.class);
        Entity.registerEntity("Squid", EntitySquid.class);
        Entity.registerEntity("SnowGolem", EntitySnowGolem.class);
        Entity.registerEntity("TropicalFish", EntityTropicalFish.class);
        Entity.registerEntity("Turtle", EntityTurtle.class);
        Entity.registerEntity("Wolf", EntityWolf.class);
        Entity.registerEntity("Ocelot", EntityOcelot.class);
        Entity.registerEntity("Villager", EntityVillagerV1.class);
        Entity.registerEntity("ZombieHorse", EntityZombieHorse.class);
        Entity.registerEntity("WanderingTrader", EntityWanderingTrader.class);
        Entity.registerEntity("VillagerV2", EntityVillager.class);
        Entity.registerEntity("Fox", EntityFox.class);
        Entity.registerEntity("Bee", EntityBee.class);
        Entity.registerEntity("Strider", EntityStrider.class);
        Entity.registerEntity("Goat", EntityGoat.class);
        Entity.registerEntity("Axolotl", EntityAxolotl.class);
        Entity.registerEntity("GlowSquid", EntityGlowSquid.class);
        Entity.registerEntity("Allay", EntityAllay.class);
        Entity.registerEntity("Frog", EntityFrog.class);
        Entity.registerEntity("Tadpole", EntityTadpole.class);
        Entity.registerEntity("Camel", EntityCamel.class);
        Entity.registerEntity("Sniffer", EntitySniffer.class);
        Entity.registerEntity("Armadillo", EntityArmadillo.class);
        Entity.registerEntity("MinecartRideable", EntityMinecartEmpty.class);
        Entity.registerEntity("MinecartChest", EntityMinecartChest.class);
        Entity.registerEntity("MinecartHopper", EntityMinecartHopper.class);
        Entity.registerEntity("MinecartTnt", EntityMinecartTNT.class);
        Entity.registerEntity("Boat", EntityBoat.class);
        Entity.registerEntity("ChestBoat", EntityChestBoat.class);
        Entity.registerEntity("Human", EntityHuman.class, true);
        Entity.registerEntity("Lightning", EntityLightning.class);
    }

    private static void registerBlockEntities() {
        BlockEntity.registerBlockEntity("Furnace", BlockEntityFurnace.class);
        BlockEntity.registerBlockEntity("Chest", BlockEntityChest.class);
        BlockEntity.registerBlockEntity("Sign", BlockEntitySign.class);
        BlockEntity.registerBlockEntity("EnchantTable", BlockEntityEnchantTable.class);
        BlockEntity.registerBlockEntity("Skull", BlockEntitySkull.class);
        BlockEntity.registerBlockEntity("FlowerPot", BlockEntityFlowerPot.class);
        BlockEntity.registerBlockEntity("BrewingStand", BlockEntityBrewingStand.class);
        BlockEntity.registerBlockEntity("ItemFrame", BlockEntityItemFrame.class);
        BlockEntity.registerBlockEntity("GlowItemFrame", BlockEntityItemFrameGlow.class);
        BlockEntity.registerBlockEntity("Cauldron", BlockEntityCauldron.class);
        BlockEntity.registerBlockEntity("EnderChest", BlockEntityEnderChest.class);
        BlockEntity.registerBlockEntity("Beacon", BlockEntityBeacon.class);
        BlockEntity.registerBlockEntity("PistonArm", BlockEntityPistonArm.class);
        BlockEntity.registerBlockEntity("Comparator", BlockEntityComparator.class);
        BlockEntity.registerBlockEntity("Hopper", BlockEntityHopper.class);
        BlockEntity.registerBlockEntity("Bed", BlockEntityBed.class);
        BlockEntity.registerBlockEntity("Jukebox", BlockEntityJukebox.class);
        BlockEntity.registerBlockEntity("ShulkerBox", BlockEntityShulkerBox.class);
        BlockEntity.registerBlockEntity("Banner", BlockEntityBanner.class);
        BlockEntity.registerBlockEntity("Dropper", BlockEntityDropper.class);
        BlockEntity.registerBlockEntity("Dispenser", BlockEntityDispenser.class);
        BlockEntity.registerBlockEntity("MobSpawner", BlockEntitySpawner.class);
        BlockEntity.registerBlockEntity("Music", BlockEntityMusic.class);
        BlockEntity.registerBlockEntity("Campfire", BlockEntityCampfire.class);
        BlockEntity.registerBlockEntity("Barrel", BlockEntityBarrel.class);
        BlockEntity.registerBlockEntity("Lectern", BlockEntityLectern.class);
        BlockEntity.registerBlockEntity("BlastFurnace", BlockEntityBlastFurnace.class);
        BlockEntity.registerBlockEntity("Smoker", BlockEntitySmoker.class);
        BlockEntity.registerBlockEntity("Bell", BlockEntityBell.class);
        BlockEntity.registerBlockEntity("PersistentContainer", PersistentDataContainerBlockEntity.class);
    }

    public boolean isNetherAllowed() {
        return EnumLevel.NETHER.getLevel() != null;
    }

    public PlayerDataSerializer getPlayerDataSerializer() {
        return this.playerDataSerializer;
    }

    public void setPlayerDataSerializer(PlayerDataSerializer playerDataSerializer) {
        this.playerDataSerializer = Preconditions.checkNotNull(playerDataSerializer, "playerDataSerializer");
    }

    boolean isIgnoredPacket(Class<? extends DataPacket> clazz) {
        return this.ignoredPackets.contains(clazz.getSimpleName());
    }

    public static Server getInstance() {
        return instance;
    }

    private void loadSettings() {
        this.forceLanguage = this.getConfig("settings.force-language", false);
        this.queryPlugins = this.getConfig("settings.query-plugins", true);
        this.networkCompressionThreshold = this.getConfig("network.batch-threshold", 256);
        this.networkCompressionLevel = Math.max(Math.min(this.getConfig("network.compression-level", 5), 9), 0);
        this.encryptionEnabled = this.getConfig("network.encryption", false);
        this.autoTickRate = this.getConfig("level-settings.auto-tick-rate", true);
        this.autoTickRateLimit = this.getConfig("level-settings.auto-tick-rate-limit", 20);
        this.baseTickRate = this.getConfig("level-settings.base-tick-rate", 1);
        this.alwaysTickPlayers = this.getConfig("level-settings.always-tick-players", false);
        this.autoSaveTicks = this.getConfig("ticks-per.autosave", 6000);
        this.shouldSavePlayerData = this.getConfig("player.save-player-data", true);
        this.skinChangeCooldown = this.getConfig("player.skin-change-cooldown", 15);
        this.attackStopSprint = this.getConfig("player.attack-stop-sprint", true);
        this.chunksPerTick = this.getConfig("chunk-sending.per-tick", 4);
        this.spawnThreshold = this.getConfig("spawn-threshold", 56);
        this.cacheChunks = this.getConfig("cache-chunks", false);
        this.spawnThresholdRadius = (int)Math.ceil(Math.sqrt(this.spawnThreshold));
        this.maxPlayers = this.getPropertyInt("max-players", 20);
        this.xboxAuth = this.getPropertyBoolean("xbox-auth", true);
        this.achievementsEnabled = this.getPropertyBoolean("achievements", true);
        this.pvpEnabled = this.getPropertyBoolean("pvp", true);
        this.announceAchievements = this.getPropertyBoolean("announce-player-achievements", true);
        this.allowFlight = this.getPropertyBoolean("allow-flight", false);
        this.isHardcore = this.getPropertyBoolean("hardcore", false);
        this.forceResources = this.getPropertyBoolean("force-resources", false);
        this.forceResourcesAllowOwnPacks = this.getPropertyBoolean("force-resources-allow-client-packs", false);
        this.whitelistEnabled = this.getPropertyBoolean("white-list", false);
        this.forceGamemode = this.getPropertyBoolean("force-gamemode", false);
        this.motd = this.getPropertyString("motd", "A Minecraft Server");
        this.viewDistance = this.getPropertyInt("view-distance", 10);
        this.port = this.getPropertyInt("server-port", 19132);
        this.ip = this.getPropertyString("server-ip", "0.0.0.0");
        this.spawnRadius = this.getPropertyInt("spawn-protection", 16);
        this.setAutoSave(this.getPropertyBoolean("auto-save", true));
        try {
            this.gamemode = this.getPropertyInt("gamemode", 0) & 3;
        }
        catch (NumberFormatException exception) {
            this.gamemode = Server.getGamemodeFromString(this.getPropertyString("gamemode", "0")) & 3;
        }
        if (this.isHardcore && this.difficulty < 3) {
            this.setDifficulty(3);
        } else {
            this.setDifficulty(Server.getDifficultyFromString(this.getPropertyString("difficulty", "2")));
        }
    }

    static /* synthetic */ Level[] access$002(Server x0, Level[] x1) {
        x0.levelArray = x1;
        return x1;
    }

    static {
        UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}.dat$");
        QUERY_PREFIX = new byte[]{-2, -3};
    }

    private class ConsoleThread
    extends Thread
    implements InterruptibleThread {
        private ConsoleThread() {
        }

        @Override
        public void run() {
            Server.this.console.start();
        }
    }

    private static class ServerProperties
    extends ConfigSection {
        private ServerProperties() {
            this.put("motd", "A Minecraft Server");
            this.put("sub-motd", "Powered by Nukkit");
            this.put("server-port", 19132);
            this.put("server-ip", "0.0.0.0");
            this.put("view-distance", 10);
            this.put("achievements", true);
            this.put("announce-player-achievements", true);
            this.put("spawn-protection", 16);
            this.put("gamemode", 0);
            this.put("force-gamemode", false);
            this.put("difficulty", 2);
            this.put("hardcore", false);
            this.put("pvp", true);
            this.put("white-list", false);
            this.put("generator-settings", "");
            this.put("level-name", "world");
            this.put("level-seed", "");
            this.put("level-type", "default");
            this.put("enable-rcon", false);
            this.put("rcon.password", Base64.getEncoder().encodeToString(UUID.randomUUID().toString().replace("-", "").getBytes()).substring(3, 13));
            this.put("force-resources", false);
            this.put("force-resources-allow-client-packs", false);
            this.put("xbox-auth", true);
            this.put("auto-save", true);
            this.put("force-language", false);
            this.put("enable-query", false);
            this.put("allow-flight", false);
            this.put("allow-nether", true);
            this.put("allow-the-end", true);
        }
    }
}

