/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityEvent;
import cn.nukkit.event.entity.EntityRegainHealthEvent;
import cn.nukkit.event.player.PlayerFoodLevelChangeEvent;
import cn.nukkit.item.food.Food;
import cn.nukkit.potion.Effect;

public class PlayerFood {
    private int foodLevel;
    private float foodSaturationLevel;
    private int foodTickTimer;
    private double foodExpLevel;
    private final Player player;

    public PlayerFood(Player player, int foodLevel, float foodSaturationLevel) {
        this.player = player;
        this.foodLevel = foodLevel;
        this.foodSaturationLevel = foodSaturationLevel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getLevel() {
        return this.foodLevel;
    }

    public int getMaxLevel() {
        return 20;
    }

    public void setLevel(int foodLevel) {
        this.setLevel(foodLevel, -1.0f);
    }

    public void setLevel(int foodLevel, float saturationLevel) {
        if (foodLevel > 20) {
            foodLevel = 20;
        }
        if (foodLevel < 0) {
            foodLevel = 0;
        }
        if (foodLevel <= 6 && this.foodLevel > 6 && this.player.isSprinting()) {
            this.player.setSprinting(false);
        }
        PlayerFoodLevelChangeEvent ev = new PlayerFoodLevelChangeEvent(this.player, foodLevel, saturationLevel);
        this.player.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            this.sendFoodLevel(this.foodLevel);
            return;
        }
        int foodLevel0 = ev.getFoodLevel();
        float fsl = ev.getFoodSaturationLevel();
        this.foodLevel = foodLevel;
        if (fsl != -1.0f) {
            if (fsl > (float)foodLevel) {
                fsl = foodLevel;
            }
            this.foodSaturationLevel = fsl;
        }
        this.foodLevel = foodLevel0;
        this.sendFoodLevel();
    }

    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodSaturationLevel(float fsl) {
        if (fsl > (float)this.foodLevel) {
            fsl = this.foodLevel;
        }
        if (fsl < 0.0f) {
            fsl = 0.0f;
        }
        PlayerFoodLevelChangeEvent ev = new PlayerFoodLevelChangeEvent(this.player, this.foodLevel, fsl);
        this.player.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.foodSaturationLevel = fsl = ev.getFoodSaturationLevel();
    }

    public void useHunger() {
        this.useHunger(1);
    }

    public void useHunger(int amount) {
        float sfl = this.foodSaturationLevel;
        int foodLevel = this.foodLevel;
        if (sfl > 0.0f) {
            float newSfl = sfl - (float)amount;
            if (newSfl < 0.0f) {
                newSfl = 0.0f;
            }
            this.setFoodSaturationLevel(newSfl);
        } else {
            this.setLevel(foodLevel - amount);
        }
    }

    public void addFoodLevel(Food food) {
        this.addFoodLevel(food.getRestoreFood(), food.getRestoreSaturation());
    }

    public void addFoodLevel(int foodLevel, float fsl) {
        this.setLevel(this.foodLevel + foodLevel, this.foodSaturationLevel + fsl);
    }

    public void sendFoodLevel() {
        this.sendFoodLevel(this.foodLevel);
    }

    public void reset() {
        this.foodLevel = 20;
        this.foodSaturationLevel = 20.0f;
        this.foodExpLevel = 0.0;
        this.foodTickTimer = 0;
        this.sendFoodLevel();
    }

    public void sendFoodLevel(int foodLevel) {
        if (this.player.spawned) {
            this.player.setAttribute(Attribute.getAttribute(7).setValue(foodLevel).setDefaultValue(this.getMaxLevel()));
        }
    }

    public void update(int tickDiff) {
        if (!this.player.isFoodEnabled()) {
            return;
        }
        if (this.player.isAlive()) {
            Effect hunger;
            EntityEvent ev;
            int diff = Server.getInstance().getDifficulty();
            if (this.foodLevel > 17 || diff == 0) {
                this.foodTickTimer += tickDiff;
                if (this.foodTickTimer >= 80) {
                    if (this.player.getHealth() < (float)this.player.getRealMaxHealth()) {
                        ev = new EntityRegainHealthEvent(this.player, 1.0f, 1);
                        this.player.heal((EntityRegainHealthEvent)ev);
                        this.updateFoodExpLevel(6.0);
                    }
                    this.foodTickTimer = 0;
                }
            } else if (this.foodLevel == 0) {
                this.foodTickTimer += tickDiff;
                if (this.foodTickTimer >= 80) {
                    ev = new EntityDamageEvent((Entity)this.player, EntityDamageEvent.DamageCause.HUNGER, 1.0f);
                    float now = this.player.getHealth();
                    if (diff == 1) {
                        if (now > 10.0f) {
                            this.player.attack((EntityDamageEvent)ev);
                        }
                    } else if (diff == 2) {
                        if (now > 1.0f) {
                            this.player.attack((EntityDamageEvent)ev);
                        }
                    } else {
                        this.player.attack((EntityDamageEvent)ev);
                    }
                    this.foodTickTimer = 0;
                }
            }
            if ((hunger = this.player.getEffect(17)) != null) {
                this.updateFoodExpLevel(0.1 * (double)(hunger.getAmplifier() + 1));
            }
        }
    }

    public void updateFoodExpLevel(double use) {
        if (!this.player.isFoodEnabled()) {
            return;
        }
        if (Server.getInstance().getDifficulty() == 0) {
            return;
        }
        if (this.player.hasEffect(23)) {
            return;
        }
        this.foodExpLevel += use;
        if (this.foodExpLevel > 4.0) {
            this.useHunger(1);
            this.foodExpLevel = 0.0;
        }
    }

    @Deprecated
    public void setFoodLevel(int foodLevel) {
        this.setLevel(foodLevel);
    }

    @Deprecated
    public void setFoodLevel(int foodLevel, float saturationLevel) {
        this.setLevel(foodLevel, saturationLevel);
    }

    public String toString() {
        return "PlayerFood(player= " + this.player + ", foodLevel=" + this.foodLevel + ", foodSaturationLevel=" + this.foodSaturationLevel + ", foodTickTimer=" + this.foodTickTimer + ", foodExpLevel=" + this.foodExpLevel + ")";
    }
}

