/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Achievement;
import cn.nukkit.AdventureSettings;
import cn.nukkit.IPlayer;
import cn.nukkit.Nukkit;
import cn.nukkit.PlayerFood;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDoor;
import cn.nukkit.block.BlockDragonEgg;
import cn.nukkit.block.BlockEnderChest;
import cn.nukkit.block.BlockNetherPortal;
import cn.nukkit.block.BlockNoteblock;
import cn.nukkit.block.BlockRespawnAnchor;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandDataVersions;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityControllable;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.custom.EntityManager;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.data.IntPositionEntityData;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.entity.item.EntityChestBoat;
import cn.nukkit.entity.item.EntityFirework;
import cn.nukkit.entity.item.EntityFishingHook;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.event.block.WaterFrostEvent;
import cn.nukkit.event.entity.EntityDamageBlockedEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityMotionEvent;
import cn.nukkit.event.entity.EntityPortalEnterEvent;
import cn.nukkit.event.entity.EntityPotionEffectEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.event.inventory.InventoryCloseEvent;
import cn.nukkit.event.inventory.InventoryPickupArrowEvent;
import cn.nukkit.event.inventory.InventoryPickupItemEvent;
import cn.nukkit.event.inventory.InventoryPickupTridentEvent;
import cn.nukkit.event.player.PlayerAchievementAwardedEvent;
import cn.nukkit.event.player.PlayerAnimationEvent;
import cn.nukkit.event.player.PlayerAsyncPreLoginEvent;
import cn.nukkit.event.player.PlayerBedEnterEvent;
import cn.nukkit.event.player.PlayerBedLeaveEvent;
import cn.nukkit.event.player.PlayerBlockPickEvent;
import cn.nukkit.event.player.PlayerChangeSkinEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerChunkRequestEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerDeathEvent;
import cn.nukkit.event.player.PlayerEditBookEvent;
import cn.nukkit.event.player.PlayerExperienceChangeEvent;
import cn.nukkit.event.player.PlayerFormRespondedEvent;
import cn.nukkit.event.player.PlayerGameModeChangeEvent;
import cn.nukkit.event.player.PlayerInteractEntityEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerInvalidMoveEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerJumpEvent;
import cn.nukkit.event.player.PlayerKickEvent;
import cn.nukkit.event.player.PlayerLocallyInitializedEvent;
import cn.nukkit.event.player.PlayerLoginEvent;
import cn.nukkit.event.player.PlayerMapInfoRequestEvent;
import cn.nukkit.event.player.PlayerMouseOverEntityEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerPreLoginEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.event.player.PlayerRespawnEvent;
import cn.nukkit.event.player.PlayerServerSettingsRequestEvent;
import cn.nukkit.event.player.PlayerSettingsRespondedEvent;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.event.player.PlayerToggleCrawlEvent;
import cn.nukkit.event.player.PlayerToggleFlightEvent;
import cn.nukkit.event.player.PlayerToggleGlideEvent;
import cn.nukkit.event.player.PlayerToggleSneakEvent;
import cn.nukkit.event.player.PlayerToggleSpinAttackEvent;
import cn.nukkit.event.player.PlayerToggleSprintEvent;
import cn.nukkit.event.player.PlayerToggleSwimEvent;
import cn.nukkit.event.server.DataPacketReceiveEvent;
import cn.nukkit.event.server.DataPacketSendEvent;
import cn.nukkit.form.handler.FormResponseHandler;
import cn.nukkit.form.window.FormWindow;
import cn.nukkit.form.window.FormWindowCustom;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BigCraftingGrid;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.CraftingGrid;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.PlayerCursorInventory;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.SmithingInventory;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import cn.nukkit.inventory.transaction.EnchantTransaction;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.LoomTransaction;
import cn.nukkit.inventory.transaction.RepairItemTransaction;
import cn.nukkit.inventory.transaction.SmithingTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.data.ReleaseItemData;
import cn.nukkit.inventory.transaction.data.UseItemData;
import cn.nukkit.inventory.transaction.data.UseItemOnEntityData;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArrow;
import cn.nukkit.item.ItemBookAndQuill;
import cn.nukkit.item.ItemBookWritten;
import cn.nukkit.item.ItemCrossbow;
import cn.nukkit.item.ItemDurable;
import cn.nukkit.item.ItemFishingRod;
import cn.nukkit.item.ItemMap;
import cn.nukkit.item.custom.CustomItemManager;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.ChunkLoader;
import cn.nukkit.level.EnumLevel;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.particle.ItemBreakParticle;
import cn.nukkit.level.particle.PunchBlockParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.CompressionProvider;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.encryption.PrepareEncryptionTask;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.AvailableCommandsPacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.BiomeDefinitionListPacket;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.BlockPickRequestPacket;
import cn.nukkit.network.protocol.BookEditPacket;
import cn.nukkit.network.protocol.ChangeDimensionPacket;
import cn.nukkit.network.protocol.ChunkRadiusUpdatedPacket;
import cn.nukkit.network.protocol.ClientboundCloseFormPacket;
import cn.nukkit.network.protocol.CommandRequestPacket;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.DeathInfoPacket;
import cn.nukkit.network.protocol.DisconnectPacket;
import cn.nukkit.network.protocol.EmotePacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.network.protocol.GameRulesChangedPacket;
import cn.nukkit.network.protocol.InteractPacket;
import cn.nukkit.network.protocol.InventorySlotPacket;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import cn.nukkit.network.protocol.LecternUpdatePacket;
import cn.nukkit.network.protocol.LevelChunkPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.MapInfoRequestPacket;
import cn.nukkit.network.protocol.MobEquipmentPacket;
import cn.nukkit.network.protocol.ModalFormRequestPacket;
import cn.nukkit.network.protocol.ModalFormResponsePacket;
import cn.nukkit.network.protocol.MovePlayerPacket;
import cn.nukkit.network.protocol.NetworkChunkPublisherUpdatePacket;
import cn.nukkit.network.protocol.NetworkSettingsPacket;
import cn.nukkit.network.protocol.PacketViolationWarningPacket;
import cn.nukkit.network.protocol.PlayStatusPacket;
import cn.nukkit.network.protocol.PlayerActionPacket;
import cn.nukkit.network.protocol.PlayerAuthInputPacket;
import cn.nukkit.network.protocol.PlayerHotbarPacket;
import cn.nukkit.network.protocol.PlayerSkinPacket;
import cn.nukkit.network.protocol.PlayerStartItemCooldownPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.network.protocol.RequestChunkRadiusPacket;
import cn.nukkit.network.protocol.RequestNetworkSettingsPacket;
import cn.nukkit.network.protocol.ResourcePackChunkDataPacket;
import cn.nukkit.network.protocol.ResourcePackChunkRequestPacket;
import cn.nukkit.network.protocol.ResourcePackClientResponsePacket;
import cn.nukkit.network.protocol.ResourcePackDataInfoPacket;
import cn.nukkit.network.protocol.ResourcePackStackPacket;
import cn.nukkit.network.protocol.ResourcePacksInfoPacket;
import cn.nukkit.network.protocol.RespawnPacket;
import cn.nukkit.network.protocol.ServerSettingsResponsePacket;
import cn.nukkit.network.protocol.ServerToClientHandshakePacket;
import cn.nukkit.network.protocol.SetCommandsEnabledPacket;
import cn.nukkit.network.protocol.SetDefaultGameTypePacket;
import cn.nukkit.network.protocol.SetDifficultyPacket;
import cn.nukkit.network.protocol.SetEntityMotionPacket;
import cn.nukkit.network.protocol.SetHudPacket;
import cn.nukkit.network.protocol.SetPlayerGameTypePacket;
import cn.nukkit.network.protocol.SetSpawnPositionPacket;
import cn.nukkit.network.protocol.SetTitlePacket;
import cn.nukkit.network.protocol.SettingsCommandPacket;
import cn.nukkit.network.protocol.ShowProfilePacket;
import cn.nukkit.network.protocol.StartGamePacket;
import cn.nukkit.network.protocol.TakeItemEntityPacket;
import cn.nukkit.network.protocol.TextPacket;
import cn.nukkit.network.protocol.ToastRequestPacket;
import cn.nukkit.network.protocol.TransferPacket;
import cn.nukkit.network.protocol.UpdateAttributesPacket;
import cn.nukkit.network.protocol.types.AuthInputAction;
import cn.nukkit.network.protocol.types.HudElement;
import cn.nukkit.network.protocol.types.NetworkInventoryAction;
import cn.nukkit.network.protocol.types.PacketCompressionAlgorithm;
import cn.nukkit.network.protocol.types.PlayerActionType;
import cn.nukkit.network.protocol.types.PlayerBlockActionData;
import cn.nukkit.network.session.NetworkPlayerSession;
import cn.nukkit.permission.PermissibleBase;
import cn.nukkit.permission.Permission;
import cn.nukkit.permission.PermissionAttachment;
import cn.nukkit.permission.PermissionAttachmentInfo;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.resourcepacks.ResourcePack;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.BlockIterator;
import cn.nukkit.utils.ClientChainData;
import cn.nukkit.utils.DummyBossBar;
import cn.nukkit.utils.LoginChainData;
import cn.nukkit.utils.SnappyCompression;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Zlib;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import io.netty.util.internal.PlatformDependent;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Player
extends EntityHuman
implements CommandSender,
InventoryHolder,
ChunkLoader,
IPlayer {
    @Generated
    private static final Logger log = LogManager.getLogger(Player.class);
    public static final int SURVIVAL = 0;
    public static final int CREATIVE = 1;
    public static final int ADVENTURE = 2;
    public static final int SPECTATOR = 3;
    public static final int CRAFTING_SMALL = 0;
    public static final int CRAFTING_BIG = 1;
    public static final int CRAFTING_ANVIL = 2;
    public static final int CRAFTING_ENCHANT = 3;
    public static final int CRAFTING_BEACON = 4;
    public static final int CRAFTING_SMITHING = 1003;
    public static final int CRAFTING_LOOM = 1004;
    public static final float DEFAULT_SPEED = 0.1f;
    public static final float MAXIMUM_SPEED = 6.0f;
    public static final float DEFAULT_FLY_SPEED = 0.05f;
    public static final int PERMISSION_CUSTOM = 3;
    public static final int PERMISSION_OPERATOR = 2;
    public static final int PERMISSION_MEMBER = 1;
    public static final int PERMISSION_VISITOR = 0;
    public static final int ANVIL_WINDOW_ID = 2;
    public static final int ENCHANT_WINDOW_ID = 3;
    public static final int BEACON_WINDOW_ID = 4;
    public static final int LOOM_WINDOW_ID = 2;
    public static final int SMITHING_WINDOW_ID = 6;
    protected static final int RESOURCE_PACK_CHUNK_SIZE = 8192;
    protected final SourceInterface interfaz;
    protected final NetworkPlayerSession networkSession;
    @Deprecated
    public long creationTime;
    public boolean playedBefore;
    public boolean spawned;
    public boolean loggedIn;
    private boolean loginVerified;
    private boolean loginPacketReceived;
    protected boolean networkSettingsRequested;
    public int gamemode;
    protected long randomClientId;
    private String unverifiedUsername = "";
    protected final BiMap<Inventory, Integer> windows = HashBiMap.create();
    protected final BiMap<Integer, Inventory> windowIndex = this.windows.inverse();
    protected final Set<Integer> permanentWindows = new IntOpenHashSet();
    private boolean inventoryOpen;
    protected int windowCnt = 4;
    protected int closingWindowId = Integer.MIN_VALUE;
    public final HashSet<String> achievements = new HashSet();
    public int craftingType = 0;
    protected PlayerUIInventory playerUIInventory;
    protected CraftingGrid craftingGrid;
    protected CraftingTransaction craftingTransaction;
    protected EnchantTransaction enchantTransaction;
    protected RepairItemTransaction repairItemTransaction;
    protected LoomTransaction loomTransaction;
    protected SmithingTransaction smithingTransaction;
    public Vector3 speed;
    protected Vector3 forceMovement;
    protected Vector3 teleportPosition;
    protected Vector3 newPosition;
    protected Vector3 sleeping;
    private Vector3 lastRightClickPos;
    private final Queue<Vector3> clientMovements = PlatformDependent.newMpscQueue(4);
    protected boolean connected = true;
    protected final InetSocketAddress socketAddress;
    protected boolean removeFormat = true;
    protected String username;
    protected String iusername;
    protected String displayName;
    private boolean hasSpawnChunks;
    private final int loaderId;
    private int chunksSent;
    protected int nextChunkOrderRun = 1;
    protected int chunkRadius;
    protected int viewDistance;
    public final Map<Long, Boolean> usedChunks = new Long2ObjectOpenHashMap<Boolean>();
    protected final Long2ObjectLinkedOpenHashMap<Boolean> loadQueue = new Long2ObjectLinkedOpenHashMap();
    protected final Map<UUID, Player> hiddenPlayers = new HashMap<UUID, Player>();
    protected Position spawnPosition;
    protected int inAirTicks;
    protected int startAirTicks = 10;
    protected AdventureSettings adventureSettings;
    private PermissibleBase perm;
    private boolean canTickShield = true;
    private int exp;
    private int expLevel;
    protected PlayerFood foodData;
    private Entity killer;
    private final AtomicReference<Locale> locale = new AtomicReference<Object>(null);
    private int hash;
    private String buttonText = "";
    protected boolean enableClientCommand = true;
    private BlockEnderChest viewingEnderChest;
    private LoginChainData loginChainData;
    public int pickedXPOrb;
    private boolean canPickupXP = true;
    protected int formWindowCount;
    protected Map<Integer, FormWindow> formWindows = new Int2ObjectOpenHashMap<FormWindow>();
    protected Map<Integer, FormWindow> serverSettings = new Int2ObjectOpenHashMap<FormWindow>();
    protected Map<Long, DummyBossBar> dummyBossBars = new Long2ObjectLinkedOpenHashMap<DummyBossBar>();
    private AsyncTask preLoginEventTask;
    protected boolean shouldLogin;
    private static Stream<Field> pkIDs;
    protected int startAction = -1;
    private int lastEmote;
    protected int lastEnderPearl = 20;
    protected int lastChorusFruitTeleport = 20;
    protected int lastFireworkBoost = 20;
    public long lastSkinChange = -1L;
    private double lastRightClickTime;
    public long lastBreak = -1L;
    private BlockVector3 lastBreakPosition = new BlockVector3();
    public Block breakingBlock;
    private BlockFace breakingBlockFace;
    private PlayerBlockActionData lastBlockAction;
    public EntityFishingHook fishing;
    private boolean formOpen;
    private boolean flySneaking;
    public boolean locallyInitialized;
    private boolean foodEnabled = true;
    protected boolean checkMovement = true;
    private int timeSinceRest;
    private boolean inSoulSand;
    private boolean dimensionChangeInProgress;
    private boolean awaitingDimensionAck;
    private boolean awaitingEncryptionHandshake;
    private int riderJumpTick;
    private int riptideTicks;
    private int blockingDelay;
    private int fireworkBoostTicks;
    private int fireworkBoostLevel;
    private boolean needSendData;
    private boolean needSendAdventureSettings;
    private boolean needSendFoodLevel;
    private boolean needSendInventory;
    private boolean needSendHeldItem;
    private boolean needSendRotation;
    private boolean dimensionFix560;
    private int crossbowLoadTick;
    private static final Set<Byte> PRE_LOGIN_PACKETS;
    private static final String MSG_FLYING_NOT_ENABLED = "Flying is not enabled on this server";

    public int getStartActionTick() {
        return this.startAction;
    }

    public void startAction() {
        this.startAction = this.server.getTick();
    }

    public void stopAction() {
        this.startAction = -1;
    }

    public int getLastEnderPearlThrowingTick() {
        return this.lastEnderPearl;
    }

    public void onThrowEnderPearl() {
        this.lastEnderPearl = this.server.getTick();
    }

    public int getLastChorusFruitTeleport() {
        return this.lastChorusFruitTeleport;
    }

    public void onChorusFruitTeleport() {
        this.lastChorusFruitTeleport = this.server.getTick();
    }

    public int getLastFireworkBoostTick() {
        return this.lastFireworkBoost;
    }

    public void onFireworkBoost(int boostLevel) {
        this.lastFireworkBoost = this.server.getTick();
        this.fireworkBoostLevel = boostLevel;
        this.fireworkBoostTicks = boostLevel == 3 ? 44 : (boostLevel == 2 ? 29 : 23);
    }

    public void onSpinAttack(int riptideLevel) {
        this.riptideTicks = 50 + (riptideLevel << 5);
    }

    public BlockEnderChest getViewingEnderChest() {
        return this.viewingEnderChest;
    }

    public void setViewingEnderChest(BlockEnderChest chest) {
        if (chest == null && this.viewingEnderChest != null) {
            this.viewingEnderChest.getViewers().remove(this);
        } else if (chest != null) {
            chest.getViewers().add(this);
        }
        this.viewingEnderChest = chest;
    }

    public TranslationContainer getLeaveMessage() {
        return new TranslationContainer((Object)((Object)TextFormat.YELLOW) + "%multiplayer.player.left", this.displayName);
    }

    @Deprecated
    public String getClientSecret() {
        return null;
    }

    @Deprecated
    public Long getClientId() {
        return this.randomClientId;
    }

    @Override
    public boolean isBanned() {
        return this.server.getNameBans().isBanned(this.username);
    }

    @Override
    public void setBanned(boolean value) {
        if (value) {
            this.server.getNameBans().addBan(this.username, null, null, null);
            this.kick(PlayerKickEvent.Reason.NAME_BANNED, "You are banned!");
        } else {
            this.server.getNameBans().remove(this.username);
        }
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.isWhitelisted(this.iusername);
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.addWhitelist(this.iusername);
        } else {
            this.server.removeWhitelist(this.iusername);
        }
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    @Override
    public Long getFirstPlayed() {
        return this.namedTag != null ? Long.valueOf(this.namedTag.getLong("firstPlayed")) : null;
    }

    @Override
    public Long getLastPlayed() {
        return this.namedTag != null ? Long.valueOf(this.namedTag.getLong("lastPlayed")) : null;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.playedBefore;
    }

    public AdventureSettings getAdventureSettings() {
        return this.adventureSettings;
    }

    public void setAdventureSettings(AdventureSettings adventureSettings) {
        this.adventureSettings = adventureSettings.clone(this);
        this.adventureSettings.update();
    }

    public void resetInAirTicks() {
        if (this.inAirTicks != 0) {
            this.startAirTicks = 10;
        }
        this.inAirTicks = 0;
    }

    @Deprecated
    public void setAllowFlight(boolean value) {
        this.adventureSettings.set(AdventureSettings.Type.ALLOW_FLIGHT, value);
        this.adventureSettings.update();
    }

    @Deprecated
    public boolean getAllowFlight() {
        return this.adventureSettings.get(AdventureSettings.Type.ALLOW_FLIGHT);
    }

    public void setAllowModifyWorld(boolean value) {
        this.adventureSettings.set(AdventureSettings.Type.WORLD_IMMUTABLE, !value);
        this.adventureSettings.set(AdventureSettings.Type.MINE, value);
        this.adventureSettings.set(AdventureSettings.Type.BUILD, value);
        this.adventureSettings.update();
    }

    public void setAllowInteract(boolean value) {
        this.setAllowInteract(value, value);
    }

    public void setAllowInteract(boolean value, boolean containers) {
        this.adventureSettings.set(AdventureSettings.Type.WORLD_IMMUTABLE, !value);
        this.adventureSettings.set(AdventureSettings.Type.DOORS_AND_SWITCHED, value);
        this.adventureSettings.set(AdventureSettings.Type.OPEN_CONTAINERS, containers);
        this.adventureSettings.update();
    }

    @Deprecated
    public void setAutoJump(boolean value) {
        this.adventureSettings.set(AdventureSettings.Type.AUTO_JUMP, value);
        this.adventureSettings.update();
    }

    @Deprecated
    public boolean hasAutoJump() {
        return this.adventureSettings.get(AdventureSettings.Type.AUTO_JUMP);
    }

    @Override
    public void spawnTo(Player player) {
        if (this.spawned && player.spawned && this.isAlive() && player.isAlive() && player.getLevel() == this.level && player.canSee(this) && !this.isSpectator()) {
            super.spawnTo(player);
        }
    }

    public boolean getRemoveFormat() {
        return this.removeFormat;
    }

    public void setRemoveFormat() {
        this.setRemoveFormat(true);
    }

    public void setRemoveFormat(boolean remove) {
        this.removeFormat = remove;
    }

    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getUniqueId());
    }

    public void hidePlayer(Player player) {
        if (this == player) {
            return;
        }
        this.hiddenPlayers.put(player.getUniqueId(), player);
        player.despawnFrom(this);
    }

    public void showPlayer(Player player) {
        if (this == player) {
            return;
        }
        this.hiddenPlayers.remove(player.getUniqueId());
        if (player.isOnline()) {
            player.spawnTo(this);
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public boolean canPickupXP() {
        return this.canPickupXP;
    }

    public void setCanPickupXP(boolean canPickupXP) {
        this.canPickupXP = canPickupXP;
    }

    @Override
    public void resetFallDistance() {
        super.resetFallDistance();
        this.resetInAirTicks();
    }

    @Override
    public boolean isOnline() {
        return this.connected && this.loggedIn;
    }

    @Override
    public boolean isOp() {
        return this.server.isOp(this.username);
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.addOp(this.username);
        } else {
            this.server.removeOp(this.username);
        }
        this.recalculatePermissions();
        this.adventureSettings.update();
        this.sendCommandData();
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission permission) {
        return this.perm.isPermissionSet(permission);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm != null && this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.perm.hasPermission(permission);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.addAttachment(plugin, null);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name) {
        return this.addAttachment(plugin, name, null);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, Boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.user", this);
        this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.admin", this);
        if (this.perm == null) {
            return;
        }
        this.perm.recalculatePermissions();
        if (this.hasPermission("nukkit.broadcast.user")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.user", this);
        }
        if (this.hasPermission("nukkit.broadcast.admin")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.admin", this);
        }
        if (this.enableClientCommand && this.spawned) {
            this.sendCommandData();
        }
    }

    public boolean isEnableClientCommand() {
        return this.enableClientCommand;
    }

    public void setEnableClientCommand(boolean enable) {
        this.enableClientCommand = enable;
        SetCommandsEnabledPacket pk = new SetCommandsEnabledPacket();
        pk.enabled = enable;
        this.dataPacket(pk);
        if (enable) {
            this.sendCommandData();
        }
    }

    public void sendCommandData() {
        AvailableCommandsPacket pk = new AvailableCommandsPacket();
        HashMap<String, CommandDataVersions> data = new HashMap<String, CommandDataVersions>();
        for (Command command : this.server.getCommandMap().getCommands().values()) {
            CommandDataVersions commandData;
            if (!command.isRegistered() || "help".equals(command.getName()) || (commandData = command.generateCustomCommandData(this)) == null) continue;
            data.put(command.getName(), commandData);
        }
        if (!data.isEmpty()) {
            pk.commands = data;
            this.dataPacket(pk);
        }
    }

    @Override
    public Map<String, PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public Player(SourceInterface interfaz, Long clientID, InetSocketAddress socketAddress) {
        super(null, new CompoundTag());
        this.interfaz = interfaz;
        this.networkSession = interfaz.getSession(socketAddress);
        this.perm = new PermissibleBase(this);
        this.server = Server.getInstance();
        this.socketAddress = socketAddress;
        this.loaderId = Level.generateChunkLoaderId(this);
        this.gamemode = this.server.getGamemode();
        this.setLevel(this.server.getDefaultLevel());
        this.chunkRadius = this.viewDistance = this.server.getViewDistance();
        this.boundingBox = new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.addDefaultWindows();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    public void removeAchievement(String achievementId) {
        this.achievements.remove(achievementId);
    }

    public boolean hasAchievement(String achievementId) {
        return this.achievements.contains(achievementId);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
            this.server.getLogger().debug("Warning: setDisplayName: argument is null", new Throwable(""));
        }
        this.displayName = displayName;
        if (this.spawned) {
            this.server.updatePlayerListData(this.getUniqueId(), this.getId(), this.displayName, this.getSkin(), this.loginChainData.getXUID());
        }
    }

    @Override
    public void setSkin(Skin skin) {
        super.setSkin(skin);
        if (this.spawned) {
            this.server.updatePlayerListData(this.getUniqueId(), this.getId(), this.displayName, skin, this.loginChainData.getXUID());
        }
    }

    public String getAddress() {
        return this.socketAddress.getAddress().getHostAddress();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public Position getNextPosition() {
        return this.newPosition != null ? new Position(this.newPosition.x, this.newPosition.y, this.newPosition.z, this.level) : this.getPosition();
    }

    public AxisAlignedBB getNextPositionBB() {
        if (this.newPosition == null) {
            return this.boundingBox;
        }
        Vector3 diff = this.newPosition.subtract(this);
        return this.boundingBox.getOffsetBoundingBox(diff.x, diff.y, diff.z);
    }

    public boolean isSleeping() {
        return this.sleeping != null;
    }

    public int getInAirTicks() {
        return this.inAirTicks;
    }

    public boolean isUsingItem() {
        return this.startAction > -1 && this.getDataFlag(0, 4);
    }

    public void setUsingItem(boolean value) {
        this.startAction = value ? this.server.getTick() : -1;
        this.setDataFlag(0, 4, value);
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String text) {
        if (text == null) {
            text = "";
            this.server.getLogger().debug("Warning: setButtonText: argument is null", new Throwable(""));
        }
        if (!text.equals(this.buttonText)) {
            this.buttonText = text;
            this.setDataPropertyAndSendOnlyToSelf(new StringEntityData(100, this.buttonText));
        }
    }

    public void unloadChunk(int x, int z) {
        this.unloadChunk(x, z, null);
    }

    public void unloadChunk(int x, int z, Level level) {
        level = level == null ? this.level : level;
        long index = Level.chunkHash(x, z);
        if (this.usedChunks.containsKey(index)) {
            for (Entity entity : level.getChunkEntities(x, z).values()) {
                if (entity == this) continue;
                entity.despawnFrom(this);
            }
            this.usedChunks.remove(index);
        }
        level.unregisterChunkLoader(this, x, z);
        this.loadQueue.remove(index);
    }

    private void unloadChunks(boolean online) {
        for (long index : this.usedChunks.keySet()) {
            int chunkX = Level.getHashX(index);
            int chunkZ = Level.getHashZ(index);
            this.level.unregisterChunkLoader(this, chunkX, chunkZ);
            for (Entity entity : this.level.getChunkEntities(chunkX, chunkZ).values()) {
                if (entity == this) continue;
                if (online) {
                    entity.despawnFrom(this);
                    continue;
                }
                entity.hasSpawned.remove(this.loaderId);
            }
        }
        this.usedChunks.clear();
        this.loadQueue.clear();
    }

    public Position getSpawn() {
        if (this.spawnPosition != null && this.spawnPosition.getLevel() != null && this.spawnPosition.getLevel().getProvider() != null) {
            return this.spawnPosition.add(0.5, 0.0, 0.5);
        }
        return this.server.getDefaultLevel().getSafeSpawn();
    }

    @Nullable
    public Position getSpawnPosition() {
        return this.spawnPosition;
    }

    public void sendChunk(int x, int z, DataPacket packet) {
        if (!this.connected) {
            return;
        }
        this.usedChunks.put(Level.chunkHash(x, z), true);
        this.dataPacket(packet);
        ++this.chunksSent;
        if (this.spawned) {
            for (Entity entity : this.level.getChunkEntities(x, z).values()) {
                if (this == entity || entity.closed || !entity.isAlive()) continue;
                entity.spawnTo(this);
            }
        }
        if (this.dimensionFix560) {
            this.dimensionFix560 = false;
            PlayerActionPacket pap = new PlayerActionPacket();
            pap.action = 14;
            pap.entityId = this.getId();
            this.dataPacket(pap);
        }
    }

    public void sendChunk(int x, int z, int subChunkCount, byte[] payload, int dimension) {
        if (this.connected) {
            LevelChunkPacket pk = new LevelChunkPacket();
            pk.chunkX = x;
            pk.chunkZ = z;
            pk.dimension = dimension;
            pk.subChunkCount = subChunkCount;
            pk.data = payload;
            this.sendChunk(x, z, pk);
        }
    }

    protected void sendNextChunk() {
        if (!this.connected) {
            return;
        }
        if (!this.loadQueue.isEmpty()) {
            ObjectIterator iter = this.loadQueue.long2ObjectEntrySet().fastIterator();
            for (int count = 0; iter.hasNext() && count < this.server.chunksPerTick; ++count) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iter.next();
                long index = entry.getLongKey();
                int chunkX = Level.getHashX(index);
                int chunkZ = Level.getHashZ(index);
                try {
                    this.usedChunks.put(index, false);
                    this.level.registerChunkLoader(this, chunkX, chunkZ, false);
                    if (!this.level.populateChunk(chunkX, chunkZ)) {
                        if (!this.spawned || this.teleportPosition != null) break;
                        continue;
                    }
                    iter.remove();
                }
                catch (Exception ex) {
                    this.server.getLogger().logException(ex);
                    return;
                }
                PlayerChunkRequestEvent ev = new PlayerChunkRequestEvent(this, chunkX, chunkZ);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) continue;
                this.level.requestChunk(chunkX, chunkZ, this);
            }
        }
        if (!this.hasSpawnChunks && this.chunksSent >= this.server.spawnThreshold) {
            this.hasSpawnChunks = true;
            this.sendPlayStatus(3);
        }
    }

    protected void doFirstSpawn() {
        if (this.spawned) {
            return;
        }
        this.noDamageTicks = 60;
        this.setAirTicks(400);
        if (this.hasPermission("nukkit.broadcast.user")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.user", this);
        }
        if (this.hasPermission("nukkit.broadcast.admin")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.admin", this);
        }
        boolean dead = this.getHealth() < 1.0f;
        Position spawn = dead ? this.getSpawn() : this;
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(this, spawn.level.getSafeSpawn(spawn), true);
        this.server.getPluginManager().callEvent(respawnEvent);
        this.spawned = true;
        if (dead) {
            if (this.server.isHardcore()) {
                this.setBanned(true);
                return;
            }
            this.teleport(respawnEvent.getRespawnPosition(), null);
            this.setHealth(this.getMaxHealth());
            this.foodData.setLevel(20, 20.0f);
            this.sendData(this);
        } else {
            this.setPosition(respawnEvent.getRespawnPosition());
            this.sendPosition(respawnEvent.getRespawnPosition(), this.yaw, this.pitch, 2);
            this.forceMovement = this.teleportPosition = respawnEvent.getRespawnPosition();
            this.getLevel().sendTime(this);
            this.getLevel().sendWeather(this);
        }
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent(this, new TranslationContainer((Object)((Object)TextFormat.YELLOW) + "%multiplayer.player.joined", new String[]{this.displayName}));
        this.server.getPluginManager().callEvent(playerJoinEvent);
        if (!playerJoinEvent.getJoinMessage().toString().trim().isEmpty()) {
            this.server.broadcastMessage(playerJoinEvent.getJoinMessage());
        }
        for (long index : this.usedChunks.keySet()) {
            int chunkX = Level.getHashX(index);
            int chunkZ = Level.getHashZ(index);
            for (Entity entity : this.level.getChunkEntities(chunkX, chunkZ).values()) {
                if (this == entity || entity.closed || !entity.isAlive()) continue;
                entity.spawnTo(this);
            }
        }
        if (!this.isSpectator()) {
            this.spawnToAll();
        }
        if (!this.locallyInitialized) {
            this.server.getPluginManager().callEvent(new PlayerLocallyInitializedEvent(this));
            this.locallyInitialized = true;
        }
    }

    protected boolean orderChunks() {
        long index;
        if (!this.connected) {
            return false;
        }
        this.nextChunkOrderRun = 20;
        this.loadQueue.clear();
        Long2ObjectOpenHashMap<Boolean> lastChunk = new Long2ObjectOpenHashMap<Boolean>(this.usedChunks);
        int centerX = this.getChunkX();
        int centerZ = this.getChunkZ();
        int radius = this.spawned ? this.chunkRadius : this.server.spawnThresholdRadius;
        int radiusSqr = radius * radius;
        for (int x = 0; x <= radius; ++x) {
            int xx = x * x;
            for (int z = 0; z <= x; ++z) {
                int distanceSqr = xx + z * z;
                if (distanceSqr > radiusSqr) continue;
                index = Level.chunkHash(centerX + x, centerZ + z);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - x - 1, centerZ + z);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX + x, centerZ - z - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - x - 1, centerZ - z - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                if (x == z) continue;
                index = Level.chunkHash(centerX + z, centerZ + x);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - z - 1, centerZ + x);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX + z, centerZ - x - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - z - 1, centerZ - x - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
            }
        }
        LongIterator keys = lastChunk.keySet().iterator();
        while (keys.hasNext()) {
            index = keys.nextLong();
            this.unloadChunk(Level.getHashX(index), Level.getHashZ(index));
        }
        if (!this.loadQueue.isEmpty()) {
            NetworkChunkPublisherUpdatePacket packet = new NetworkChunkPublisherUpdatePacket();
            packet.position = this.asBlockVector3();
            packet.radius = this.chunkRadius << 4;
            this.dataPacket(packet);
        }
        return true;
    }

    @Deprecated
    public boolean batchDataPacket(DataPacket packet) {
        return this.dataPacket(packet);
    }

    public boolean dataPacket(DataPacket packet) {
        if (!this.connected) {
            return false;
        }
        DataPacket dataPacket = packet.clone();
        DataPacketSendEvent ev = new DataPacketSendEvent(this, dataPacket);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        if (Nukkit.DEBUG > 2 && !this.server.isIgnoredPacket(packet.getClass())) {
            log.trace("Outbound {}: {}", (Object)this.getName(), (Object)dataPacket);
        }
        if (dataPacket instanceof BatchPacket) {
            this.networkSession.sendPacket(dataPacket);
        } else {
            this.server.batchPackets(new Player[]{this}, new DataPacket[]{dataPacket});
        }
        return true;
    }

    @Deprecated
    public int dataPacket(DataPacket packet, boolean needACK) {
        return this.dataPacket(packet) ? 1 : 0;
    }

    @Deprecated
    public boolean directDataPacket(DataPacket packet) {
        return this.dataPacket(packet);
    }

    @Deprecated
    public int directDataPacket(DataPacket packet, boolean needACK) {
        return this.directDataPacket(packet) ? 1 : 0;
    }

    public void forceDataPacket(DataPacket packet, Runnable callback) {
        DataPacketSendEvent ev = new DataPacketSendEvent(this, packet);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        if (Nukkit.DEBUG > 2 && !this.server.isIgnoredPacket(packet.getClass())) {
            log.trace("Outbound {}: {}", (Object)this.getName(), (Object)packet);
        }
        this.networkSession.sendImmediatePacket(packet, callback == null ? () -> {} : callback);
    }

    public int getPing() {
        return this.interfaz.getNetworkLatency(this);
    }

    public boolean sleepOn(Vector3 pos) {
        Entity[] e;
        if (!this.isOnline()) {
            return false;
        }
        for (Entity p : e = this.level.getNearbyEntities(this.boundingBox.grow(2.0, 1.0, 2.0), this)) {
            if (!(p instanceof Player) || ((Player)p).sleeping == null || !(pos.distance(((Player)p).sleeping) <= 0.1)) continue;
            return false;
        }
        PlayerBedEnterEvent ev = new PlayerBedEnterEvent(this, this.level.getBlock(pos));
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.sleeping = pos.clone();
        this.teleport(new Location(pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, this.yaw, this.pitch, this.level), null);
        this.setDataProperty(new IntPositionEntityData(28, (int)pos.x, (int)pos.y, (int)pos.z));
        this.setDataFlag(26, 1, true);
        if (!pos.equals(this.getSpawnPosition())) {
            this.setSpawn(pos);
            this.sendMessage("\u00a77%tile.bed.respawnSet", true);
        }
        this.level.sleepTicks = 60;
        this.timeSinceRest = 0;
        return true;
    }

    public void setSpawn(Vector3 pos) {
        Level level = !(pos instanceof Position) ? this.level : ((Position)pos).getLevel();
        this.spawnPosition = pos instanceof Block ? ((Block)pos).clone().setLevel(level) : new Position(pos.x, pos.y, pos.z, level);
        this.sendSpawnPos((int)pos.x, (int)pos.y, (int)pos.z, level.getDimension());
    }

    private void sendSpawnPos(int x, int y, int z, int dimension) {
        SetSpawnPositionPacket pk = new SetSpawnPositionPacket();
        pk.spawnType = 0;
        pk.x = x;
        pk.y = y;
        pk.z = z;
        pk.dimension = dimension;
        this.dataPacket(pk);
    }

    public void stopSleep() {
        if (this.sleeping != null) {
            this.server.getPluginManager().callEvent(new PlayerBedLeaveEvent(this, this.level.getBlock(this.sleeping)));
            this.sleeping = null;
            this.setDataProperty(new IntPositionEntityData(28, 0, 0, 0));
            this.setDataFlag(26, 1, false);
            this.level.sleepTicks = 0;
            AnimatePacket pk = new AnimatePacket();
            pk.eid = this.id;
            pk.action = AnimatePacket.Action.WAKE_UP;
            this.dataPacket(pk);
        }
    }

    public Vector3 getSleepingPos() {
        return this.sleeping;
    }

    public boolean awardAchievement(String achievementId) {
        if (!this.server.achievementsEnabled) {
            return false;
        }
        Achievement achievement = Achievement.achievements.get(achievementId);
        if (achievement == null || this.hasAchievement(achievementId)) {
            return false;
        }
        for (String id : achievement.requires) {
            if (this.hasAchievement(id)) continue;
            return false;
        }
        PlayerAchievementAwardedEvent event = new PlayerAchievementAwardedEvent(this, achievementId);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.achievements.add(achievementId);
        achievement.broadcast(this);
        return true;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    private static int getClientFriendlyGamemode(int gamemode) {
        if ((gamemode &= 3) == 3) {
            return 1;
        }
        return gamemode;
    }

    public boolean setGamemode(int gamemode) {
        return this.setGamemode(gamemode, false, null);
    }

    public boolean setGamemode(int gamemode, boolean clientSide) {
        return this.setGamemode(gamemode, clientSide, null);
    }

    public boolean setGamemode(int gamemode, boolean clientSide, AdventureSettings newSettings) {
        if (gamemode < 0 || gamemode > 3 || this.gamemode == gamemode) {
            return false;
        }
        if (newSettings == null) {
            newSettings = this.adventureSettings.clone(this);
            newSettings.set(AdventureSettings.Type.WORLD_IMMUTABLE, (gamemode & 2) > 0);
            newSettings.set(AdventureSettings.Type.MINE, (gamemode & 2) <= 0);
            newSettings.set(AdventureSettings.Type.BUILD, (gamemode & 2) <= 0);
            newSettings.set(AdventureSettings.Type.NO_PVM, gamemode == 3);
            newSettings.set(AdventureSettings.Type.ALLOW_FLIGHT, (gamemode & 1) > 0);
            newSettings.set(AdventureSettings.Type.NO_CLIP, gamemode == 3);
            newSettings.set(AdventureSettings.Type.FLYING, (gamemode & 1) == 1);
        }
        PlayerGameModeChangeEvent ev = new PlayerGameModeChangeEvent(this, gamemode, newSettings);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.gamemode = gamemode;
        if (this.isSpectator()) {
            this.keepMovement = true;
            this.onGround = false;
            this.despawnFromAll();
        } else {
            this.keepMovement = false;
            this.spawnToAll();
        }
        this.namedTag.putInt("playerGameType", this.gamemode);
        if (!clientSide) {
            SetPlayerGameTypePacket pk = new SetPlayerGameTypePacket();
            pk.gamemode = Player.getClientFriendlyGamemode(gamemode);
            this.dataPacket(pk);
        }
        this.setAdventureSettings(ev.getNewAdventureSettings());
        if (this.isSpectator()) {
            this.teleport(this, null);
            this.setDataFlag(0, 17, true, false);
            this.setDataFlag(0, 48, false);
        } else {
            this.setDataFlag(0, 17, false, false);
            this.setDataFlag(0, 48, true);
        }
        this.resetFallDistance();
        this.inventory.sendContents(this);
        this.inventory.sendHeldItem(this.hasSpawned.values());
        this.offhandInventory.sendContents(this);
        this.offhandInventory.sendContents(this.getViewers().values());
        this.inventory.sendCreativeContents();
        return true;
    }

    @Deprecated
    public void sendSettings() {
        this.adventureSettings.update();
    }

    public boolean isSurvival() {
        return this.gamemode == 0;
    }

    public boolean isCreative() {
        return this.gamemode == 1;
    }

    public boolean isSpectator() {
        return this.gamemode == 3;
    }

    public boolean isAdventure() {
        return this.gamemode == 2;
    }

    @Override
    public Item[] getDrops() {
        if (!this.isCreative() && !this.isSpectator()) {
            if (this.inventory != null) {
                ArrayList<Item> drops = new ArrayList<Item>(this.inventory.getContents().values());
                drops.addAll(this.offhandInventory.getContents().values());
                return drops.toArray(new Item[0]);
            }
            return new Item[0];
        }
        return new Item[0];
    }

    @Override
    protected void checkGroundState(double movX, double movY, double movZ, double dx, double dy, double dz) {
        if (!this.onGround || movX != 0.0 || movY != 0.0 || movZ != 0.0) {
            boolean onGround = false;
            AxisAlignedBB bb = this.boundingBox.clone();
            bb.setMaxY(bb.getMinY() + 0.5);
            bb.setMinY(bb.getMinY() - 1.0);
            AxisAlignedBB realBB = this.boundingBox.clone();
            realBB.setMaxY(realBB.getMinY() + 0.1);
            realBB.setMinY(realBB.getMinY() - 0.2);
            int minX = NukkitMath.floorDouble(bb.getMinX());
            int minY = NukkitMath.floorDouble(bb.getMinY());
            int minZ = NukkitMath.floorDouble(bb.getMinZ());
            int maxX = NukkitMath.ceilDouble(bb.getMaxX());
            int maxY = NukkitMath.ceilDouble(bb.getMaxY());
            int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
            for (int z = minZ; z <= maxZ; ++z) {
                block1: for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.level.getBlock(this.chunk, x, y, z, true);
                        if (block.canPassThrough() || !block.collidesWithBB(realBB)) continue;
                        onGround = true;
                        continue block1;
                    }
                }
            }
            this.onGround = onGround;
        }
        this.isCollided = this.onGround;
    }

    @Override
    protected void checkBlockCollision() {
        EntityPortalEnterEvent ev;
        if (this.isSpectator()) {
            return;
        }
        boolean netherPortal = false;
        boolean endPortal = false;
        for (Block block : this.getCollisionBlocks()) {
            if (block.getLevel().getProvider() == null) break;
            if (block.getId() == 90) {
                netherPortal = true;
                continue;
            }
            if (block.getId() == 119) {
                endPortal = true;
                continue;
            }
            block.onEntityCollide(this);
        }
        this.inEndPortalTicks = endPortal ? ++this.inEndPortalTicks : 0;
        if (this.inEndPortalTicks == 1 && EnumLevel.THE_END.getLevel() != null) {
            ev = new EntityPortalEnterEvent(this, EntityPortalEnterEvent.PortalType.END);
            this.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                int oldDimension = this.getLevel().getDimension();
                if (oldDimension == 2) {
                    Position spawn = this.getSpawn();
                    if (spawn.getLevel().getDimension() == 0) {
                        if (this.teleport(spawn, PlayerTeleportEvent.TeleportCause.END_PORTAL)) {
                            this.awardAchievement("theEnd2");
                        }
                    } else if (this.teleport(this.getServer().getDefaultLevel().getSafeSpawn(), PlayerTeleportEvent.TeleportCause.END_PORTAL)) {
                        this.awardAchievement("theEnd2");
                    }
                } else {
                    Level end = this.getServer().getLevelByName("the_end");
                    if (end != null) {
                        Position pos = new Position(100.5, 49.0, 0.5, end);
                        BaseFullChunk chunk = end.getChunk(pos.getChunkX(), pos.getChunkZ(), false);
                        if (chunk == null || !chunk.isGenerated()) {
                            end.generateChunk(pos.getChunkX(), pos.getChunkZ(), true);
                            int x = pos.getFloorX();
                            int y = pos.getFloorY();
                            int z = pos.getFloorZ();
                            for (int xx = x - 2; xx < x + 3; ++xx) {
                                for (int zz = z - 2; zz < z + 3; ++zz) {
                                    end.setBlockAt(xx, y - 1, zz, 49);
                                    for (int yy = y; yy < y + 4; ++yy) {
                                        end.setBlockAt(xx, yy, zz, 0);
                                    }
                                }
                            }
                        }
                        if (this.teleport(pos, PlayerTeleportEvent.TeleportCause.END_PORTAL) && oldDimension == 0) {
                            this.awardAchievement("theEnd");
                        }
                    }
                }
            }
        }
        if (netherPortal) {
            ++this.inPortalTicks;
        } else {
            this.inPortalTicks = 0;
            this.portalPos = null;
        }
        if (this.server.isNetherAllowed()) {
            if (this.inPortalTicks == (this.gamemode == 1 ? 1 : 40) && this.portalPos == null) {
                Position portalPos = this.level.calculatePortalMirror(this);
                if (portalPos == null) {
                    return;
                }
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        int chunkZ;
                        int chunkX = portalPos.getChunkX() + x;
                        BaseFullChunk chunk = portalPos.level.getChunk(chunkX, chunkZ = portalPos.getChunkZ() + z, false);
                        if (chunk != null && (chunk.isGenerated() || chunk.isPopulated())) continue;
                        portalPos.level.generateChunk(chunkX, chunkZ, true);
                    }
                }
                this.portalPos = portalPos;
            }
            if (this.inPortalTicks == (this.gamemode == 1 ? 1 : 80)) {
                ev = new EntityPortalEnterEvent(this, EntityPortalEnterEvent.PortalType.NETHER);
                this.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    this.portalPos = null;
                    return;
                }
                int oldDimension = this.getLevel().getDimension();
                Position foundPortal = BlockNetherPortal.findNearestPortal(this.portalPos);
                if (foundPortal == null) {
                    BlockNetherPortal.spawnPortal(this.portalPos);
                    if (this.teleport(this.portalPos.add(1.5, 1.0, 0.5), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) && oldDimension == 0) {
                        this.awardAchievement("portal");
                    }
                } else if (this.teleport(BlockNetherPortal.getSafePortal(foundPortal), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) && oldDimension == 0) {
                    this.awardAchievement("portal");
                }
                this.portalPos = null;
            }
        }
    }

    protected void checkNearEntities() {
        Entity[] e;
        for (Entity entity : e = this.level.getNearbyEntities(this.boundingBox.grow(1.0, 0.5, 1.0), this)) {
            if (!entity.isAlive()) continue;
            if (entity.updateMode % 3 == 2) {
                entity.scheduleUpdate();
            }
            this.pickupEntity(entity, true);
        }
    }

    protected void handleMovement(Vector3 newPos) {
        double hSpeed;
        if (!this.isAlive() || !this.spawned || this.teleportPosition != null || this.isSleeping()) {
            return;
        }
        double distanceSquared = newPos.distanceSquared(this);
        if (distanceSquared == 0.0) {
            if (this.lastYaw != this.yaw || this.lastPitch != this.pitch) {
                if (!this.firstMove) {
                    Location from = new Location(this.x, this.y, this.z, this.lastYaw, this.lastPitch, this.level);
                    Location to = this.getLocation();
                    PlayerMoveEvent moveEvent = new PlayerMoveEvent(this, from, to);
                    this.server.getPluginManager().callEvent(moveEvent);
                    if (moveEvent.isCancelled()) {
                        this.teleport(from, null);
                        return;
                    }
                    this.lastYaw = to.yaw;
                    this.lastPitch = to.pitch;
                    if (!to.equals(moveEvent.getTo())) {
                        this.teleport(moveEvent.getTo(), null);
                    } else {
                        this.needSendRotation = true;
                    }
                } else {
                    this.lastYaw = this.yaw;
                    this.lastPitch = this.pitch;
                    this.needSendRotation = true;
                    this.firstMove = false;
                }
            }
            if (this.speed == null) {
                this.speed = new Vector3(0.0, 0.0, 0.0);
            } else {
                this.speed.setComponents(0.0, 0.0, 0.0);
            }
            return;
        }
        int maxDist = 9;
        if (this.riptideTicks > 95 || newPos.y - this.y < 2.0 || this.isOnLadder()) {
            maxDist = 49;
        }
        if (distanceSquared > (double)maxDist) {
            this.revertClientMotion(this);
            this.server.getLogger().debug(this.username + ": distanceSquared=" + distanceSquared + " > maxDist=" + maxDist);
            return;
        }
        if (this.chunk == null || !this.chunk.isGenerated()) {
            BaseFullChunk chunk = this.level.getChunk(newPos.getChunkX(), newPos.getChunkZ(), false);
            if (chunk == null || !chunk.isGenerated()) {
                this.nextChunkOrderRun = 0;
                this.revertClientMotion(this);
                return;
            }
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            this.chunk = chunk;
        }
        double dx = newPos.x - this.x;
        double dy = newPos.y - this.y;
        double dz = newPos.z - this.z;
        dy += (double)this.ySize * 0.6;
        if (this.checkMovement && this.riptideTicks <= 0 && this.riding == null && !this.isGliding() && !this.getAllowFlight() && (hSpeed = dx * dx + dz * dz) > 6.0) {
            PlayerInvalidMoveEvent ev = new PlayerInvalidMoveEvent(this, true);
            this.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.server.getLogger().debug(this.username + ": hSpeed=" + hSpeed + " > MAXIMUM_SPEED=" + 6.0f);
                this.revertClientMotion(this);
                return;
            }
        }
        if (this.isSpectator() || !this.level.hasCollision(this, this.boundingBox.getOffsetBoundingBox(dx, dy, dz).shrink(0.1, this.getStepHeight(), 0.1), false)) {
            this.x = newPos.x;
            this.y = newPos.y;
            this.z = newPos.z;
            this.boundingBox.setBounds(this.x - 0.3, this.y, this.z - 0.3, this.x + 0.3, this.y + (double)this.getHeight(), this.z + 0.3);
        }
        this.checkChunks();
        if (!(this.isSpectator() || this.onGround && dy == 0.0)) {
            AxisAlignedBB bb = this.boundingBox.clone();
            bb.setMinY(bb.getMinY() - 0.75);
            if (Math.abs(dy) > 0.01) {
                bb.setMinX(bb.getMinX() + 0.1);
                bb.setMaxX(bb.getMaxX() - 0.1);
                bb.setMinZ(bb.getMinZ() + 0.1);
                bb.setMaxZ(bb.getMaxZ() - 0.1);
            }
            this.onGround = this.level.hasCollisionBlocks(this, bb);
        }
        this.isCollided = this.onGround;
        this.updateFallState(this.onGround);
        Location from = new Location(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch, this.level);
        Location to = this.getLocation();
        if (!this.firstMove) {
            PlayerMoveEvent moveEvent = new PlayerMoveEvent(this, from, to);
            this.server.getPluginManager().callEvent(moveEvent);
            if (moveEvent.isCancelled()) {
                this.teleport(from, null);
                return;
            }
            this.lastX = to.x;
            this.lastY = to.y;
            this.lastZ = to.z;
            this.lastYaw = to.yaw;
            this.lastPitch = to.pitch;
            this.blocksAround = null;
            this.collisionBlocks = null;
            if (!to.equals(moveEvent.getTo())) {
                this.teleport(moveEvent.getTo(), null);
            } else {
                this.addMovement(this.x, this.y, this.z, this.yaw, this.pitch, this.yaw);
            }
        } else {
            this.lastX = to.x;
            this.lastY = to.y;
            this.lastZ = to.z;
            this.lastYaw = to.yaw;
            this.lastPitch = to.pitch;
            this.firstMove = false;
        }
        if (this.speed == null) {
            this.speed = new Vector3(from.x - to.x, from.y - to.y, from.z - to.z);
        } else {
            this.speed.setComponents(from.x - to.x, from.y - to.y, from.z - to.z);
        }
        if (this.riding == null && this.inventory != null) {
            Enchantment soulSpeedEnchantment;
            Item boots;
            Enchantment frostWalker;
            if (this.isFoodEnabled() && this.getServer().getDifficulty() > 0 && distanceSquared >= 0.05) {
                double jump = 0.0;
                double swimming = this.isInsideOfWater() ? 0.01 * distanceSquared : 0.0;
                double dd = distanceSquared;
                if (swimming != 0.0) {
                    dd = 0.0;
                }
                if (this.isSprinting()) {
                    if (this.inAirTicks == 3 && swimming == 0.0) {
                        jump = 0.2;
                    }
                    this.foodData.updateFoodExpLevel(0.1 * dd + jump + swimming);
                } else {
                    if (this.inAirTicks == 3 && swimming == 0.0) {
                        jump = 0.05;
                    }
                    this.foodData.updateFoodExpLevel(jump + swimming);
                }
            }
            if ((frostWalker = (boots = this.inventory.getBootsFast()).getEnchantment(25)) != null && frostWalker.getLevel() > 0 && !this.isSpectator() && this.y > (double)this.level.getMinBlockY() && this.y <= (double)this.level.getMaxBlockY()) {
                int radius = 2 + frostWalker.getLevel();
                for (int coordX = this.getFloorX() - radius; coordX < this.getFloorX() + radius + 1; ++coordX) {
                    for (int coordZ = this.getFloorZ() - radius; coordZ < this.getFloorZ() + radius + 1; ++coordZ) {
                        Block block = this.level.getBlock(this.chunk, coordX, this.getFloorY() - 1, coordZ, true);
                        if (block.getId() != 9 && (block.getId() != 8 || block.getDamage() != 0) || block.up().getId() != 0) continue;
                        WaterFrostEvent waterFrostEvent = new WaterFrostEvent(block);
                        this.server.getPluginManager().callEvent(waterFrostEvent);
                        if (waterFrostEvent.isCancelled()) continue;
                        this.level.setBlockAt((int)block.x, (int)block.y, (int)block.z, 207, 0);
                        this.level.scheduleUpdate(this.level.getBlock(this.chunk, block.getFloorX(), block.getFloorY(), block.getFloorZ(), true), Utils.random.nextInt(20, 40));
                    }
                }
            }
            if ((soulSpeedEnchantment = boots.getEnchantment(36)) != null && soulSpeedEnchantment.getLevel() > 0) {
                int down = this.getLevel().getBlockIdAt(this.chunk, this.getFloorX(), this.getFloorY() - 1, this.getFloorZ());
                if (this.inSoulSand && down != 88) {
                    this.inSoulSand = false;
                    this.setMovementSpeed(0.1f, true);
                } else if (!this.inSoulSand && down == 88) {
                    this.inSoulSand = true;
                    float soulSpeed = (float)soulSpeedEnchantment.getLevel() * 0.105f + 1.3f;
                    this.setMovementSpeed(0.1f * soulSpeed, true);
                }
            }
        }
        this.forceMovement = null;
        if (distanceSquared != 0.0 && this.nextChunkOrderRun > 20) {
            this.nextChunkOrderRun = 20;
        }
        this.needSendRotation = false;
        this.resetClientMovement();
    }

    @Override
    public void recalculateBoundingBox(boolean send) {
        double height = this.isSwimming() || this.isGliding() || this.isCrawling() ? 0.6 : (this.isSneaking() ? 1.5 : 1.8);
        this.boundingBox.setBounds(this.x - 0.3, this.y + (double)this.ySize, this.z - 0.3, this.x + 0.3, this.y + height + (double)this.ySize, this.z + 0.3);
        if (send) {
            FloatEntityData bbH = new FloatEntityData(54, (float)height);
            FloatEntityData bbW = new FloatEntityData(53, this.getWidth());
            this.dataProperties.put(bbH);
            this.dataProperties.put(bbW);
            this.sendData(this.hasSpawned.values().toArray(new Player[0]), new EntityMetadata().put(bbH).put(bbW));
        }
    }

    protected void resetClientMovement() {
        this.newPosition = null;
    }

    protected void revertClientMotion(Location originalPos) {
        this.lastX = originalPos.getX();
        this.lastY = originalPos.getY();
        this.lastZ = originalPos.getZ();
        this.lastYaw = originalPos.getYaw();
        this.lastPitch = originalPos.getPitch();
        Location syncPos = originalPos.add(0.0, 1.0E-5, 0.0);
        this.needSendRotation = false;
        this.sendPosition(syncPos, originalPos.getYaw(), originalPos.getPitch(), 1);
        this.forceMovement = syncPos;
        if (this.speed == null) {
            this.speed = new Vector3(0.0, 0.0, 0.0);
        } else {
            this.speed.setComponents(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void addMovement(double x, double y, double z, double yaw, double pitch, double headYaw) {
        this.sendPositionToViewers(x, y, z, yaw, pitch, headYaw);
    }

    @Override
    public boolean setMotion(Vector3 motion) {
        if (super.setMotion(motion)) {
            if (this.chunk != null && this.spawned) {
                this.addMotion(this.motionX, this.motionY, this.motionZ);
                SetEntityMotionPacket pk = new SetEntityMotionPacket();
                pk.eid = this.id;
                pk.motionX = (float)motion.x;
                pk.motionY = (float)motion.y;
                pk.motionZ = (float)motion.z;
                this.dataPacket(pk);
            }
            if (this.motionY > 0.0) {
                this.startAirTicks = (int)(-Math.log((double)this.getGravity() / ((double)this.getGravity() + (double)this.getDrag() * this.motionY)) / (double)this.getDrag() * 2.0 + 5.0);
            }
            return true;
        }
        return false;
    }

    public void setMotionLocally(Vector3 motion) {
        if (!this.justCreated) {
            EntityMotionEvent ev = new EntityMotionEvent(this, motion);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return;
            }
        }
        this.motionX = motion.x;
        this.motionY = motion.y;
        this.motionZ = motion.z;
        if (this.motionY > 0.0) {
            this.startAirTicks = (int)(-Math.log((double)this.getGravity() / ((double)this.getGravity() + (double)this.getDrag() * this.motionY)) / (double)this.getDrag() * 2.0 + 5.0);
        }
    }

    public void sendAttributes() {
        int healthMax = this.getMaxHealth();
        UpdateAttributesPacket pk = new UpdateAttributesPacket();
        pk.entityId = this.getId();
        Attribute[] attributeArray = new Attribute[5];
        attributeArray[0] = Attribute.getAttribute(4).setMaxValue(healthMax).setValue(this.health > 0.0f ? (this.health < (float)healthMax ? this.health : (float)healthMax) : 0.0f);
        attributeArray[1] = Attribute.getAttribute(7).setValue(this.foodData.getLevel()).setDefaultValue(this.foodData.getMaxLevel());
        attributeArray[2] = Attribute.getAttribute(5).setValue(this.getMovementSpeed()).setDefaultValue(this.getMovementSpeed());
        attributeArray[3] = Attribute.getAttribute(9).setValue(this.expLevel);
        attributeArray[4] = Attribute.getAttribute(10).setValue((float)this.exp / (float)Player.calculateRequireExperience(this.expLevel));
        pk.entries = attributeArray;
        this.dataPacket(pk);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        PlayerInventory inv;
        if (!this.loggedIn) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0) {
            return true;
        }
        this.lastUpdate = currentTick;
        if (this.riptideTicks > 0) {
            this.riptideTicks -= tickDiff;
        }
        if (this.fishing != null && this.age % 10 == 0 && this.distanceSquared(this.fishing) > 1089.0) {
            this.stopFishing(false);
        }
        if (!this.isAlive() && this.spawned) {
            this.despawnFromAll();
            return true;
        }
        if (this.spawned) {
            while (!this.clientMovements.isEmpty()) {
                this.handleMovement(this.clientMovements.poll());
            }
            if (this.needSendRotation) {
                this.addMovement(this.x, this.y, this.z, this.yaw, this.pitch, this.yaw);
                this.needSendRotation = false;
            }
            this.motionZ = 0.0;
            this.motionY = 0.0;
            this.motionX = 0.0;
            if (!this.isSpectator() && this.isAlive()) {
                this.checkNearEntities();
            }
            this.entityBaseTick(tickDiff);
            if (this.getServer().getDifficulty() == 0 && this.level.getGameRules().getBoolean(GameRule.NATURAL_REGENERATION)) {
                if (this.getHealth() < (float)this.getRealMaxHealth() && this.age % 20 == 0) {
                    this.heal(1.0f);
                }
                if (this.foodData.getLevel() < 20 && this.age % 10 == 0) {
                    this.foodData.addFoodLevel(1, 0.0f);
                }
            }
            if (this.isOnFire() && this.age % 10 == 0) {
                if (this.isCreative() && !this.isInsideOfFire()) {
                    this.extinguish();
                } else if (this.getLevel().isRaining() && this.canSeeSky()) {
                    this.extinguish();
                }
            }
            if (!this.isSpectator() && this.speed != null) {
                if (this.onGround) {
                    if (this.isGliding()) {
                        this.setGliding(false);
                    }
                    this.resetFallDistance();
                } else {
                    double expectedVelocity;
                    double diff;
                    if (!(!this.checkMovement || this.riptideTicks >= 1 || this.isGliding() || this.server.getAllowFlight() || this.inAirTicks <= 20 || this.getAllowFlight() || this.isSleeping() || this.isImmobile() || this.isSwimming() || this.riding != null || this.hasEffect(24) || this.hasEffect(27) || this.speed == null || this.speed.x == 0.0 && this.speed.y == 0.0 && this.speed.z == 0.0 || !((diff = Math.abs(Math.abs(expectedVelocity = (double)(-this.getGravity()) / (double)this.getDrag() - (double)(-this.getGravity()) / (double)this.getDrag() * Math.exp(-((double)this.getDrag()) * (double)(this.inAirTicks - this.startAirTicks))) - Math.abs(this.speed.y))) > 1.0) || !(expectedVelocity < 0.0))) {
                        if (this.inAirTicks < 200) {
                            PlayerInvalidMoveEvent ev = new PlayerInvalidMoveEvent(this, true);
                            this.getServer().getPluginManager().callEvent(ev);
                            if (!ev.isCancelled()) {
                                this.startAirTicks = this.inAirTicks - 10;
                                this.setMotion(new Vector3(0.0, expectedVelocity, 0.0));
                            }
                        } else if (this.kick(PlayerKickEvent.Reason.FLYING_DISABLED, MSG_FLYING_NOT_ENABLED, true)) {
                            return false;
                        }
                    }
                    if (this.y > this.highestPosition) {
                        this.highestPosition = this.y;
                    }
                    if (this.isSwimming() || this.isOnLadder() || this.isGliding() && this.getPitch() <= 40.0 && Math.abs(this.speed.y) < 0.5) {
                        this.resetFallDistance();
                    } else if (this.isGliding()) {
                        this.resetInAirTicks();
                    } else {
                        ++this.inAirTicks;
                    }
                }
                if (this.foodData != null) {
                    this.foodData.update(tickDiff);
                }
            }
        }
        if (this.age % 20 == 0 && this.isGliding() && (inv = this.getInventory()) != null) {
            Item elytra = inv.getChestplate();
            if (elytra == null || elytra.getId() != 444) {
                this.setGliding(false);
            } else if ((this.gamemode & 1) == 0 && this.age % (20 * (elytra.getEnchantmentLevel(17) + 1)) == 0) {
                elytra.setDamage(elytra.getDamage() + 1);
                if (elytra.getDamage() >= elytra.getMaxDurability()) {
                    this.setGliding(false);
                }
                inv.setChestplate(elytra);
            }
        }
        if (this.fireworkBoostTicks > 0) {
            this.fireworkBoostTicks -= tickDiff;
            double multiplier = 1.0 + 0.25 * (this.fireworkBoostLevel < 1 ? 0.25 : (double)this.fireworkBoostLevel);
            this.setMotion(new Vector3(-Math.sin(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * multiplier, -Math.sin(Math.toRadians(this.pitch)) * multiplier, Math.cos(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * multiplier));
        }
        if (this.age % 5 == 0 && this.isBreakingBlock() && !this.isCreative()) {
            this.level.addParticle(new PunchBlockParticle(this.breakingBlock, this.breakingBlock, this.breakingBlockFace));
        }
        this.checkTeleportPosition();
        if (this.spawned && !this.dummyBossBars.isEmpty() && currentTick % 100 == 0) {
            this.dummyBossBars.values().forEach(DummyBossBar::updateBossEntityPosition);
        }
        this.tickShield(tickDiff);
        if (!this.isSleeping()) {
            this.timeSinceRest += tickDiff;
        }
        return true;
    }

    private void tickShield(int tickDiff) {
        boolean shieldInOffhand;
        if (!this.canTickShield) {
            return;
        }
        if (this.blockingDelay > 0) {
            this.blockingDelay -= tickDiff;
        }
        boolean shieldInHand = this.getInventory().getItemInHandFast().getId() == 513;
        boolean bl = shieldInOffhand = this.getOffhandInventory().getItemFast(0).getId() == 513;
        if (this.isBlocking()) {
            if (!this.isSneaking() || !shieldInHand && !shieldInOffhand) {
                this.setBlocking(false);
            }
        } else if (this.blockingDelay <= 0 && this.isSneaking() && (shieldInHand || shieldInOffhand)) {
            this.setBlocking(true);
        }
    }

    public void checkInteractNearby() {
        int interactDistance;
        int n = interactDistance = this.isCreative() ? 5 : 3;
        if (this.canInteract(this, interactDistance)) {
            EntityInteractable e = this.getEntityPlayerLookingAt(interactDistance);
            if (e != null) {
                String buttonText = e.getInteractButtonText(this);
                if (buttonText == null) {
                    buttonText = "";
                }
                this.setButtonText(buttonText);
            } else {
                this.setButtonText("");
            }
        } else {
            this.setButtonText("");
        }
    }

    public EntityInteractable getEntityPlayerLookingAt(int maxDistance) {
        EntityInteractable entity = null;
        if (this.temporalVector != null) {
            Entity[] nearbyEntities = this.level.getNearbyEntities(this.boundingBox.grow(maxDistance, maxDistance, maxDistance), this);
            try {
                BlockIterator itr = new BlockIterator(this.level, this.getPosition(), this.getDirectionVector(), this.getEyeHeight(), maxDistance);
                if (itr.hasNext()) {
                    Block block;
                    while (itr.hasNext() && (entity = Player.getEntityAtPosition(nearbyEntities, (block = itr.next()).getFloorX(), block.getFloorY(), block.getFloorZ())) == null) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entity;
    }

    private static EntityInteractable getEntityAtPosition(Entity[] nearbyEntities, int x, int y, int z) {
        for (Entity nearestEntity : nearbyEntities) {
            if (nearestEntity.getFloorX() != x || nearestEntity.getFloorY() != y || nearestEntity.getFloorZ() != z || !(nearestEntity instanceof EntityInteractable) || !((EntityInteractable)((Object)nearestEntity)).canDoInteraction()) continue;
            return (EntityInteractable)((Object)nearestEntity);
        }
        return null;
    }

    public void checkNetwork() {
        if (!this.isOnline()) {
            return;
        }
        if (this.nextChunkOrderRun-- <= 0 || this.chunk == null) {
            this.orderChunks();
        }
        if (!this.loadQueue.isEmpty() || !this.spawned) {
            this.sendNextChunk();
        }
    }

    public boolean canInteract(Vector3 pos, double maxDistance) {
        return this.canInteract(pos, maxDistance, 6.0);
    }

    public boolean canInteract(Vector3 pos, double maxDistance, double maxDiff) {
        if (this.distanceSquared(pos) > maxDistance * maxDistance) {
            return false;
        }
        Vector2 dV = this.getDirectionPlane();
        return dV.dot(new Vector2(pos.x, pos.z)) - dV.dot(new Vector2(this.x, this.z)) >= -maxDiff;
    }

    private boolean canInteractEntity(Vector3 pos, double maxDistanceSquared) {
        if (this.distanceSquared(pos) > maxDistanceSquared) {
            return false;
        }
        Vector2 dV = this.getDirectionPlane();
        return dV.dot(new Vector2(pos.x, pos.z)) - dV.dot(new Vector2(this.x, this.z)) >= -0.87;
    }

    protected void processPreLogin() {
        this.loginVerified = true;
        final Player playerInstance = this;
        this.preLoginEventTask = new AsyncTask(){
            private PlayerAsyncPreLoginEvent event;

            @Override
            public void onRun() {
                this.event = new PlayerAsyncPreLoginEvent(Player.this.username, Player.this.uuid, Player.this.loginChainData, Player.this.skin, playerInstance.getAddress(), playerInstance.getPort());
                Player.this.server.getPluginManager().callEvent(this.event);
            }

            @Override
            public void onCompletion(Server server) {
                if (!playerInstance.connected) {
                    return;
                }
                if (this.event.getLoginResult() == PlayerAsyncPreLoginEvent.LoginResult.KICK) {
                    playerInstance.close(this.event.getKickMessage(), this.event.getKickMessage());
                } else if (playerInstance.shouldLogin) {
                    try {
                        playerInstance.setSkin(this.event.getSkin());
                        playerInstance.completeLoginSequence();
                        for (Consumer<Server> action : this.event.getScheduledActions()) {
                            action.accept(server);
                        }
                    }
                    catch (Exception ex) {
                        server.getLogger().logException(ex);
                        playerInstance.close("", "Internal Server Error");
                    }
                }
            }
        };
        this.server.getScheduler().scheduleAsyncTask(null, this.preLoginEventTask);
        try {
            this.processLogin();
        }
        catch (Exception ex) {
            this.server.getLogger().logException(ex);
            this.close("", "Internal Server Error");
        }
    }

    protected void processLogin() {
        Object spawnLevel;
        CompoundTag nbt;
        String lowerName = this.iusername;
        if (!this.server.isWhitelisted(lowerName)) {
            this.kick(PlayerKickEvent.Reason.NOT_WHITELISTED, "Server is white-listed");
            return;
        }
        if (this.isBanned()) {
            String reason = this.server.getNameBans().getEntires().get(lowerName).getReason();
            this.kick(PlayerKickEvent.Reason.NAME_BANNED, "You are banned!" + (reason.isEmpty() ? "" : " Reason: " + reason));
            return;
        }
        if (this.server.getIPBans().isBanned(this.getAddress())) {
            this.kick(PlayerKickEvent.Reason.IP_BANNED, "Your IP is banned!");
            return;
        }
        for (Player p : new ArrayList<Player>(this.server.playerList.values())) {
            if (p == this || p.username == null || !p.username.equalsIgnoreCase(this.username) && !this.getUniqueId().equals(p.getUniqueId())) continue;
            p.close("", "disconnectionScreen.loggedinOtherLocation");
            break;
        }
        File legacyDataFile = new File(this.server.getDataPath() + "players/" + lowerName + ".dat");
        File dataFile = new File(this.server.getDataPath() + "players/" + this.uuid.toString() + ".dat");
        boolean dataFound = dataFile.exists();
        if (!dataFound && legacyDataFile.exists()) {
            nbt = this.server.getOfflinePlayerData(lowerName, false);
            if (!legacyDataFile.delete()) {
                this.server.getLogger().warning("Could not delete legacy player data for " + this.username);
            }
        } else {
            nbt = this.server.getOfflinePlayerData(this.uuid, !dataFound);
        }
        if (nbt == null) {
            this.close(this.getLeaveMessage(), "Invalid data");
            return;
        }
        if (this.loginChainData.isXboxAuthed() || !this.server.xboxAuth) {
            this.server.updateName(this.uuid, this.username);
        }
        this.playedBefore = nbt.getLong("lastPlayed") - nbt.getLong("firstPlayed") > 1L;
        nbt.putString("NameTag", this.username);
        this.setExperience(nbt.getInt("EXP"), nbt.getInt("expLevel"));
        if (this.server.getForceGamemode()) {
            this.gamemode = this.server.getGamemode();
            nbt.putInt("playerGameType", this.gamemode);
        } else {
            this.gamemode = nbt.getInt("playerGameType") & 3;
        }
        this.adventureSettings = new AdventureSettings(this).set(AdventureSettings.Type.WORLD_IMMUTABLE, this.isAdventure() || this.isSpectator()).set(AdventureSettings.Type.MINE, !this.isAdventure() && !this.isSpectator()).set(AdventureSettings.Type.BUILD, !this.isAdventure() && !this.isSpectator()).set(AdventureSettings.Type.NO_PVM, this.isSpectator()).set(AdventureSettings.Type.AUTO_JUMP, true).set(AdventureSettings.Type.ALLOW_FLIGHT, this.isCreative() || this.isSpectator()).set(AdventureSettings.Type.NO_CLIP, this.isSpectator()).set(AdventureSettings.Type.FLYING, this.isSpectator());
        Level level = this.server.getLevelByName(nbt.getString("Level"));
        if (level == null || nbt.getShort("Health") < 1) {
            this.setLevel(this.server.getDefaultLevel());
            nbt.putString("Level", this.level.getName());
            Vector3 sp = this.level.getProvider().getSpawn();
            nbt.getList("Pos", DoubleTag.class).add(new DoubleTag("0", sp.x)).add(new DoubleTag("1", sp.y)).add(new DoubleTag("2", sp.z));
        } else {
            this.setLevel(level);
        }
        if (nbt.contains("SpawnLevel") && (spawnLevel = this.server.getLevelByName(nbt.getString("SpawnLevel"))) != null) {
            this.spawnPosition = new Position(nbt.getInt("SpawnX"), nbt.getInt("SpawnY"), nbt.getInt("SpawnZ"), (Level)spawnLevel);
        }
        this.timeSinceRest = nbt.getInt("TimeSinceRest");
        for (Tag achievement : nbt.getCompound("Achievements").getAllTags()) {
            if (!(achievement instanceof ByteTag) || ((ByteTag)achievement).getData() <= 0) continue;
            this.achievements.add(achievement.getName());
        }
        nbt.putLong("lastPlayed", System.currentTimeMillis() / 1000L);
        UUID uuid = this.getUniqueId();
        nbt.putLong("UUIDLeast", uuid.getLeastSignificantBits());
        nbt.putLong("UUIDMost", uuid.getMostSignificantBits());
        if (this.server.getAutoSave()) {
            this.server.saveOfflinePlayerData(this.uuid, nbt, true);
        }
        this.sendPlayStatus(0);
        ListTag<DoubleTag> posList = nbt.getList("Pos", DoubleTag.class);
        super.init(this.level.getChunk(NukkitMath.floorDouble(posList.get((int)0).data) >> 4, NukkitMath.floorDouble(posList.get((int)2).data) >> 4, true), nbt);
        if (!this.namedTag.contains("foodLevel")) {
            this.namedTag.putInt("foodLevel", 20);
        }
        if (!this.namedTag.contains("foodSaturationLevel")) {
            this.namedTag.putFloat("foodSaturationLevel", 20.0f);
        }
        this.foodData = new PlayerFood(this, this.namedTag.getInt("foodLevel"), this.namedTag.getFloat("foodSaturationLevel"));
        if (this.isSpectator()) {
            this.keepMovement = true;
            this.onGround = false;
        }
        this.forceMovement = this.teleportPosition = this.getPosition();
        ResourcePacksInfoPacket infoPacket = new ResourcePacksInfoPacket();
        infoPacket.resourcePackEntries = this.server.getResourcePackManager().getResourceStack();
        infoPacket.mustAccept = this.server.getForceResources();
        this.dataPacket(infoPacket);
    }

    protected void completeLoginSequence() {
        if (this.loggedIn) {
            this.server.getLogger().warning("Tried to call completeLoginSequence but player is already logged in: " + this.username);
            return;
        }
        PlayerLoginEvent ev = new PlayerLoginEvent(this, "Plugin reason");
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            this.close(this.getLeaveMessage(), ev.getKickMessage());
            return;
        }
        if (this.isClosed() || !this.isConnected()) {
            return;
        }
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.entityUniqueId = this.id;
        startGamePacket.entityRuntimeId = this.id;
        startGamePacket.playerGamemode = Player.getClientFriendlyGamemode(this.gamemode);
        startGamePacket.x = (float)this.x;
        startGamePacket.y = (float)this.y;
        startGamePacket.z = (float)this.z;
        startGamePacket.yaw = (float)this.yaw;
        startGamePacket.pitch = (float)this.pitch;
        startGamePacket.dimension = (byte)(this.level.getDimension() & 0xFF);
        startGamePacket.worldGamemode = Player.getClientFriendlyGamemode(this.gamemode);
        startGamePacket.difficulty = this.server.getDifficulty();
        if (this.level.getProvider() == null || this.level.getProvider().getSpawn() == null) {
            startGamePacket.spawnX = (int)this.x;
            startGamePacket.spawnY = (int)this.y;
            startGamePacket.spawnZ = (int)this.z;
        } else {
            Vector3 spawn = this.level.getProvider().getSpawn();
            startGamePacket.spawnX = (int)spawn.x;
            startGamePacket.spawnY = (int)spawn.y;
            startGamePacket.spawnZ = (int)spawn.z;
        }
        startGamePacket.commandsEnabled = this.enableClientCommand;
        startGamePacket.gameRules = this.getLevel().getGameRules();
        startGamePacket.worldName = this.getServer().getNetwork().getName();
        if (this.getLevel().isRaining()) {
            startGamePacket.rainLevel = this.getLevel().getRainTime();
            if (this.getLevel().isThundering()) {
                startGamePacket.lightningLevel = this.getLevel().getThunderTime();
            }
        }
        this.forceDataPacket(startGamePacket, null);
        this.loggedIn = true;
        this.server.getLogger().info(this.getServer().getLanguage().translateString("nukkit.player.logIn", (Object)((Object)TextFormat.AQUA) + this.username + (Object)((Object)TextFormat.WHITE), this.getAddress(), String.valueOf(this.getPort()), String.valueOf(this.id), this.level.getName(), String.valueOf(this.getFloorX()), String.valueOf(this.getFloorY()), String.valueOf(this.getFloorZ())));
        this.setDataFlag(0, 19, true, false);
        this.setDataFlag(0, 14, true, false);
        this.setDataProperty(new ByteEntityData(81, 1), false);
        if (this.isSpectator()) {
            this.setDataFlag(0, 17, true, false);
            this.setDataFlag(0, 48, false, false);
        }
        if (CustomItemManager.get().hasCustomItems()) {
            this.dataPacket(CustomItemManager.get().getCachedPacket());
        }
        this.dataPacket(BiomeDefinitionListPacket.getCachedPacket());
        this.dataPacket(EntityManager.get().getCachedPacket());
        this.sendSpawnPos((int)this.x, (int)this.y, (int)this.z, this.level.getDimension());
        this.getLevel().sendTime(this);
        SetDifficultyPacket difficultyPacket = new SetDifficultyPacket();
        difficultyPacket.difficulty = this.server.getDifficulty();
        this.dataPacket(difficultyPacket);
        SetCommandsEnabledPacket commandsPacket = new SetCommandsEnabledPacket();
        commandsPacket.enabled = this.isEnableClientCommand();
        this.dataPacket(commandsPacket);
        this.adventureSettings.update();
        GameRulesChangedPacket gameRulesPK = new GameRulesChangedPacket();
        gameRulesPK.gameRulesMap = this.level.getGameRules().getGameRules();
        this.dataPacket(gameRulesPK);
        this.server.sendFullPlayerListData(this);
        this.sendAttributes();
        this.inventory.sendCreativeContents();
        this.sendAllInventories();
        this.inventory.sendHeldItem(this);
        this.server.sendRecipeList(this);
        if (this.isEnableClientCommand()) {
            this.sendCommandData();
        }
        this.sendPotionEffects(this);
        this.sendData(this);
        if (this.isOp() || this.hasPermission("nukkit.textcolor")) {
            this.setRemoveFormat(false);
        }
        this.server.onPlayerCompleteLoginSequence(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDataPacket(DataPacket packet) {
        if (!this.connected) {
            return;
        }
        byte pid = packet.pid();
        if (!this.loginVerified && pid != 1 && pid != -63 && pid != -1 && pid != 4) {
            this.server.getLogger().warning("Ignoring " + packet.getClass().getSimpleName() + " from " + this.getAddress() + " due to player not verified yet");
            return;
        }
        if (!this.loggedIn && !PRE_LOGIN_PACKETS.contains(pid)) {
            this.server.getLogger().warning("Ignoring " + packet.getClass().getSimpleName() + " from " + this.username + " due to player not logged in yet");
            return;
        }
        DataPacketReceiveEvent ev = new DataPacketReceiveEvent(this, packet);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        if (Nukkit.DEBUG > 2 && !this.server.isIgnoredPacket(packet.getClass())) {
            log.trace("Inbound {}: {}", (Object)this.getName(), (Object)packet);
        }
        switch (pid) {
            case -63: {
                this.networkSettingsRequested = true;
                if (this.getNetworkSession().getCompression() != CompressionProvider.NONE) {
                    this.getServer().getLogger().debug((this.username == null ? this.unverifiedUsername : this.username) + ": got a RequestNetworkSettingsPacket but compression is already set");
                    return;
                }
                RequestNetworkSettingsPacket networkSettingsRequest = (RequestNetworkSettingsPacket)packet;
                if (!ProtocolInfo.SUPPORTED_PROTOCOLS.contains(networkSettingsRequest.protocolVersion)) {
                    String message = networkSettingsRequest.protocolVersion < ProtocolInfo.CURRENT_PROTOCOL ? "disconnectionScreen.outdatedClient" : "disconnectionScreen.outdatedServer";
                    this.close("", message, true);
                    this.server.getLogger().debug(this.getAddress() + " disconnected with unsupported protocol " + networkSettingsRequest.protocolVersion);
                    return;
                }
                NetworkSettingsPacket settingsPacket = new NetworkSettingsPacket();
                settingsPacket.compressionAlgorithm = this.server.useSnappy ? PacketCompressionAlgorithm.SNAPPY : PacketCompressionAlgorithm.ZLIB;
                settingsPacket.compressionThreshold = this.server.networkCompressionThreshold;
                this.forceDataPacket(settingsPacket, () -> this.networkSession.setCompression(this.server.useSnappy ? CompressionProvider.SNAPPY : CompressionProvider.ZLIB_RAW));
                return;
            }
            case 1: {
                if (this.loginPacketReceived) {
                    this.close("", "Invalid login packet");
                    return;
                }
                this.loginPacketReceived = true;
                LoginPacket loginPacket = (LoginPacket)packet;
                this.unverifiedUsername = TextFormat.clean(loginPacket.username);
                if (!this.networkSettingsRequested) {
                    this.close("", "Invalid login sequence: login packet before network settings");
                    return;
                }
                if (!ProtocolInfo.SUPPORTED_PROTOCOLS.contains(loginPacket.getProtocol())) {
                    String message = loginPacket.getProtocol() < ProtocolInfo.CURRENT_PROTOCOL ? "disconnectionScreen.outdatedClient" : "disconnectionScreen.outdatedServer";
                    this.close("", message, true);
                    this.server.getLogger().debug(this.getAddress() + " disconnected with unsupported protocol " + loginPacket.getProtocol());
                    return;
                }
                if (loginPacket.skin == null) {
                    this.close("", "disconnectionScreen.invalidSkin");
                    return;
                }
                if (this.server.getOnlinePlayersCount() >= this.server.getMaxPlayers() && this.kick(PlayerKickEvent.Reason.SERVER_FULL, "disconnectionScreen.serverFull", false)) {
                    return;
                }
                try {
                    this.loginChainData = ClientChainData.read(loginPacket);
                }
                catch (ClientChainData.TooBigSkinException ex) {
                    this.close("", "disconnectionScreen.invalidSkin");
                    return;
                }
                this.server.getLogger().debug("Name: " + this.unverifiedUsername + " Protocol: " + loginPacket.getProtocol() + " Version: " + this.loginChainData.getGameVersion());
                if (!this.loginChainData.isXboxAuthed() && this.server.xboxAuth) {
                    this.close("", "disconnectionScreen.notAuthenticated");
                    return;
                }
                this.username = this.unverifiedUsername;
                this.unverifiedUsername = null;
                this.displayName = this.username;
                this.iusername = this.username.toLowerCase();
                this.setDataProperty(new StringEntityData(4, this.username), false);
                this.randomClientId = loginPacket.clientId;
                this.uuid = loginPacket.clientUUID;
                this.rawUUID = Binary.writeUUID(this.uuid);
                boolean valid = true;
                int len = loginPacket.username.length();
                if (len > 16 || len < 3 || loginPacket.username.trim().isEmpty()) {
                    valid = false;
                }
                if (valid) {
                    for (int i = 0; i < len; ++i) {
                        char c = loginPacket.username.charAt(i);
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ' ' && i != 0 && i != len - 1) continue;
                        valid = false;
                        break;
                    }
                }
                if (!valid || Objects.equals(this.iusername, "rcon") || Objects.equals(this.iusername, "console")) {
                    this.close("", "disconnectionScreen.invalidName");
                    return;
                }
                Skin skin = loginPacket.skin;
                if (!skin.isValid()) {
                    this.close("", "disconnectionScreen.invalidSkin");
                    return;
                }
                this.setSkin(skin);
                PlayerPreLoginEvent playerPreLoginEvent = new PlayerPreLoginEvent(this, "Plugin reason");
                this.server.getPluginManager().callEvent(playerPreLoginEvent);
                if (playerPreLoginEvent.isCancelled()) {
                    this.close("", playerPreLoginEvent.getKickMessage());
                    return;
                }
                if (this.server.encryptionEnabled) {
                    this.getServer().getScheduler().scheduleAsyncTask(null, new PrepareEncryptionTask(this){

                        @Override
                        public void onCompletion(Server server) {
                            if (!Player.this.connected) {
                                return;
                            }
                            if (this.getHandshakeJwt() == null || this.getEncryptionKey() == null || this.getEncryptionCipher() == null || this.getDecryptionCipher() == null) {
                                Player.this.close("Failed to enable encryption");
                                return;
                            }
                            ServerToClientHandshakePacket handshakePacket = new ServerToClientHandshakePacket();
                            handshakePacket.jwt = this.getHandshakeJwt();
                            Player.this.forceDataPacket(handshakePacket, () -> {
                                Player.this.awaitingEncryptionHandshake = true;
                                Player.this.networkSession.setEncryption(this.getEncryptionKey(), this.getEncryptionCipher(), this.getDecryptionCipher());
                            });
                        }
                    });
                } else {
                    this.processPreLogin();
                }
                return;
            }
            case 4: {
                if (!this.awaitingEncryptionHandshake) {
                    this.close("Invalid encryption handshake");
                    return;
                }
                this.awaitingEncryptionHandshake = false;
                this.processPreLogin();
                return;
            }
            case 8: {
                if (this.spawned) {
                    this.getServer().getLogger().debug(this.username + ": ResourcePackClientResponsePacket after player spawned");
                    return;
                }
                ResourcePackClientResponsePacket responsePacket = (ResourcePackClientResponsePacket)packet;
                switch (responsePacket.responseStatus) {
                    case 1: {
                        this.close("", "disconnectionScreen.noReason");
                        return;
                    }
                    case 2: {
                        for (ResourcePackClientResponsePacket.Entry entry : responsePacket.packEntries) {
                            ResourcePack resourcePack = this.server.getResourcePackManager().getPackById(entry.uuid);
                            if (resourcePack == null) {
                                this.close("", "disconnectionScreen.resourcePack");
                                return;
                            }
                            ResourcePackDataInfoPacket dataInfoPacket = new ResourcePackDataInfoPacket();
                            dataInfoPacket.packId = resourcePack.getPackId();
                            dataInfoPacket.maxChunkSize = 8192;
                            dataInfoPacket.chunkCount = MathHelper.ceil((float)resourcePack.getPackSize() / 8192.0f);
                            dataInfoPacket.compressedPackSize = resourcePack.getPackSize();
                            dataInfoPacket.sha256 = resourcePack.getSha256();
                            this.dataPacket(dataInfoPacket);
                        }
                        return;
                    }
                    case 3: {
                        ResourcePackStackPacket stackPacket = new ResourcePackStackPacket();
                        stackPacket.mustAccept = this.server.getForceResources() && !this.server.forceResourcesAllowOwnPacks;
                        stackPacket.resourcePackStack = this.server.getResourcePackManager().getResourceStack();
                        this.dataPacket(stackPacket);
                        return;
                    }
                    case 4: {
                        this.shouldLogin = true;
                        if (this.preLoginEventTask.isFinished()) {
                            this.preLoginEventTask.onCompletion(this.server);
                        }
                        return;
                    }
                }
                return;
            }
            case 84: {
                ResourcePackChunkRequestPacket requestPacket = (ResourcePackChunkRequestPacket)packet;
                ResourcePack resourcePack = this.server.getResourcePackManager().getPackById(requestPacket.packId);
                if (resourcePack == null) {
                    this.close("", "disconnectionScreen.resourcePack");
                    return;
                }
                ResourcePackChunkDataPacket dataPacket = new ResourcePackChunkDataPacket();
                dataPacket.packId = resourcePack.getPackId();
                dataPacket.chunkIndex = requestPacket.chunkIndex;
                dataPacket.data = resourcePack.getPackChunk(8192 * requestPacket.chunkIndex, 8192);
                dataPacket.progress = 8192L * (long)requestPacket.chunkIndex;
                this.dataPacket(dataPacket);
                return;
            }
            case 93: {
                PlayerSkinPacket skinPacket = (PlayerSkinPacket)packet;
                Skin skin = skinPacket.skin;
                if (!skin.isValid()) {
                    this.close("", "disconnectionScreen.invalidSkin");
                    return;
                }
                PlayerChangeSkinEvent playerChangeSkinEvent = new PlayerChangeSkinEvent(this, skin);
                playerChangeSkinEvent.setCancelled(TimeUnit.SECONDS.toMillis(this.server.getPlayerSkinChangeCooldown()) > System.currentTimeMillis() - this.lastSkinChange);
                this.server.getPluginManager().callEvent(playerChangeSkinEvent);
                if (!playerChangeSkinEvent.isCancelled()) {
                    this.lastSkinChange = System.currentTimeMillis();
                    this.setSkin(skin);
                }
                return;
            }
            case -112: {
                Vector3 clientPosition;
                double distSqrt;
                if (!this.spawned) {
                    return;
                }
                PlayerAuthInputPacket authPacket = (PlayerAuthInputPacket)packet;
                if (!authPacket.getBlockActionData().isEmpty()) {
                    for (PlayerBlockActionData action2 : authPacket.getBlockActionData().values()) {
                        BlockVector3 lastBreakPos;
                        BlockVector3 blockPos = action2.getPosition();
                        BlockFace blockFace = BlockFace.fromIndex(action2.getFacing());
                        if (this.lastBlockAction != null && this.lastBlockAction.getAction() == PlayerActionType.PREDICT_DESTROY_BLOCK && action2.getAction() == PlayerActionType.CONTINUE_DESTROY_BLOCK) {
                            this.onBlockBreakStart(blockPos, blockFace);
                        }
                        BlockVector3 blockVector3 = lastBreakPos = this.lastBlockAction == null ? null : this.lastBlockAction.getPosition();
                        if (lastBreakPos != null && (lastBreakPos.getX() != blockPos.getX() || lastBreakPos.getY() != blockPos.getY() || lastBreakPos.getZ() != blockPos.getZ())) {
                            this.onBlockBreakAbort(lastBreakPos, BlockFace.DOWN);
                            this.onBlockBreakStart(blockPos, blockFace);
                        }
                        switch (action2.getAction()) {
                            case START_DESTROY_BLOCK: {
                                this.onBlockBreakStart(blockPos, blockFace);
                                break;
                            }
                            case ABORT_DESTROY_BLOCK: {
                                this.onBlockBreakAbort(blockPos, blockFace);
                                break;
                            }
                            case CONTINUE_DESTROY_BLOCK: {
                                break;
                            }
                            case PREDICT_DESTROY_BLOCK: {
                                this.onBlockBreakComplete(blockPos, blockFace);
                            }
                        }
                        this.lastBlockAction = action2;
                    }
                }
                if (this.teleportPosition != null) {
                    return;
                }
                if (this.riding instanceof EntityControllable && this.riding.isControlling(this)) {
                    boolean jumping = authPacket.getInputData().contains((Object)AuthInputAction.JUMPING);
                    if (jumping && this.riderJumpTick <= 0) {
                        this.riderJumpTick = this.server.getTick();
                    } else if (!jumping && this.riderJumpTick > 0) {
                        ((EntityControllable)((Object)this.riding)).onJump(this, this.server.getTick() - this.riderJumpTick);
                        this.riderJumpTick = 0;
                    }
                    double inputX = authPacket.getMotion().getX();
                    double inputY = authPacket.getMotion().getY();
                    if (inputX >= -1.001 && inputX <= 1.001 && inputY >= -1.001 && inputY <= 1.001) {
                        ((EntityControllable)((Object)this.riding)).onPlayerInput(this, inputX, inputY);
                    }
                } else if (this.riding instanceof EntityBoat && authPacket.getInputData().contains((Object)AuthInputAction.IN_CLIENT_PREDICTED_IN_VEHICLE) && this.riding.getId() == authPacket.getPredictedVehicle() && this.riding.isControlling(this) && this.temporalVector.setComponents(authPacket.getPosition().getX(), authPacket.getPosition().getY(), authPacket.getPosition().getZ()).distanceSquared(this.riding) < 16.0) {
                    ((EntityBoat)this.riding).onInput(authPacket.getPosition().getX(), authPacket.getPosition().getY(), authPacket.getPosition().getZ(), authPacket.getHeadYaw());
                }
                if (!this.isSpectator() && authPacket.getInputData().contains((Object)AuthInputAction.MISSED_SWING)) {
                    this.level.addLevelSoundEvent((Vector3)this, 42, -1, "minecraft:player", false, false);
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_SPRINTING)) {
                    PlayerToggleSprintEvent playerToggleSprintEvent = new PlayerToggleSprintEvent(this, true);
                    if (this.foodData.getLevel() <= 6 && !this.getAdventureSettings().get(AdventureSettings.Type.FLYING) || this.riding != null || this.sleeping != null || this.hasEffect(15) || this.isSneaking() && !authPacket.getInputData().contains((Object)AuthInputAction.STOP_SNEAKING)) {
                        playerToggleSprintEvent.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(playerToggleSprintEvent);
                    if (playerToggleSprintEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSprinting(true, false);
                    }
                    this.setUsingItem(false);
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_SPRINTING)) {
                    PlayerToggleSprintEvent playerToggleSprintEvent = new PlayerToggleSprintEvent(this, false);
                    this.server.getPluginManager().callEvent(playerToggleSprintEvent);
                    if (playerToggleSprintEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSprinting(false, false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_SNEAKING)) {
                    PlayerToggleSneakEvent playerToggleSneakEvent = new PlayerToggleSneakEvent(this, true);
                    if (this.riding != null || this.sleeping != null) {
                        playerToggleSneakEvent.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(playerToggleSneakEvent);
                    if (playerToggleSneakEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSneaking(true);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_SNEAKING)) {
                    PlayerToggleSneakEvent playerToggleSneakEvent = new PlayerToggleSneakEvent(this, false);
                    this.server.getPluginManager().callEvent(playerToggleSneakEvent);
                    if (playerToggleSneakEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSneaking(false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_CRAWLING)) {
                    PlayerToggleCrawlEvent playerToggleCrawlEvent = new PlayerToggleCrawlEvent(this, true);
                    if (this.riding != null || this.sleeping != null) {
                        playerToggleCrawlEvent.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(playerToggleCrawlEvent);
                    if (playerToggleCrawlEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setCrawling(true);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_CRAWLING)) {
                    PlayerToggleCrawlEvent playerToggleCrawlEvent = new PlayerToggleCrawlEvent(this, false);
                    this.server.getPluginManager().callEvent(playerToggleCrawlEvent);
                    if (playerToggleCrawlEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setCrawling(false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_JUMPING)) {
                    this.server.getPluginManager().callEvent(new PlayerJumpEvent(this));
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_GLIDING)) {
                    boolean withoutElytra = false;
                    Item chestplate = this.getInventory().getChestplateFast();
                    if (chestplate == null || chestplate.getId() != 444 || chestplate.getDamage() >= chestplate.getMaxDurability()) {
                        withoutElytra = true;
                    }
                    if (withoutElytra && !this.server.getAllowFlight()) {
                        this.kick(PlayerKickEvent.Reason.FLYING_DISABLED, MSG_FLYING_NOT_ENABLED, true);
                        return;
                    }
                    PlayerToggleGlideEvent playerToggleGlideEvent = new PlayerToggleGlideEvent(this, true);
                    if (this.riding != null || this.sleeping != null || withoutElytra) {
                        playerToggleGlideEvent.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(playerToggleGlideEvent);
                    if (playerToggleGlideEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setGliding(true);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_GLIDING)) {
                    PlayerToggleGlideEvent playerToggleGlideEvent = new PlayerToggleGlideEvent(this, false);
                    this.server.getPluginManager().callEvent(playerToggleGlideEvent);
                    if (playerToggleGlideEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setGliding(false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_SWIMMING)) {
                    PlayerToggleSwimEvent ptse = new PlayerToggleSwimEvent(this, true);
                    if (this.riding != null || this.sleeping != null || !this.isInsideOfWater()) {
                        ptse.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(ptse);
                    if (ptse.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSwimming(true);
                    }
                    this.setUsingItem(false);
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_SWIMMING)) {
                    PlayerToggleSwimEvent ptse = new PlayerToggleSwimEvent(this, false);
                    this.server.getPluginManager().callEvent(ptse);
                    if (ptse.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSwimming(false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_SPIN_ATTACK)) {
                    PlayerToggleSpinAttackEvent playerToggleSpinAttackEvent = new PlayerToggleSpinAttackEvent(this, false);
                    this.server.getPluginManager().callEvent(playerToggleSpinAttackEvent);
                    if (playerToggleSpinAttackEvent.isCancelled()) {
                        this.needSendData = true;
                    } else {
                        this.setSpinAttack(false);
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.START_FLYING)) {
                    if (!this.server.getAllowFlight() && !this.adventureSettings.get(AdventureSettings.Type.ALLOW_FLIGHT)) {
                        this.kick(PlayerKickEvent.Reason.FLYING_DISABLED, MSG_FLYING_NOT_ENABLED, true);
                        break;
                    }
                    PlayerToggleFlightEvent playerToggleFlightEvent = new PlayerToggleFlightEvent(this, true);
                    this.server.getPluginManager().callEvent(playerToggleFlightEvent);
                    if (playerToggleFlightEvent.isCancelled()) {
                        this.needSendAdventureSettings = true;
                    } else {
                        this.adventureSettings.set(AdventureSettings.Type.FLYING, playerToggleFlightEvent.isFlying());
                    }
                }
                if (authPacket.getInputData().contains((Object)AuthInputAction.STOP_FLYING)) {
                    PlayerToggleFlightEvent playerToggleFlightEvent = new PlayerToggleFlightEvent(this, false);
                    if (this.isSpectator()) {
                        playerToggleFlightEvent.setCancelled(true);
                    }
                    this.server.getPluginManager().callEvent(playerToggleFlightEvent);
                    if (playerToggleFlightEvent.isCancelled()) {
                        this.needSendAdventureSettings = true;
                    } else {
                        this.adventureSettings.set(AdventureSettings.Type.FLYING, playerToggleFlightEvent.isFlying());
                    }
                }
                if (this.adventureSettings.get(AdventureSettings.Type.FLYING)) {
                    this.flySneaking = authPacket.getInputData().contains((Object)AuthInputAction.SNEAKING);
                }
                if ((distSqrt = (clientPosition = authPacket.getPosition().subtract(0.0f, this.riding == null ? this.getBaseOffset() : this.riding.getMountedOffset(this).getY(), 0.0f).asVector3()).distanceSquared(this)) > 100.0) {
                    this.sendPosition(this, authPacket.getYaw(), authPacket.getPitch(), 1);
                    this.server.getLogger().debug(this.username + ": move " + distSqrt + " > 100");
                    return;
                }
                boolean revertMotion = false;
                if (!this.isAlive() || !this.spawned) {
                    revertMotion = true;
                    this.forceMovement = this;
                }
                if (this.forceMovement != null && (revertMotion || clientPosition.distanceSquared(this.forceMovement) > 0.1)) {
                    this.sendPosition(this.forceMovement, authPacket.getYaw(), authPacket.getPitch(), 1);
                } else {
                    float yaw = authPacket.getYaw() % 360.0f;
                    float pitch = authPacket.getPitch() % 360.0f;
                    if (yaw < 0.0f) {
                        yaw += 360.0f;
                    }
                    this.setRotation(yaw, pitch);
                    this.newPosition = clientPosition;
                    this.clientMovements.offer(clientPosition);
                    this.forceMovement = null;
                }
                return;
            }
            case 31: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                MobEquipmentPacket mobEquipmentPacket = (MobEquipmentPacket)packet;
                if (mobEquipmentPacket.windowId != 0) {
                    return;
                }
                if (this.inventory == null) {
                    return;
                }
                this.inventory.equipItem(mobEquipmentPacket.hotbarSlot);
                this.setUsingItem(false);
                return;
            }
            case 36: {
                PlayerActionPacket playerActionPacket = (PlayerActionPacket)packet;
                if (!this.spawned || !this.isAlive() && playerActionPacket.action != 7) {
                    return;
                }
                playerActionPacket.entityId = this.id;
                switch (playerActionPacket.action) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 6: {
                        this.stopSleep();
                        return;
                    }
                    case 7: {
                        if (!this.spawned || this.isAlive() || !this.isOnline()) {
                            return;
                        }
                        this.respawn();
                        break;
                    }
                    case 8: {
                        return;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        return;
                    }
                    case 11: {
                        return;
                    }
                    case 12: {
                        return;
                    }
                    case 14: {
                        if (this.awaitingDimensionAck) {
                            this.sendPosition(this, this.yaw, this.pitch, 1);
                            this.dummyBossBars.values().forEach(DummyBossBar::reshow);
                            this.awaitingDimensionAck = false;
                        } else {
                            this.getServer().getLogger().debug(this.username + ": got a dimension change ack but no dimension change is in progress");
                        }
                        return;
                    }
                    case 15: {
                        return;
                    }
                    case 16: {
                        return;
                    }
                    case 18: {
                        return;
                    }
                    case 21: {
                        break;
                    }
                    case 22: {
                        return;
                    }
                }
                this.setUsingItem(false);
                return;
            }
            case 101: {
                this.formOpen = false;
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                ModalFormResponsePacket modalFormPacket = (ModalFormResponsePacket)packet;
                if (this.formWindows.containsKey(modalFormPacket.formId)) {
                    FormWindow window2 = this.formWindows.remove(modalFormPacket.formId);
                    window2.setResponse(modalFormPacket.data.trim());
                    for (FormResponseHandler handler : window2.getHandlers()) {
                        handler.handle(this, modalFormPacket.formId);
                    }
                    PlayerFormRespondedEvent event = new PlayerFormRespondedEvent(this, modalFormPacket.formId, window2);
                    this.getServer().getPluginManager().callEvent(event);
                } else if (this.serverSettings.containsKey(modalFormPacket.formId)) {
                    FormWindow window3 = this.serverSettings.get(modalFormPacket.formId);
                    window3.setResponse(modalFormPacket.data.trim());
                    for (FormResponseHandler handler : window3.getHandlers()) {
                        handler.handle(this, modalFormPacket.formId);
                    }
                    PlayerSettingsRespondedEvent event = new PlayerSettingsRespondedEvent(this, modalFormPacket.formId, window3);
                    this.getServer().getPluginManager().callEvent(event);
                    if (!event.isCancelled() && window3 instanceof FormWindowCustom) {
                        ((FormWindowCustom)window3).setElementsFromResponse();
                    }
                }
                return;
            }
            case 33: {
                Player targetEntity;
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                InteractPacket interactPacket = (InteractPacket)packet;
                if (interactPacket.target == 0L && interactPacket.action == 4) {
                    this.setButtonText("");
                    return;
                }
                Entity entity = targetEntity = interactPacket.target == this.getId() ? this : this.level.getEntity(interactPacket.target);
                if (!(targetEntity != null && this.isAlive() && targetEntity.isAlive() || targetEntity == null && interactPacket.action == 6)) {
                    return;
                }
                if (targetEntity instanceof EntityItem || targetEntity instanceof EntityArrow || targetEntity instanceof EntityXPOrb) {
                    this.kick(PlayerKickEvent.Reason.INVALID_PVE);
                    return;
                }
                switch (interactPacket.action) {
                    case 6: {
                        if (!this.inventoryOpen) {
                            if (this.riding instanceof EntityChestBoat && this.riding == targetEntity) {
                                this.addWindow(((InventoryHolder)targetEntity).getInventory());
                            } else if (this.inventory.open(this)) {
                                this.inventoryOpen = true;
                                this.awardAchievement("openInventory");
                            }
                        }
                        return;
                    }
                    case 4: {
                        String buttonText = "";
                        if (targetEntity instanceof EntityInteractable && (buttonText = ((EntityInteractable)((Object)targetEntity)).getInteractButtonText(this)) == null) {
                            buttonText = "";
                        }
                        this.setButtonText(buttonText);
                        this.getServer().getPluginManager().callEvent(new PlayerMouseOverEntityEvent(this, targetEntity));
                        return;
                    }
                    case 3: {
                        if (!(targetEntity instanceof EntityRideable) || this.riding != targetEntity) {
                            return;
                        }
                        this.riderJumpTick = 0;
                        ((EntityRideable)((Object)this.riding)).dismountEntity(this);
                        return;
                    }
                }
                return;
            }
            case 34: {
                CompoundTag nbt;
                BlockEntity blockEntity;
                if (!this.spawned || !this.isAlive() || this.inventory == null || this.inventoryOpen) {
                    return;
                }
                BlockPickRequestPacket pickRequestPacket = (BlockPickRequestPacket)packet;
                Block block = this.level.getBlock(this.chunk, pickRequestPacket.x, pickRequestPacket.y, pickRequestPacket.z, false);
                if (block.distanceSquared(this) > 1000.0) {
                    this.getServer().getLogger().debug(this.username + ": block pick request for a block too far away");
                    return;
                }
                Item item = block.toItem();
                if (pickRequestPacket.addUserData && this.isCreative() && (blockEntity = this.getLevel().getBlockEntityIfLoaded(this.chunk, this.temporalVector.setComponents(pickRequestPacket.x, pickRequestPacket.y, pickRequestPacket.z))) != null && (nbt = blockEntity.getCleanedNBT()) != null) {
                    item.setCustomBlockData(nbt);
                    item.setLore("+(DATA)");
                }
                PlayerBlockPickEvent pickEvent = new PlayerBlockPickEvent(this, block, item);
                if (this.isSpectator()) {
                    pickEvent.setCancelled();
                }
                this.server.getPluginManager().callEvent(pickEvent);
                if (!pickEvent.isCancelled()) {
                    int slot;
                    boolean itemExists = false;
                    int itemSlot = -1;
                    for (slot = 0; slot < this.inventory.getSize(); ++slot) {
                        if (!this.inventory.getItem(slot).equals(pickEvent.getItem())) continue;
                        if (slot < this.inventory.getHotbarSize()) {
                            this.inventory.setHeldItemSlot(slot);
                        } else {
                            itemSlot = slot;
                        }
                        itemExists = true;
                        break;
                    }
                    if (!itemExists && !this.isCreative()) {
                        return;
                    }
                    for (slot = 0; slot < this.inventory.getHotbarSize(); ++slot) {
                        if (!this.inventory.getItem(slot).isNull()) continue;
                        if (!itemExists && this.isCreative()) {
                            this.inventory.setHeldItemSlot(slot);
                            this.inventory.setItemInHand(pickEvent.getItem());
                            return;
                        }
                        if (itemSlot <= -1) continue;
                        this.inventory.setHeldItemSlot(slot);
                        this.inventory.setItemInHand(this.inventory.getItem(itemSlot));
                        this.inventory.clear(itemSlot, true);
                        return;
                    }
                    if (!itemExists && this.isCreative()) {
                        Item itemInHand = this.inventory.getItemInHand();
                        this.inventory.setItemInHand(pickEvent.getItem());
                        if (!this.inventory.isFull()) {
                            for (int slot2 = 0; slot2 < this.inventory.getSize(); ++slot2) {
                                if (!this.inventory.getItem(slot2).isNull()) continue;
                                this.inventory.setItem(slot2, itemInHand);
                                return;
                            }
                        }
                    } else if (itemSlot > -1) {
                        Item itemInHand = this.inventory.getItemInHand();
                        this.inventory.setItemInHand(this.inventory.getItem(itemSlot));
                        this.inventory.setItem(itemSlot, itemInHand);
                    }
                }
                return;
            }
            case 44: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                AnimatePacket animatePacket = (AnimatePacket)packet;
                if (animatePacket.action != AnimatePacket.Action.SWING_ARM && (this.riding == null || animatePacket.action != AnimatePacket.Action.ROW_LEFT && animatePacket.action != AnimatePacket.Action.ROW_RIGHT)) {
                    return;
                }
                PlayerAnimationEvent animationEvent = new PlayerAnimationEvent(this, animatePacket.action);
                this.server.getPluginManager().callEvent(animationEvent);
                if (animationEvent.isCancelled()) {
                    return;
                }
                AnimatePacket.Action animation = animationEvent.getAnimationType();
                switch (animation) {
                    case ROW_RIGHT: 
                    case ROW_LEFT: {
                        if (!(this.riding instanceof EntityBoat)) break;
                        ((EntityBoat)this.riding).onPaddle(animation, animatePacket.rowingTime);
                    }
                }
                animatePacket = new AnimatePacket();
                animatePacket.eid = this.getId();
                animatePacket.action = animationEvent.getAnimationType();
                Server.broadcastPacket(this.getViewers().values(), (DataPacket)animatePacket);
                return;
            }
            case 27: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                EntityEventPacket entityEventPacket = (EntityEventPacket)packet;
                if (entityEventPacket.event != 34) {
                    this.craftingType = 0;
                }
                switch (entityEventPacket.event) {
                    case 57: {
                        if (entityEventPacket.data == 0 || entityEventPacket.eid != this.id) {
                            this.getServer().getLogger().debug(this.username + ": entity event eid mismatch");
                            return;
                        }
                        entityEventPacket.eid = this.id;
                        entityEventPacket.isEncoded = false;
                        this.dataPacket(entityEventPacket);
                        Server.broadcastPacket(this.getViewers().values(), (DataPacket)entityEventPacket);
                        return;
                    }
                    case 34: {
                        if (entityEventPacket.eid != this.id) {
                            this.getServer().getLogger().debug(this.username + ": entity event eid mismatch");
                            return;
                        }
                        Inventory inventory = this.getWindowById(2);
                        if (inventory instanceof AnvilInventory) {
                            ((AnvilInventory)inventory).setCost(-entityEventPacket.data);
                        }
                        return;
                    }
                }
                return;
            }
            case 77: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                this.resetCraftingGridType();
                CommandRequestPacket commandRequestPacket = (CommandRequestPacket)packet;
                PlayerCommandPreprocessEvent playerCommandPreprocessEvent = new PlayerCommandPreprocessEvent(this, commandRequestPacket.command + ' ');
                this.server.getPluginManager().callEvent(playerCommandPreprocessEvent);
                if (playerCommandPreprocessEvent.isCancelled()) {
                    return;
                }
                this.server.dispatchCommand(playerCommandPreprocessEvent.getPlayer(), playerCommandPreprocessEvent.getMessage().substring(1));
                return;
            }
            case 9: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                TextPacket textPacket = (TextPacket)packet;
                if (textPacket.type == 1 && textPacket.message.length() < 512) {
                    String chatMessage = textPacket.message;
                    int breakLine = chatMessage.indexOf(10);
                    if (breakLine != -1) {
                        chatMessage = chatMessage.substring(0, breakLine);
                    }
                    this.chat(chatMessage);
                }
                return;
            }
            case 47: {
                ContainerClosePacket containerClosePacket = (ContainerClosePacket)packet;
                if (!this.spawned || containerClosePacket.windowId == 0 && !this.inventoryOpen) {
                    return;
                }
                if (this.windowIndex.containsKey(containerClosePacket.windowId)) {
                    this.server.getPluginManager().callEvent(new InventoryCloseEvent((Inventory)this.windowIndex.get(containerClosePacket.windowId), this));
                    if (containerClosePacket.windowId == 0) {
                        this.inventoryOpen = false;
                    }
                    this.closingWindowId = containerClosePacket.windowId;
                    this.removeWindow((Inventory)this.windowIndex.get(containerClosePacket.windowId), true);
                    this.closingWindowId = Integer.MIN_VALUE;
                }
                if (containerClosePacket.windowId == -1) {
                    this.resetCraftingGridType();
                    this.addWindow(this.craftingGrid, -1);
                    ContainerClosePacket pk = new ContainerClosePacket();
                    pk.windowId = -1;
                    pk.wasServerInitiated = false;
                    this.dataPacket(pk);
                } else {
                    ContainerClosePacket pk = new ContainerClosePacket();
                    pk.windowId = containerClosePacket.windowId;
                    pk.wasServerInitiated = false;
                    this.dataPacket(pk);
                    for (Inventory open : new ArrayList(this.windows.keySet())) {
                        if (!(open instanceof ContainerInventory)) continue;
                        this.removeWindow(open);
                    }
                }
                return;
            }
            case 56: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                BlockEntityDataPacket blockEntityDataPacket = (BlockEntityDataPacket)packet;
                this.resetCraftingGridType();
                Vector3 pos = this.temporalVector.setComponents(blockEntityDataPacket.x, blockEntityDataPacket.y, blockEntityDataPacket.z);
                if (pos.distanceSquared(this) > 2500.0) {
                    if (Nukkit.DEBUG > 1) {
                        this.server.getLogger().debug(this.username + ": BlockEntityDataPacket target too far " + pos);
                    }
                    return;
                }
                BlockEntity t2 = this.level.getBlockEntity(pos);
                if (t2 instanceof BlockEntitySpawnable) {
                    CompoundTag nbt;
                    try {
                        nbt = NBTIO.read(blockEntityDataPacket.namedTag, ByteOrder.LITTLE_ENDIAN, true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (!((BlockEntitySpawnable)t2).updateCompoundTag(nbt, this)) {
                        ((BlockEntitySpawnable)t2).spawnTo(this);
                    }
                }
                return;
            }
            case 69: {
                RequestChunkRadiusPacket requestChunkRadiusPacket = (RequestChunkRadiusPacket)packet;
                ChunkRadiusUpdatedPacket chunkRadiusUpdatePacket = new ChunkRadiusUpdatedPacket();
                chunkRadiusUpdatePacket.radius = this.chunkRadius = Math.max(3, Math.min(requestChunkRadiusPacket.radius, this.viewDistance));
                this.dataPacket(chunkRadiusUpdatePacket);
                return;
            }
            case 62: {
                if (!this.spawned) {
                    return;
                }
                SetPlayerGameTypePacket setPlayerGameTypePacket = (SetPlayerGameTypePacket)packet;
                if (setPlayerGameTypePacket.gamemode != this.gamemode) {
                    if (!this.hasPermission("nukkit.command.gamemode")) {
                        if (!this.isOp()) {
                            this.kick(PlayerKickEvent.Reason.INVALID_PACKET, "Invalid SetPlayerGameTypePacket", true);
                        }
                        return;
                    }
                    this.setGamemode(setPlayerGameTypePacket.gamemode, true);
                    Command.broadcastCommandMessage((CommandSender)this, new TranslationContainer("commands.gamemode.success.self", Server.getGamemodeString(this.gamemode)));
                }
                return;
            }
            case 68: {
                if (this.inventory == null) {
                    return;
                }
                MapInfoRequestPacket pk = (MapInfoRequestPacket)packet;
                Item mapItem = null;
                for (Item item1 : this.offhandInventory.getContents().values()) {
                    if (!(item1 instanceof ItemMap) || ((ItemMap)item1).getMapId() != pk.mapId) continue;
                    mapItem = item1;
                }
                if (mapItem == null) {
                    for (Item item1 : this.inventory.getContents().values()) {
                        if (!(item1 instanceof ItemMap) || ((ItemMap)item1).getMapId() != pk.mapId) continue;
                        mapItem = item1;
                    }
                }
                if (mapItem == null) {
                    for (BlockEntity be : this.level.getBlockEntities().values()) {
                        BlockEntityItemFrame itemFrame1;
                        if (!(be instanceof BlockEntityItemFrame) || !((itemFrame1 = (BlockEntityItemFrame)be).getItem() instanceof ItemMap) || ((ItemMap)itemFrame1.getItem()).getMapId() != pk.mapId) continue;
                        ((ItemMap)itemFrame1.getItem()).sendImage(this);
                        return;
                    }
                } else {
                    PlayerMapInfoRequestEvent event = new PlayerMapInfoRequestEvent(this, mapItem);
                    this.getServer().getPluginManager().callEvent(event);
                    if (!event.isCancelled()) {
                        ItemMap map = (ItemMap)mapItem;
                        if (map.trySendImage(this)) {
                            return;
                        }
                        try {
                            BufferedImage image = new BufferedImage(128, 128, 1);
                            Graphics2D graphics = image.createGraphics();
                            int worldX = Math.floorDiv(this.getFloorX(), 128) << 7;
                            int worldZ = Math.floorDiv(this.getFloorZ(), 128) << 7;
                            for (int x = 0; x < 128; ++x) {
                                int avgY = 0;
                                for (int y = -1; y < 128; ++y) {
                                    if (this.getLevel().getDimension() == 1) {
                                        if (y == -1) continue;
                                        graphics.setColor(Player.colorizeMapColor(new SplittableRandom((((long)(worldZ + y) & 0x3FFFFFFL) << 26) + ((long)(worldX + x) & 0x3FFFFFFL)).nextBoolean() ? BlockColor.STONE_BLOCK_COLOR : BlockColor.DIRT_BLOCK_COLOR, 1));
                                    } else {
                                        if (y == -1) {
                                            avgY = this.getLevel().getHighestBlockAt(worldX + x, worldZ, false);
                                            continue;
                                        }
                                        int worldY = this.getLevel().getHighestBlockAt(worldX + x, worldZ + y, false);
                                        double avgYDifference = (double)((worldY - avgY) * 4 / 5) + ((double)(x + y & 1) - 0.5) * 0.4;
                                        int colorDepth = 1;
                                        if (avgYDifference > 0.6) {
                                            colorDepth = 2;
                                        }
                                        if (avgYDifference < -0.6) {
                                            colorDepth = 0;
                                        }
                                        avgY = worldY;
                                        graphics.setColor(Player.colorizeMapColor(this.getLevel().getMapColorAt(worldX + x, worldY, worldZ + y), colorDepth));
                                    }
                                    graphics.fillRect(x, y, x + 1, y + 1);
                                }
                            }
                            map.setImage(image);
                            map.sendImage(this);
                        }
                        catch (Exception ex) {
                            this.getServer().getLogger().debug(this.username + ": there was an error while generating map image", ex);
                        }
                    }
                }
                return;
            }
            case 30: {
                SmithingInventory smithingInventory;
                Inventory inv;
                if (this.isSpectator()) {
                    this.needSendInventory = true;
                    return;
                }
                Object transactionPacket = (InventoryTransactionPacket)packet;
                if ((((InventoryTransactionPacket)transactionPacket).transactionType == 1 || ((InventoryTransactionPacket)transactionPacket).transactionType == 0 && this.isCreative() && Arrays.stream(((InventoryTransactionPacket)transactionPacket).actions).anyMatch(action -> action.sourceType == 99999)) && (inv = this.getWindowById(6)) instanceof SmithingInventory && !(smithingInventory = (SmithingInventory)inv).getResult().isNull()) {
                    InventoryTransactionPacket fixedPacket = new InventoryTransactionPacket();
                    fixedPacket.isRepairItemPart = true;
                    fixedPacket.actions = new NetworkInventoryAction[6];
                    Item fromIngredient = smithingInventory.getIngredient().clone();
                    Item toIngredient = fromIngredient.decrement(1);
                    Item fromEquipment = smithingInventory.getEquipment().clone();
                    Item toEquipment = fromEquipment.decrement(1);
                    Item fromResult = Item.get(0);
                    Item toResult = smithingInventory.getResult().clone();
                    NetworkInventoryAction action3 = new NetworkInventoryAction();
                    action3.windowId = 124;
                    action3.inventorySlot = 52;
                    action3.oldItem = fromIngredient.clone();
                    action3.newItem = toIngredient.clone();
                    fixedPacket.actions[0] = action3;
                    action3 = new NetworkInventoryAction();
                    action3.windowId = 124;
                    action3.inventorySlot = 51;
                    action3.oldItem = fromEquipment.clone();
                    action3.newItem = toEquipment.clone();
                    fixedPacket.actions[1] = action3;
                    if (this.getLoginChainData().getUIProfile() == 0) {
                        Item[] drops = this.inventory.addItem(this.playerUIInventory.getItemFast(0));
                        this.playerUIInventory.getCursorInventory().clear(0);
                        for (Item drop : drops) {
                            this.level.dropItem(this, drop);
                        }
                        action3 = new NetworkInventoryAction();
                        action3.windowId = 124;
                        action3.inventorySlot = 0;
                        action3.oldItem = Item.get(0);
                        action3.newItem = toResult.clone();
                        fixedPacket.actions[2] = action3;
                    } else {
                        int emptyPlayerSlot = -1;
                        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
                            if (!this.inventory.getItemFast(slot).isNull()) continue;
                            emptyPlayerSlot = slot;
                            break;
                        }
                        if (emptyPlayerSlot == -1) {
                            this.needSendInventory = true;
                            return;
                        }
                        action3 = new NetworkInventoryAction();
                        action3.windowId = 0;
                        action3.inventorySlot = emptyPlayerSlot;
                        action3.oldItem = Item.get(0);
                        action3.newItem = toResult.clone();
                        fixedPacket.actions[2] = action3;
                    }
                    action3 = new NetworkInventoryAction();
                    action3.sourceType = 99999;
                    action3.windowId = -12;
                    action3.inventorySlot = 2;
                    action3.oldItem = toResult.clone();
                    action3.newItem = fromResult.clone();
                    fixedPacket.actions[3] = action3;
                    action3 = new NetworkInventoryAction();
                    action3.sourceType = 99999;
                    action3.windowId = -10;
                    action3.inventorySlot = 0;
                    action3.oldItem = toEquipment.clone();
                    action3.newItem = fromEquipment.clone();
                    fixedPacket.actions[4] = action3;
                    action3 = new NetworkInventoryAction();
                    action3.sourceType = 99999;
                    action3.windowId = -11;
                    action3.inventorySlot = 1;
                    action3.oldItem = toIngredient.clone();
                    action3.newItem = fromIngredient.clone();
                    fixedPacket.actions[5] = action3;
                    transactionPacket = fixedPacket;
                }
                ArrayList<InventoryAction> actions = new ArrayList<InventoryAction>();
                for (NetworkInventoryAction networkInventoryAction : ((InventoryTransactionPacket)transactionPacket).actions) {
                    InventoryAction a = networkInventoryAction.createInventoryAction(this);
                    if (a == null) {
                        this.getServer().getLogger().debug("Unmatched inventory action from " + this.username + ": " + networkInventoryAction);
                        this.needSendInventory = true;
                        return;
                    }
                    actions.add(a);
                }
                if (((InventoryTransactionPacket)transactionPacket).isCraftingPart) {
                    if (LoomTransaction.checkForItemPart(actions)) {
                        if (this.loomTransaction == null) {
                            this.loomTransaction = new LoomTransaction(this, actions);
                        } else {
                            for (InventoryAction action4 : actions) {
                                this.loomTransaction.addAction(action4);
                            }
                        }
                        if (this.loomTransaction.canExecute() && this.loomTransaction.execute()) {
                            this.level.addLevelSoundEvent(this, 273);
                        }
                        this.loomTransaction = null;
                        return;
                    }
                    if (this.craftingTransaction == null) {
                        this.craftingTransaction = new CraftingTransaction(this, actions);
                    } else {
                        for (InventoryAction action5 : actions) {
                            this.craftingTransaction.addAction(action5);
                        }
                    }
                    if (this.craftingTransaction.getPrimaryOutput() != null && this.craftingTransaction.canExecute()) {
                        try {
                            this.craftingTransaction.execute();
                        }
                        catch (Exception e) {
                            this.server.getLogger().debug(this.username + ": executing crafting transaction failed");
                        }
                        this.craftingTransaction = null;
                    }
                    return;
                }
                if (((InventoryTransactionPacket)transactionPacket).isEnchantingPart) {
                    if (this.enchantTransaction == null) {
                        this.enchantTransaction = new EnchantTransaction(this, actions);
                    } else {
                        for (InventoryAction action6 : actions) {
                            this.enchantTransaction.addAction(action6);
                        }
                    }
                    if (this.enchantTransaction.canExecute()) {
                        this.enchantTransaction.execute();
                        this.enchantTransaction = null;
                    }
                    return;
                }
                if (((InventoryTransactionPacket)transactionPacket).isRepairItemPart) {
                    if (SmithingTransaction.checkForItemPart(actions)) {
                        if (this.smithingTransaction == null) {
                            this.smithingTransaction = new SmithingTransaction(this, actions);
                        } else {
                            for (InventoryAction action7 : actions) {
                                this.smithingTransaction.addAction(action7);
                            }
                        }
                        if (this.smithingTransaction.canExecute()) {
                            if (this.smithingTransaction.execute()) {
                                Collection<Player> players = this.level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values();
                                players.remove(this);
                                if (!players.isEmpty()) {
                                    this.level.addLevelSoundEvent(this, 280);
                                }
                            }
                            this.smithingTransaction = null;
                        }
                    } else {
                        if (this.repairItemTransaction == null) {
                            this.repairItemTransaction = new RepairItemTransaction(this, actions);
                        } else {
                            for (InventoryAction action8 : actions) {
                                this.repairItemTransaction.addAction(action8);
                            }
                        }
                        if (this.repairItemTransaction.canExecute()) {
                            this.repairItemTransaction.execute();
                            this.repairItemTransaction = null;
                        }
                    }
                    return;
                }
                if (this.craftingTransaction != null) {
                    if (this.craftingTransaction.checkForCraftingPart(actions)) {
                        if (this.craftingType == 1004) {
                            this.craftingTransaction = null;
                            return;
                        }
                        for (InventoryAction action9 : actions) {
                            this.craftingTransaction.addAction(action9);
                        }
                        return;
                    }
                    this.server.getLogger().debug("Got unexpected normal inventory action with incomplete crafting transaction from " + this.username + ", refusing to execute crafting");
                    this.removeAllWindows(false);
                    this.needSendInventory = true;
                    this.craftingTransaction = null;
                } else if (this.enchantTransaction != null) {
                    if (this.enchantTransaction.checkForEnchantPart(actions)) {
                        for (InventoryAction action10 : actions) {
                            this.enchantTransaction.addAction(action10);
                        }
                        return;
                    }
                    this.server.getLogger().debug("Got unexpected normal inventory action with incomplete enchanting transaction from " + this.username + ", refusing to execute enchant " + ((InventoryTransactionPacket)transactionPacket).toString());
                    this.removeAllWindows(false);
                    this.enchantTransaction = null;
                    this.needSendInventory = true;
                } else if (this.repairItemTransaction != null) {
                    if (RepairItemTransaction.checkForRepairItemPart(actions)) {
                        for (InventoryAction action11 : actions) {
                            this.repairItemTransaction.addAction(action11);
                        }
                        return;
                    }
                    this.server.getLogger().debug("Got unexpected normal inventory action with incomplete repair item transaction from " + this.username + ", refusing to execute repair item " + ((InventoryTransactionPacket)transactionPacket).toString());
                    this.removeAllWindows(false);
                    this.repairItemTransaction = null;
                    this.needSendInventory = true;
                } else if (this.smithingTransaction != null) {
                    if (SmithingTransaction.checkForItemPart(actions)) {
                        for (InventoryAction action12 : actions) {
                            this.smithingTransaction.addAction(action12);
                        }
                        return;
                    }
                    this.server.getLogger().debug("Got unexpected normal inventory action with incomplete repair item transaction from " + this.username + ", refusing to execute smithing " + ((InventoryTransactionPacket)transactionPacket).toString());
                    this.removeAllWindows(false);
                    this.smithingTransaction = null;
                    this.needSendInventory = true;
                }
                switch (((InventoryTransactionPacket)transactionPacket).transactionType) {
                    case 0: {
                        InventoryTransaction transaction = new InventoryTransaction(this, actions);
                        if (!transaction.execute()) {
                            this.server.getLogger().debug("Failed to execute inventory transaction from " + this.username + " with actions: " + Arrays.toString(((InventoryTransactionPacket)transactionPacket).actions));
                            return;
                        }
                        return;
                    }
                    case 1: {
                        if (((InventoryTransactionPacket)transactionPacket).actions.length > 0) {
                            this.server.getLogger().debug("Expected 0 actions for mismatch, got " + ((InventoryTransactionPacket)transactionPacket).actions.length + ", " + Arrays.toString(((InventoryTransactionPacket)transactionPacket).actions));
                        }
                        this.needSendInventory = true;
                        return;
                    }
                    case 2: {
                        UseItemData useItemData = (UseItemData)((InventoryTransactionPacket)transactionPacket).transactionData;
                        BlockVector3 blockVector = useItemData.blockPos;
                        BlockFace face = useItemData.face;
                        int type = useItemData.actionType;
                        this.setShieldBlockingDelay(5);
                        boolean itemSent = false;
                        if (this.inventory.getHeldItemIndex() != useItemData.hotbarSlot) {
                            this.inventory.equipItem(useItemData.hotbarSlot);
                            itemSent = true;
                        }
                        switch (type) {
                            case 0: {
                                Block part;
                                BlockDoor door;
                                if (this.lastRightClickPos != null && this.getInventory().getItemInHandFast().getBlockId() == 0 && (double)System.currentTimeMillis() - this.lastRightClickTime < 200.0 && blockVector.distanceSquared(this.lastRightClickPos) < 1.0E-5) {
                                    return;
                                }
                                this.lastRightClickPos = blockVector.asVector3();
                                this.lastRightClickTime = System.currentTimeMillis();
                                this.breakingBlock = null;
                                this.setUsingItem(false);
                                if (this.canInteract(blockVector.add(0.5, 0.5, 0.5), this.isCreative() ? 14.0 : 8.0)) {
                                    Item i = this.inventory.getItemInHand();
                                    if (this.isCreative()) {
                                        if (this.level.useItemOn(blockVector.asVector3(), i, face, useItemData.clickPos.x, useItemData.clickPos.y, useItemData.clickPos.z, this) != null) {
                                            return;
                                        }
                                    } else {
                                        Item oldItem = i.clone();
                                        i = this.level.useItemOn(blockVector.asVector3(), i, face, useItemData.clickPos.x, useItemData.clickPos.y, useItemData.clickPos.z, this);
                                        if (i != null) {
                                            if (i.getCount() != oldItem.getCount() || i.getDamage() != oldItem.getDamage() || !i.equals(oldItem)) {
                                                if (oldItem.getId() == i.getId() || i.getId() == 0) {
                                                    this.inventory.setItemInHand(i);
                                                    itemSent = true;
                                                } else if (Nukkit.DEBUG > 1) {
                                                    this.server.getLogger().debug("Tried to set item " + i.getId() + " but " + this.username + " had item " + oldItem.getId() + " in their hand slot");
                                                }
                                            }
                                            if (!itemSent && !oldItem.equals(useItemData.itemInHand)) {
                                                this.needSendHeldItem = true;
                                            }
                                            return;
                                        }
                                    }
                                }
                                this.needSendHeldItem = true;
                                if (blockVector.distanceSquared(this) > 10000.0) {
                                    return;
                                }
                                Block target = this.level.getBlock(blockVector.asVector3());
                                Block block = target.getSide(face);
                                this.level.sendBlocks(this, (Vector3[])new Block[]{target, block}, 11);
                                if (target instanceof BlockDoor && ((door = (BlockDoor)target).getDamage() & 8) > 0 && (part = target.down()).getId() == target.getId()) {
                                    target = part;
                                    this.level.sendBlocks(this, (Vector3[])new Block[]{target}, 11);
                                }
                                return;
                            }
                            case 2: {
                                return;
                            }
                            case 1: {
                                if (!this.spawned || !this.isAlive()) {
                                    return;
                                }
                                if (this.inventory.getHeldItemIndex() != useItemData.hotbarSlot) {
                                    this.inventory.equipItem(useItemData.hotbarSlot);
                                    this.crossbowLoadTick = 0;
                                }
                                Item item = this.inventory.getItemInHand();
                                this.breakingBlock = null;
                                Vector3 directionVector = this.getDirectionVector();
                                PlayerInteractEvent interactEvent = new PlayerInteractEvent(this, item, directionVector, face, PlayerInteractEvent.Action.RIGHT_CLICK_AIR);
                                this.server.getPluginManager().callEvent(interactEvent);
                                if (interactEvent.isCancelled()) {
                                    this.needSendHeldItem = true;
                                    return;
                                }
                                if (item instanceof ItemCrossbow) {
                                    ItemCrossbow crossbow = (ItemCrossbow)item;
                                    if (crossbow.isLoaded()) {
                                        if (this.crossbowLoadTick + 5 < this.server.getTick()) {
                                            crossbow.launchArrow(this);
                                        }
                                    } else if (this.isUsingItem()) {
                                        int ticksUsed = this.server.getTick() - this.startAction;
                                        this.crossbowLoadTick = this.server.getTick();
                                        this.setUsingItem(false);
                                        item.onUse(this, ticksUsed);
                                    } else {
                                        this.setUsingItem(true);
                                        this.getLevel().addLevelSoundEvent(this, 245);
                                    }
                                    return;
                                }
                                int oldCount = item.getCount();
                                int oldDamage = item.getDamage();
                                if (item.onClickAir(this, directionVector)) {
                                    if ((this.isSurvival() || this.isAdventure()) && (item.getId() == 0 || (item.getCount() != oldCount || item.getDamage() != oldDamage) && this.inventory.getItemInHandFast().getId() == item.getId())) {
                                        if (item instanceof ItemFishingRod && item.getDamage() >= item.getMaxDurability()) {
                                            this.level.addSound(this, Sound.RANDOM_BREAK);
                                            this.level.addParticle(new ItemBreakParticle(this, item));
                                            item = Item.get(0);
                                        }
                                        this.inventory.setItemInHand(item);
                                    }
                                    if (this.isUsingItem()) {
                                        int ticksUsed = this.server.getTick() - this.startAction;
                                        this.setUsingItem(false);
                                        if (!item.onUse(this, ticksUsed)) {
                                            this.needSendHeldItem = true;
                                        }
                                    } else {
                                        this.setUsingItem(true);
                                    }
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 3: {
                        UseItemOnEntityData useItemOnEntityData = (UseItemOnEntityData)((InventoryTransactionPacket)transactionPacket).transactionData;
                        Entity target = this.level.getEntity(useItemOnEntityData.entityRuntimeId);
                        if (target == null) {
                            return;
                        }
                        int type = useItemOnEntityData.actionType;
                        if (this.inventory.getHeldItemIndex() != useItemOnEntityData.hotbarSlot) {
                            this.inventory.equipItem(useItemOnEntityData.hotbarSlot);
                        }
                        Item item = this.inventory.getItemInHand();
                        switch (type) {
                            case 0: {
                                if (this.distanceSquared(target) > 1000.0) {
                                    this.getServer().getLogger().debug(this.username + ": target entity is too far away");
                                    return;
                                }
                                this.breakingBlock = null;
                                this.setUsingItem(false);
                                PlayerInteractEntityEvent playerInteractEntityEvent = new PlayerInteractEntityEvent(this, target, item, useItemOnEntityData.clickPos);
                                if (this.isSpectator()) {
                                    playerInteractEntityEvent.setCancelled();
                                }
                                this.getServer().getPluginManager().callEvent(playerInteractEntityEvent);
                                if (playerInteractEntityEvent.isCancelled()) {
                                    return;
                                }
                                if (target.onInteract(this, item, useItemOnEntityData.clickPos) && (this.isSurvival() || this.isAdventure())) {
                                    if (item.isTool()) {
                                        if (item.useOn(target) && item.getDamage() >= item.getMaxDurability()) {
                                            this.level.addSound(this, Sound.RANDOM_BREAK);
                                            this.level.addParticle(new ItemBreakParticle(this, item));
                                            item = Item.get(0);
                                        }
                                    } else if (item.count > 1) {
                                        --item.count;
                                    } else {
                                        item = Item.get(0);
                                    }
                                    if (item.getId() == 0 || this.inventory.getItemInHandFast().getId() == item.getId()) {
                                        this.inventory.setItemInHand(item);
                                    } else if (Nukkit.DEBUG > 1) {
                                        this.server.getLogger().debug("Tried to set item " + item.getId() + " but " + this.username + " had item " + this.inventory.getItemInHandFast().getId() + " in their hand slot");
                                    }
                                }
                                return;
                            }
                            case 1: {
                                if (target.getId() == this.getId()) {
                                    this.kick(PlayerKickEvent.Reason.INVALID_PVP, "Tried to attack invalid player");
                                    return;
                                }
                                if (!this.canInteractEntity(target, this.isCreative() ? 64.0 : 25.0)) {
                                    return;
                                }
                                if (target instanceof Player) {
                                    if ((((Player)target).gamemode & 1) > 0) {
                                        return;
                                    }
                                    if (!this.server.pvpEnabled) {
                                        return;
                                    }
                                }
                                this.breakingBlock = null;
                                this.setUsingItem(false);
                                if (this.sleeping != null) {
                                    this.getServer().getLogger().debug(this.username + ": USE_ITEM_ON_ENTITY_ACTION_ATTACK while sleeping");
                                    return;
                                }
                                if (this.inventoryOpen) {
                                    this.getServer().getLogger().debug(this.username + ": USE_ITEM_ON_ENTITY_ACTION_ATTACK while viewing inventory");
                                    return;
                                }
                                this.setShieldBlockingDelay(5);
                                if (this.server.attackStopSprint) {
                                    this.setSprinting(false);
                                }
                                Enchantment[] enchantments = item.getEnchantments();
                                float itemDamage = item.getAttackDamage();
                                for (Enchantment enchantment : enchantments) {
                                    itemDamage = (float)((double)itemDamage + enchantment.getDamageBonus(target));
                                }
                                EnumMap<EntityDamageEvent.DamageModifier, Float> damage = new EnumMap<EntityDamageEvent.DamageModifier, Float>(EntityDamageEvent.DamageModifier.class);
                                damage.put(EntityDamageEvent.DamageModifier.BASE, Float.valueOf(itemDamage));
                                float knockBack = 0.3f;
                                Enchantment knockBackEnchantment = item.getEnchantment(12);
                                if (knockBackEnchantment != null) {
                                    knockBack += (float)knockBackEnchantment.getLevel() * 0.1f;
                                }
                                EntityDamageByEntityEvent entityDamageByEntityEvent = new EntityDamageByEntityEvent(this, target, EntityDamageEvent.DamageCause.ENTITY_ATTACK, damage, knockBack, enchantments);
                                entityDamageByEntityEvent.setWeapon(item);
                                if (this.isSpectator()) {
                                    entityDamageByEntityEvent.setCancelled();
                                }
                                if (target instanceof Player && !this.level.getGameRules().getBoolean(GameRule.PVP)) {
                                    entityDamageByEntityEvent.setCancelled();
                                }
                                if (!target.attack(entityDamageByEntityEvent)) {
                                    if (item.isTool() && !this.isCreative()) {
                                        this.needSendHeldItem = true;
                                    }
                                    return;
                                }
                                for (Enchantment enchantment : item.getEnchantments()) {
                                    enchantment.doPostAttack(this, target);
                                }
                                if (item.isTool() && !this.isCreative()) {
                                    if (item.useOn(target) && item.getDamage() >= item.getMaxDurability()) {
                                        this.level.addSound(this, Sound.RANDOM_BREAK);
                                        this.level.addParticle(new ItemBreakParticle(this, item));
                                        this.inventory.clear(this.inventory.getHeldItemIndex(), true);
                                    } else if (item.getId() == 0 || this.inventory.getItemInHandFast().getId() == item.getId()) {
                                        this.inventory.setItemInHand(item);
                                    } else if (Nukkit.DEBUG > 1) {
                                        this.server.getLogger().debug("Tried to set item " + item.getId() + " but " + this.username + " had item " + this.inventory.getItemInHandFast().getId() + " in their hand slot");
                                    }
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 4: {
                        if (this.isSpectator()) {
                            this.needSendInventory = true;
                            return;
                        }
                        ReleaseItemData releaseItemData = (ReleaseItemData)((InventoryTransactionPacket)transactionPacket).transactionData;
                        try {
                            int type = releaseItemData.actionType;
                            switch (type) {
                                case 0: {
                                    if (this.isUsingItem()) {
                                        int ticksUsed = this.server.getTick() - this.startAction;
                                        if (!this.inventory.getItemInHand().onRelease(this, ticksUsed)) {
                                            this.needSendHeldItem = true;
                                        }
                                        this.setUsingItem(false);
                                    } else {
                                        this.needSendHeldItem = true;
                                    }
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                            }
                            this.getServer().getLogger().debug(this.username + ": unknown release item action type: " + type);
                        }
                        finally {
                            this.setUsingItem(false);
                        }
                        return;
                    }
                }
                this.needSendHeldItem = true;
                return;
            }
            case 48: {
                if (!this.spawned || !this.isAlive()) {
                    return;
                }
                PlayerHotbarPacket hotbarPacket = (PlayerHotbarPacket)packet;
                if (hotbarPacket.windowId != 0) {
                    return;
                }
                if (this.inventory == null) {
                    return;
                }
                this.inventory.equipItem(hotbarPacket.selectedHotbarSlot);
                this.setUsingItem(false);
                return;
            }
            case 102: {
                PlayerServerSettingsRequestEvent settingsRequestEvent = new PlayerServerSettingsRequestEvent(this, new HashMap<Integer, FormWindow>(this.serverSettings));
                this.getServer().getPluginManager().callEvent(settingsRequestEvent);
                if (!settingsRequestEvent.isCancelled()) {
                    settingsRequestEvent.getSettings().forEach((id, window) -> {
                        ServerSettingsResponsePacket re = new ServerSettingsResponsePacket();
                        re.formId = id;
                        re.data = window.getJSONData();
                        this.dataPacket(re);
                    });
                }
                return;
            }
            case 113: {
                if (this.locallyInitialized) {
                    return;
                }
                this.doFirstSpawn();
                return;
            }
            case 45: {
                if (this.isAlive()) {
                    return;
                }
                RespawnPacket respawnPacket = (RespawnPacket)packet;
                if (respawnPacket.respawnState == 2) {
                    RespawnPacket respawn1 = new RespawnPacket();
                    respawn1.x = (float)this.getX();
                    respawn1.y = (float)this.getY();
                    respawn1.z = (float)this.getZ();
                    respawn1.respawnState = 1;
                    this.dataPacket(respawn1);
                }
                return;
            }
            case 97: {
                boolean success;
                if (!this.spawned) {
                    return;
                }
                if (this.inventory == null) {
                    return;
                }
                BookEditPacket bookEditPacket = (BookEditPacket)packet;
                Item oldBook = this.inventory.getItem(bookEditPacket.inventorySlot);
                if (oldBook.getId() != 386) {
                    this.getServer().getLogger().debug(this.username + ": BookEditPacket for invalid item: expected Book & Quill (386), got " + oldBook.getId());
                    return;
                }
                if (bookEditPacket.text != null && bookEditPacket.text.length() > 256) {
                    this.getServer().getLogger().debug(this.username + ": BookEditPacket with too long text");
                    return;
                }
                Item newBook = oldBook.clone();
                switch (bookEditPacket.action) {
                    case REPLACE_PAGE: {
                        success = ((ItemBookAndQuill)newBook).setPageText(bookEditPacket.pageNumber, bookEditPacket.text);
                        break;
                    }
                    case ADD_PAGE: {
                        success = ((ItemBookAndQuill)newBook).insertPage(bookEditPacket.pageNumber, bookEditPacket.text);
                        break;
                    }
                    case DELETE_PAGE: {
                        success = ((ItemBookAndQuill)newBook).deletePage(bookEditPacket.pageNumber);
                        break;
                    }
                    case SWAP_PAGES: {
                        success = ((ItemBookAndQuill)newBook).swapPages(bookEditPacket.pageNumber, bookEditPacket.secondaryPageNumber);
                        break;
                    }
                    case SIGN_BOOK: {
                        newBook = Item.get(387, (Integer)0, 1, oldBook.getCompoundTag());
                        if (bookEditPacket.title == null || bookEditPacket.author == null || bookEditPacket.xuid == null || bookEditPacket.title.length() > 64 || bookEditPacket.author.length() > 64 || bookEditPacket.xuid.length() > 64) {
                            this.getServer().getLogger().debug(this.username + ": invalid BookEditPacket action SIGN_BOOK: title/author/xuid is too long");
                            return;
                        }
                        success = ((ItemBookWritten)newBook).signBook(bookEditPacket.title, bookEditPacket.author, bookEditPacket.xuid, 0);
                        break;
                    }
                    default: {
                        this.getServer().getLogger().debug(this.username + ": BookEditPacket unknown action: " + (Object)((Object)bookEditPacket.action));
                        return;
                    }
                }
                if (success) {
                    PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent(this, oldBook, newBook, bookEditPacket.action);
                    this.server.getPluginManager().callEvent(editBookEvent);
                    if (!editBookEvent.isCancelled()) {
                        this.inventory.setItem(bookEditPacket.inventorySlot, editBookEvent.getNewBook());
                    }
                }
                return;
            }
            case -100: {
                PacketViolationWarningPacket PVWpk = (PacketViolationWarningPacket)packet;
                if (pkIDs == null) {
                    pkIDs = Arrays.stream(ProtocolInfo.class.getDeclaredFields()).filter(field -> field.getType() == Byte.TYPE);
                }
                Optional<String> PVWpkName = pkIDs.filter(field -> {
                    try {
                        return field.getByte(null) == ((PacketViolationWarningPacket)packet).packetId;
                    }
                    catch (IllegalAccessException e) {
                        return false;
                    }
                }).map(Field::getName).findFirst();
                this.getServer().getLogger().warning("PacketViolationWarningPacket" + PVWpkName.map(name -> " for " + name).orElse(" UNKNOWN") + " from " + this.username + ": " + PVWpk.toString());
                return;
            }
            case -118: {
                if (!this.spawned || this.server.getTick() - this.lastEmote < 20 || this.isSpectator()) {
                    return;
                }
                this.lastEmote = this.server.getTick();
                EmotePacket emotePacket = (EmotePacket)packet;
                if (emotePacket.runtimeId != this.id) {
                    this.getServer().getLogger().debug(this.username + ": EmotePacket eid mismatch");
                    return;
                }
                if (emotePacket.emoteID == null || emotePacket.emoteID.isEmpty() || emotePacket.emoteID.length() > 100) {
                    this.getServer().getLogger().debug(this.username + " EmotePacket invalid emote id: " + emotePacket.emoteID);
                    return;
                }
                EmotePacket cleanEmotePacket = new EmotePacket();
                cleanEmotePacket.runtimeId = emotePacket.runtimeId;
                cleanEmotePacket.emoteID = emotePacket.emoteID;
                Server.broadcastPacket(this.getViewers().values(), (DataPacket)cleanEmotePacket);
                return;
            }
            case 125: {
                BlockEntityLectern lectern;
                BlockEntity blockEntityLectern;
                if (!this.spawned) {
                    return;
                }
                LecternUpdatePacket lecternUpdatePacket = (LecternUpdatePacket)packet;
                Vector3 lecternPos = lecternUpdatePacket.blockPosition.asVector3();
                if (lecternPos.distanceSquared(this) > 4096.0) {
                    return;
                }
                if (!lecternUpdatePacket.dropBook && (blockEntityLectern = this.level.getBlockEntityIfLoaded(this.chunk, lecternPos)) instanceof BlockEntityLectern && (lectern = (BlockEntityLectern)blockEntityLectern).getRawPage() != lecternUpdatePacket.page) {
                    lectern.setRawPage(lecternUpdatePacket.page);
                }
                return;
            }
            case 60: {
                if (!this.spawned) {
                    return;
                }
                if (!this.hasPermission("nukkit.command.difficulty")) {
                    if (!this.isOp()) {
                        this.kick(PlayerKickEvent.Reason.INVALID_PACKET, "Invalid SetDifficultyPacket", true);
                    }
                    return;
                }
                this.server.setDifficulty(((SetDifficultyPacket)packet).difficulty);
                Command.broadcastCommandMessage((CommandSender)this, new TranslationContainer("commands.difficulty.success", String.valueOf(this.server.getDifficulty())));
                SetDifficultyPacket difficultyPacket = new SetDifficultyPacket();
                difficultyPacket.difficulty = this.server.getDifficulty();
                Server.broadcastPacket(this.server.getOnlinePlayers().values(), (DataPacket)difficultyPacket);
                return;
            }
            case -71: {
                if (!this.spawned) {
                    return;
                }
                if (!this.isOp()) {
                    this.kick(PlayerKickEvent.Reason.INVALID_PACKET, "Invalid RequestPermissionsPacket", true);
                    return;
                }
                this.sendMessage((Object)((Object)TextFormat.RED) + "Unimplemented feature: REQUEST_PERMISSIONS_PACKET");
                return;
            }
            case 105: {
                int gamemode;
                if (!this.spawned) {
                    return;
                }
                if (!this.hasPermission("nukkit.command.defaultgamemode")) {
                    if (!this.isOp()) {
                        this.kick(PlayerKickEvent.Reason.INVALID_PACKET, "Invalid SetDefaultGameTypePacket", true);
                    }
                    return;
                }
                this.server.gamemode = gamemode = ((SetDefaultGameTypePacket)packet).gamemode & 3;
                this.server.setPropertyInt("gamemode", gamemode);
                Command.broadcastCommandMessage((CommandSender)this, new TranslationContainer("commands.defaultgamemode.success", new String[]{Server.getGamemodeString(this.server.getDefaultGamemode())}));
                SetDefaultGameTypePacket gameTypePacket = new SetDefaultGameTypePacket();
                gameTypePacket.gamemode = this.server.getDefaultGamemode();
                Server.broadcastPacket(this.server.getOnlinePlayers().values(), (DataPacket)gameTypePacket);
                return;
            }
            case -116: {
                if (!this.spawned) {
                    return;
                }
                if (!this.hasPermission("nukkit.command.gamerule")) {
                    if (!this.isOp()) {
                        this.kick(PlayerKickEvent.Reason.INVALID_PACKET, "Invalid SettingsCommandPacket", true);
                    }
                    return;
                }
                String command = ((SettingsCommandPacket)packet).command;
                if (command.startsWith("/gamerule")) {
                    this.server.dispatchCommand(this, command.substring(1));
                } else {
                    this.getServer().getLogger().debug(this.username + ": SettingsCommandPacket unsupported command: " + command);
                }
                return;
            }
        }
    }

    private void setShieldBlockingDelay(int delay) {
        if (this.isBlocking()) {
            this.setBlocking(false);
            this.blockingDelay = delay;
        }
    }

    @Override
    protected void onBlock(Entity damager, EntityDamageBlockedEvent event, EntityDamageEvent source) {
        super.onBlock(damager, event, source);
        if (source.getWeapon() != null && source.getWeapon().isAxe()) {
            this.setShieldBlockingDelay(100);
            this.startItemCooldown(100, "shield");
        }
    }

    public void startItemCooldown(int cooldownDuration, String itemCategory) {
        PlayerStartItemCooldownPacket pk = new PlayerStartItemCooldownPacket();
        pk.itemCategory = itemCategory;
        pk.cooldownDuration = cooldownDuration;
        this.dataPacket(pk);
    }

    private void onBlockBreakAbort(BlockVector3 blockPos, BlockFace face) {
        if (this.isBreakingBlock()) {
            LevelEventPacket pk = new LevelEventPacket();
            pk.evid = 3601;
            pk.x = (float)this.breakingBlock.x;
            pk.y = (float)this.breakingBlock.y;
            pk.z = (float)this.breakingBlock.z;
            pk.data = 0;
            this.getLevel().addChunkPacket((int)this.breakingBlock.x >> 4, (int)this.breakingBlock.z >> 4, pk);
        }
        this.breakingBlock = null;
    }

    private void onBlockBreakStart(BlockVector3 blockPos, BlockFace face) {
        double breakTime;
        int breakTimeTicks;
        if (this.isSpectator()) {
            return;
        }
        boolean posEquals = this.lastBreakPosition.equals(blockPos);
        this.lastBreakPosition = blockPos;
        long currentBreak = System.currentTimeMillis();
        if (posEquals && currentBreak - this.lastBreak < 10L) {
            return;
        }
        if (blockPos.distanceSquared(this) > 100.0) {
            this.breakingBlock = null;
            return;
        }
        this.breakingBlock = null;
        this.setUsingItem(false);
        Item handItem = this.inventory.getItemInHand();
        Block target = this.level.getBlock(this.chunk, blockPos.x, blockPos.y, blockPos.z, false);
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(this, handItem, target, face, target.getId() == 0 ? PlayerInteractEvent.Action.LEFT_CLICK_AIR : PlayerInteractEvent.Action.LEFT_CLICK_BLOCK);
        this.getServer().getPluginManager().callEvent(playerInteractEvent);
        if (playerInteractEvent.isCancelled()) {
            this.needSendHeldItem = true;
            return;
        }
        switch (target.getId()) {
            case 0: {
                return;
            }
            case 25: {
                ((BlockNoteblock)target).emitSound();
                break;
            }
            case 122: {
                if (this.isCreative()) break;
                ((BlockDragonEgg)target).teleport();
                return;
            }
            case 199: 
            case 594: {
                BlockEntity itemFrame = this.level.getBlockEntityIfLoaded(this.chunk, this.temporalVector.setComponents(blockPos.x, blockPos.y, blockPos.z));
                if (!(itemFrame instanceof BlockEntityItemFrame) || !((BlockEntityItemFrame)itemFrame).dropItem(this)) break;
                return;
            }
            case 449: {
                BlockEntity lectern = this.level.getBlockEntityIfLoaded(this.chunk, this.temporalVector.setComponents(blockPos.x, blockPos.y, blockPos.z));
                if (!(lectern instanceof BlockEntityLectern) || !((BlockEntityLectern)lectern).dropBook(this)) break;
                return;
            }
        }
        int bid = this.level.getBlockIdAt(this.chunk, blockPos.x + face.getXOffset(), blockPos.y + face.getYOffset(), blockPos.z + face.getZOffset());
        if (bid == 51 || bid == 492) {
            Vector3 block = this.temporalVector.setComponents(blockPos.x + face.getXOffset(), blockPos.y + face.getYOffset(), blockPos.z + face.getZOffset());
            this.level.setBlock(block, Block.get(0), true);
            this.level.addLevelSoundEvent(block, 65);
            return;
        }
        if (!this.isCreative() && (breakTimeTicks = (int)((breakTime = target.getBreakTime(handItem, this)) * 20.0 + 0.5)) > 0) {
            LevelEventPacket pk = new LevelEventPacket();
            pk.evid = 3600;
            pk.x = blockPos.x;
            pk.y = blockPos.y;
            pk.z = blockPos.z;
            pk.data = 65535 / breakTimeTicks;
            this.getLevel().addChunkPacket(blockPos.x >> 4, blockPos.z >> 4, pk);
        }
        this.breakingBlock = target;
        this.breakingBlockFace = face;
        this.lastBreak = currentBreak;
    }

    private void onBlockBreakComplete(BlockVector3 blockPos, BlockFace face) {
        if (!this.spawned || !this.isAlive()) {
            return;
        }
        this.resetCraftingGridType();
        Item i = this.getInventory().getItemInHand();
        Item oldItem = i.clone();
        if (this.canInteract(blockPos.add(0.5, 0.5, 0.5), this.isCreative() ? 14.0 : 8.0) && (i = this.level.useBreakOn(blockPos.asVector3(), face, i, this, true)) != null) {
            if (this.isSurvival() || this.isAdventure()) {
                this.foodData.updateFoodExpLevel(0.005);
                if (i.getCount() != oldItem.getCount() || i.getDamage() != oldItem.getDamage() || !i.equals(oldItem)) {
                    if (i.getId() == 0 || oldItem.getId() == i.getId()) {
                        this.inventory.setItemInHand(i);
                        this.inventory.sendHeldItem(this.getViewers().values());
                    } else if (Nukkit.DEBUG > 1) {
                        this.server.getLogger().debug("Tried to set item " + i.getId() + " but " + this.username + " had item " + oldItem.getId() + " in their hand slot");
                    }
                }
            }
            return;
        }
        this.needSendHeldItem = true;
        if (blockPos.distanceSquared(this) < 10000.0) {
            this.level.sendBlocks(this, (Vector3[])new Block[]{this.level.getBlock(blockPos.asVector3(), false)}, 11);
            BlockEntity blockEntity = this.level.getBlockEntityIfLoaded(this.chunk, blockPos.asVector3());
            if (blockEntity instanceof BlockEntitySpawnable) {
                ((BlockEntitySpawnable)blockEntity).spawnTo(this);
            }
        }
    }

    private static Color colorizeMapColor(BlockColor color, int colorLevel) {
        int colorDepth;
        if (colorLevel == 2) {
            colorDepth = 255;
        } else if (colorLevel == 1) {
            colorDepth = 220;
        } else if (colorLevel == 0) {
            colorDepth = 180;
        } else {
            throw new IllegalArgumentException("Invalid colorLevel: " + colorLevel);
        }
        int r = color.getRed() * colorDepth / 255;
        int g2 = color.getGreen() * colorDepth / 255;
        int b = color.getBlue() * colorDepth / 255;
        return new Color(r, g2, b);
    }

    public boolean chat(String message) {
        this.resetCraftingGridType();
        if (this.removeFormat) {
            message = TextFormat.clean(message, true);
        }
        for (String msg : message.split("\n")) {
            if (msg.trim().isEmpty() || msg.length() >= 512) continue;
            PlayerChatEvent chatEvent = new PlayerChatEvent(this, msg);
            this.server.getPluginManager().callEvent(chatEvent);
            if (chatEvent.isCancelled()) continue;
            this.server.broadcastMessage(this.getServer().getLanguage().translateString(chatEvent.getFormat(), new String[]{chatEvent.getPlayer().displayName, chatEvent.getMessage()}), chatEvent.getRecipients());
        }
        return true;
    }

    public boolean kick() {
        return this.kick("");
    }

    public boolean kick(String reason, boolean isAdmin) {
        return this.kick(PlayerKickEvent.Reason.UNKNOWN, reason, isAdmin);
    }

    public boolean kick(String reason) {
        return this.kick(PlayerKickEvent.Reason.UNKNOWN, reason);
    }

    public boolean kick(PlayerKickEvent.Reason reason) {
        return this.kick(reason, true);
    }

    public boolean kick(PlayerKickEvent.Reason reason, String reasonString) {
        return this.kick(reason, reasonString, true);
    }

    public boolean kick(PlayerKickEvent.Reason reason, boolean isAdmin) {
        return this.kick(reason, reason.toString(), isAdmin);
    }

    public boolean kick(PlayerKickEvent.Reason reason, String reasonString, boolean isAdmin) {
        PlayerKickEvent ev = new PlayerKickEvent(this, reason, reasonString, this.getLeaveMessage());
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            String message = isAdmin ? (!this.isBanned() ? "Kicked!" + (!reasonString.isEmpty() ? " Reason: " + reasonString : "") : reasonString) : (reasonString.isEmpty() ? "disconnectionScreen.noReason" : reasonString);
            this.close(ev.getQuitMessage(), message);
            return true;
        }
        return false;
    }

    public void setViewDistance(int distance) {
        this.viewDistance = distance;
        this.chunkRadius = distance;
        ChunkRadiusUpdatedPacket pk = new ChunkRadiusUpdatedPacket();
        pk.radius = distance;
        this.dataPacket(pk);
    }

    public int getViewDistance() {
        return this.chunkRadius;
    }

    public int getMaximumViewDistance() {
        return this.viewDistance;
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(message, false);
    }

    public void sendMessage(String message, boolean isLocalized) {
        TextPacket pk = new TextPacket();
        pk.type = 0;
        pk.message = this.server.getLanguage().translateString(message);
        pk.isLocalized = isLocalized;
        this.dataPacket(pk);
    }

    @Override
    public void sendMessage(TextContainer message) {
        if (message instanceof TranslationContainer) {
            this.sendTranslation(message.getText(), ((TranslationContainer)message).getParameters());
            return;
        }
        this.sendMessage(message.getText(), false);
    }

    public void sendTranslation(String message) {
        this.sendTranslation(message, new String[0]);
    }

    public void sendTranslation(String message, String[] parameters) {
        TextPacket pk = new TextPacket();
        if (this.server.isLanguageForced()) {
            pk.type = 0;
            pk.message = this.server.getLanguage().translateString(message, parameters);
        } else {
            pk.type = (byte)2;
            pk.message = this.server.getLanguage().translateString(message, parameters, "nukkit.");
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.server.getLanguage().translateString(parameters[i], parameters, "nukkit.");
            }
            pk.parameters = parameters;
        }
        this.dataPacket(pk);
    }

    public void sendChat(String message) {
        this.sendChat("", message);
    }

    public void sendChat(String source, String message) {
        TextPacket pk = new TextPacket();
        pk.type = 1;
        pk.source = source;
        pk.message = this.server.getLanguage().translateString(message);
        this.dataPacket(pk);
    }

    public void sendPopup(String message) {
        TextPacket pk = new TextPacket();
        pk.type = (byte)3;
        pk.message = message;
        this.dataPacket(pk);
    }

    public void sendPopup(String message, String subtitle) {
        this.sendPopup(message);
    }

    public void sendTip(String message) {
        TextPacket pk = new TextPacket();
        pk.type = (byte)5;
        pk.message = message;
        this.dataPacket(pk);
    }

    public void clearTitle() {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 0;
        this.dataPacket(pk);
    }

    public void resetTitleSettings() {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 1;
        this.dataPacket(pk);
    }

    public void setSubtitle(String subtitle) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 3;
        pk.text = subtitle;
        this.dataPacket(pk);
    }

    public void setTitleAnimationTimes(int fadein, int duration, int fadeout) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 5;
        pk.fadeInTime = fadein;
        pk.stayTime = duration;
        pk.fadeOutTime = fadeout;
        this.dataPacket(pk);
    }

    private void setTitle(String text) {
        SetTitlePacket packet = new SetTitlePacket();
        packet.text = text;
        packet.type = 2;
        this.dataPacket(packet);
    }

    public void sendTitle(String title) {
        this.sendTitle(title, null, 20, 20, 5);
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 20, 20, 5);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.setTitleAnimationTimes(fadeIn, stay, fadeOut);
        if (!Strings.isNullOrEmpty(subtitle)) {
            this.setSubtitle(subtitle);
        }
        this.setTitle(Strings.isNullOrEmpty(title) ? " " : title);
    }

    public void sendActionBar(String title) {
        this.sendActionBar(title, 1, 0, 1);
    }

    public void sendActionBar(String title, int fadein, int duration, int fadeout) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 4;
        pk.text = title;
        pk.fadeInTime = fadein;
        pk.stayTime = duration;
        pk.fadeOutTime = fadeout;
        this.dataPacket(pk);
    }

    public void sendToast(String title, String content) {
        ToastRequestPacket pk = new ToastRequestPacket();
        pk.title = title;
        pk.content = content;
        this.dataPacket(pk);
    }

    @Override
    public void close() {
        this.close("");
    }

    public void close(String message) {
        this.close(message, "generic");
    }

    public void close(String message, String reason) {
        this.close(message, reason, true);
    }

    public void close(String message, String reason, boolean notify) {
        this.close(new TextContainer(message), reason, notify);
    }

    public void close(TextContainer message) {
        this.close(message, "generic");
    }

    public void close(TextContainer message, String reason) {
        this.close(message, reason, true);
    }

    public void close(TextContainer message, String reason, boolean notify) {
        if (this.connected && !this.closed) {
            if (notify && !reason.isEmpty()) {
                DisconnectPacket pk = new DisconnectPacket();
                pk.message = reason;
                this.forceDataPacket(pk, null);
            }
            this.connected = false;
            this.resetCraftingGridType();
            this.removeAllWindows(true);
            if (this.fishing != null) {
                this.stopFishing(false);
            }
            PlayerQuitEvent ev = null;
            if (this.username != null && !this.username.isEmpty()) {
                ev = new PlayerQuitEvent(this, message, true, reason);
                this.server.getPluginManager().callEvent(ev);
                if (this.loggedIn && ev.getAutoSave()) {
                    this.save();
                }
            }
            for (Player player : this.server.getOnlinePlayers().values()) {
                if (player.canSee(this)) continue;
                player.showPlayer(this);
            }
            this.hiddenPlayers.clear();
            this.unloadChunks(false);
            super.close();
            this.interfaz.close(this, notify ? reason : "");
            this.server.removeOnlinePlayer(this);
            if (this.loggedIn) {
                this.loggedIn = false;
            }
            if (ev != null && !Objects.equals(this.username, "") && this.spawned && !Objects.equals(ev.getQuitMessage().toString(), "")) {
                this.server.broadcastMessage(ev.getQuitMessage());
            }
            this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.user", this);
            this.spawned = false;
            this.server.getLogger().info(this.getServer().getLanguage().translateString("nukkit.player.logOut", (Object)((Object)TextFormat.AQUA) + (this.username == null ? this.unverifiedUsername : this.username) + (Object)((Object)TextFormat.WHITE), this.getAddress(), String.valueOf(this.getPort()), this.getServer().getLanguage().translateString(reason)));
            this.windows.clear();
            this.hasSpawned.clear();
            if (this.riding instanceof EntityRideable) {
                this.riding.passengers.remove(this);
            }
            this.riding = null;
        }
        if (this.perm != null) {
            this.perm.clearPermissions();
            this.perm = null;
        }
        this.inventory = null;
        this.chunk = null;
        this.server.removePlayer(this);
        if (this.loggedIn) {
            this.server.getLogger().warning("Player is still logged in: " + (this.username == null ? this.unverifiedUsername : this.username));
            this.interfaz.close(this, notify ? reason : "");
            this.server.removeOnlinePlayer(this);
            this.loggedIn = false;
        }
        this.clientMovements.clear();
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean async) {
        if (this.closed) {
            throw new IllegalStateException("Tried to save closed player");
        }
        if (!this.server.shouldSavePlayerData) {
            return;
        }
        super.saveNBT();
        if (this.level != null) {
            this.namedTag.putString("Level", this.level.getFolderName());
            if (this.spawnPosition != null && this.spawnPosition.getLevel() != null) {
                this.namedTag.putString("SpawnLevel", this.spawnPosition.getLevel().getFolderName());
                this.namedTag.putInt("SpawnX", this.spawnPosition.getFloorX());
                this.namedTag.putInt("SpawnY", this.spawnPosition.getFloorY());
                this.namedTag.putInt("SpawnZ", this.spawnPosition.getFloorZ());
            }
            CompoundTag achievements = new CompoundTag();
            for (String achievement : this.achievements) {
                achievements.putByte(achievement, 1);
            }
            this.namedTag.putCompound("Achievements", achievements);
            this.namedTag.putInt("playerGameType", this.gamemode);
            this.namedTag.putLong("lastPlayed", System.currentTimeMillis() / 1000L);
            this.namedTag.putString("lastIP", this.getAddress());
            this.namedTag.putInt("EXP", this.exp);
            this.namedTag.putInt("expLevel", this.expLevel);
            this.namedTag.putInt("foodLevel", this.foodData.getLevel());
            this.namedTag.putFloat("foodSaturationLevel", this.foodData.getFoodSaturationLevel());
            this.namedTag.putInt("TimeSinceRest", this.timeSinceRest);
            if (!this.username.isEmpty() && this.namedTag != null) {
                this.server.saveOfflinePlayerData(this.uuid, this.namedTag, async);
            }
        }
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public void kill() {
        if (!this.spawned) {
            return;
        }
        boolean showMessages = this.level.getGameRules().getBoolean(GameRule.SHOW_DEATH_MESSAGES);
        String message = "";
        ArrayList<String> params = new ArrayList<String>();
        EntityDamageEvent cause = this.getLastDamageCause();
        if (showMessages) {
            params.add(this.displayName);
            switch (cause == null ? EntityDamageEvent.DamageCause.CUSTOM : cause.getCause()) {
                case ENTITY_ATTACK: 
                case THORNS: {
                    if (cause instanceof EntityDamageByEntityEvent) {
                        Entity e;
                        this.killer = e = ((EntityDamageByEntityEvent)cause).getDamager();
                        if (e instanceof Player) {
                            message = "death.attack.player";
                            params.add(((Player)e).displayName);
                            break;
                        }
                        if (e instanceof EntityLiving) {
                            message = "death.attack.mob";
                            params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                            break;
                        }
                        message = "death.attack.generic";
                        break;
                    }
                    message = "death.attack.generic";
                    break;
                }
                case PROJECTILE: {
                    if (cause instanceof EntityDamageByEntityEvent) {
                        Entity e;
                        this.killer = e = ((EntityDamageByEntityEvent)cause).getDamager();
                        if (e instanceof Player) {
                            message = "death.attack.arrow";
                            params.add(((Player)e).displayName);
                            break;
                        }
                        if (e instanceof EntityLiving) {
                            message = "death.attack.arrow";
                            params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                            break;
                        }
                        message = "death.attack.generic";
                        break;
                    }
                    message = "death.attack.generic";
                    break;
                }
                case VOID: {
                    message = "death.attack.outOfWorld";
                    break;
                }
                case FALL: {
                    if (cause.getFinalDamage() > 2.0f) {
                        message = "death.fell.accident.generic";
                        break;
                    }
                    message = "death.attack.fall";
                    break;
                }
                case SUFFOCATION: {
                    message = "death.attack.inWall";
                    break;
                }
                case LAVA: {
                    message = "death.attack.lava";
                    break;
                }
                case MAGMA: {
                    message = "death.attack.magma";
                    break;
                }
                case FIRE: {
                    message = "death.attack.onFire";
                    break;
                }
                case FIRE_TICK: {
                    message = "death.attack.inFire";
                    break;
                }
                case DROWNING: {
                    message = "death.attack.drown";
                    break;
                }
                case CONTACT: {
                    if (cause instanceof EntityDamageByBlockEvent) {
                        int id = ((EntityDamageByBlockEvent)cause).getDamager().getId();
                        if (id == 81) {
                            message = "death.attack.cactus";
                            break;
                        }
                        if (id == 145) {
                            message = "death.attack.anvil";
                            break;
                        }
                        if (id == 462) {
                            message = "death.attack.sweetBerry";
                            break;
                        }
                        message = "death.attack.generic";
                        break;
                    }
                    message = "death.attack.generic";
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    if (cause instanceof EntityDamageByEntityEvent) {
                        Entity e;
                        this.killer = e = ((EntityDamageByEntityEvent)cause).getDamager();
                        if (e instanceof Player) {
                            message = "death.attack.explosion.player";
                            params.add(((Player)e).displayName);
                            break;
                        }
                        if (e instanceof EntityLiving) {
                            message = "death.attack.explosion.player";
                            params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                            break;
                        }
                        if (e instanceof EntityFirework && cause.getEntity() instanceof Player) {
                            params.add(((Player)cause.getEntity()).displayName);
                            message = "death.attack.fireworks";
                            break;
                        }
                        message = "death.attack.explosion";
                        break;
                    }
                    message = "death.attack.explosion";
                    break;
                }
                case MAGIC: {
                    message = "death.attack.magic";
                    break;
                }
                case LIGHTNING: {
                    message = "death.attack.lightningBolt";
                    break;
                }
                case HUNGER: {
                    message = "death.attack.starve";
                    break;
                }
                default: {
                    message = "death.attack.generic";
                }
            }
        }
        this.resetCraftingGridType();
        PlayerDeathEvent ev = new PlayerDeathEvent(this, this.getDrops(), new TranslationContainer(message, params.toArray(new String[0])), this.expLevel);
        ev.setKeepInventory(this.level.gameRules.getBoolean(GameRule.KEEP_INVENTORY));
        ev.setKeepExperience(ev.getKeepInventory());
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            if (this.fishing != null) {
                this.stopFishing(false);
            }
            this.health = 0.0f;
            this.scheduleUpdate();
            if (!ev.getKeepInventory() && this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                for (Item item : ev.getDrops()) {
                    if (item.hasEnchantment(28)) continue;
                    this.level.dropItem(this, item, null, true, 40);
                }
                if (this.inventory != null) {
                    this.inventory.clearAll();
                }
            }
            if (!ev.getKeepExperience() && this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                if (this.isSurvival() || this.isAdventure()) {
                    int exp = ev.getExperience() * 7;
                    if (exp > 100) {
                        exp = 100;
                    }
                    this.getLevel().dropExpOrb(this, exp);
                }
                this.setExperience(0, 0);
            }
            if (this.level.getGameRules().getBoolean(GameRule.DO_IMMEDIATE_RESPAWN)) {
                this.respawn();
            } else {
                DataPacket pk;
                if (showMessages && !ev.getDeathMessage().toString().isEmpty()) {
                    this.server.broadcast(ev.getDeathMessage(), "nukkit.broadcast.user");
                    pk = new DeathInfoPacket();
                    ((DeathInfoPacket)pk).messageTranslationKey = ev.getDeathMessage() instanceof TranslationContainer ? this.server.getLanguage().translateString(ev.getDeathMessage().getText(), ((TranslationContainer)ev.getDeathMessage()).getParameters(), (String)null) : ev.getDeathMessage().getText();
                    this.dataPacket(pk);
                }
                pk = new RespawnPacket();
                Position pos = this.getSpawn();
                pk.x = (float)pos.x;
                pk.y = (float)pos.y;
                pk.z = (float)pos.z;
                pk.respawnState = 0;
                this.dataPacket(pk);
            }
        }
    }

    protected void respawn() {
        if (this.server.isHardcore()) {
            this.setBanned(true);
            return;
        }
        this.resetCraftingGridType();
        PlayerRespawnEvent playerRespawnEvent = new PlayerRespawnEvent(this, this.getSpawn());
        this.server.getPluginManager().callEvent(playerRespawnEvent);
        Position respawnPos = playerRespawnEvent.getRespawnPosition();
        this.teleport(respawnPos, null);
        this.sendBothExperience(this.exp, this.expLevel);
        this.setSprinting(false, false);
        this.setSneaking(false);
        this.setSwimming(false);
        this.setGliding(false);
        this.setCrawling(false);
        this.extinguish();
        this.setDataProperty(new ShortEntityData(7, 400), false);
        this.airTicks = 400;
        this.deadTicks = 0;
        this.noDamageTicks = 60;
        this.timeSinceRest = 0;
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.setHealth(this.getMaxHealth());
        this.foodData.setLevel(20, 20.0f);
        this.sendData(this);
        this.setMovementSpeed(0.1f);
        this.adventureSettings.update();
        this.inventory.sendContents(this);
        this.inventory.sendArmorContents(this);
        this.offhandInventory.sendContents(this);
        this.spawnToAll();
        this.scheduleUpdate();
        if (this.spawnPosition instanceof BlockRespawnAnchor && this.spawnPosition.level.getProvider() != null) {
            Block anchor = this.spawnPosition.level.getBlock(this.spawnPosition);
            if (anchor instanceof BlockRespawnAnchor) {
                int chargeLevel = anchor.getDamage();
                if (chargeLevel > 0) {
                    anchor.setDamage(chargeLevel - 1);
                    anchor.level.setBlock(anchor, anchor);
                    anchor.level.addLevelSoundEvent(anchor, 309);
                }
                if (chargeLevel <= 1) {
                    this.setSpawn(this.server.getDefaultLevel().getSafeSpawn());
                }
            } else {
                this.setSpawn(this.server.getDefaultLevel().getSafeSpawn());
            }
        }
    }

    @Override
    public void setHealth(float health) {
        if (health < 1.0f) {
            health = 0.0f;
        }
        super.setHealth(health);
        if (this.spawned) {
            UpdateAttributesPacket pk = new UpdateAttributesPacket();
            int max = this.getMaxHealth();
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = Attribute.getAttribute(4).setMaxValue(max).setValue(this.health > 0.0f ? (this.health < (float)max ? this.health : (float)max) : 0.0f);
            pk.entries = attributeArray;
            pk.entityId = this.id;
            this.dataPacket(pk);
        }
    }

    @Override
    public void setMaxHealth(int maxHealth) {
        super.setMaxHealth(maxHealth);
        if (this.spawned) {
            UpdateAttributesPacket pk = new UpdateAttributesPacket();
            int max = this.getMaxHealth();
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = Attribute.getAttribute(4).setMaxValue(max).setValue(this.health > 0.0f ? (this.health < (float)max ? this.health : (float)max) : 0.0f);
            pk.entries = attributeArray;
            pk.entityId = this.id;
            this.dataPacket(pk);
        }
    }

    public int getExperience() {
        return this.exp;
    }

    public int getExperienceLevel() {
        return this.expLevel;
    }

    public void addExperience(int add) {
        int added;
        if (add == 0) {
            return;
        }
        int level = this.expLevel;
        int most = Player.calculateRequireExperience(level);
        for (added = this.exp + add; added >= most; added -= most) {
            most = Player.calculateRequireExperience(++level);
        }
        this.setExperience(added, level);
    }

    public static int calculateRequireExperience(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + (level << 1);
    }

    public void setExperience(int exp) {
        this.setExperience(exp, this.expLevel);
    }

    public void setExperience(int exp, int level) {
        PlayerExperienceChangeEvent ev = new PlayerExperienceChangeEvent(this, this.exp, this.expLevel, exp, level);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.exp = ev.getNewExperience();
        this.expLevel = ev.getNewExperienceLevel();
        this.sendBothExperience(this.exp, this.expLevel);
    }

    public void sendExperience() {
        this.sendExperience(this.exp);
    }

    public void sendExperience(int exp) {
        if (this.spawned) {
            this.setAttribute(Attribute.getAttribute(10).setValue(Math.max(0.0f, Math.min(1.0f, (float)exp / (float)Player.calculateRequireExperience(this.expLevel)))));
        }
    }

    public void sendExperienceLevel() {
        this.sendExperienceLevel(this.expLevel);
    }

    public void sendExperienceLevel(int level) {
        if (this.spawned) {
            this.setAttribute(Attribute.getAttribute(9).setValue(level));
        }
    }

    private void sendBothExperience(int exp, int level) {
        if (this.spawned) {
            UpdateAttributesPacket pk = new UpdateAttributesPacket();
            pk.entries = new Attribute[]{Attribute.getAttribute(9).setValue(level), Attribute.getAttribute(10).setValue(Math.max(0.0f, Math.min(1.0f, (float)exp / (float)Player.calculateRequireExperience(this.expLevel))))};
            pk.entityId = this.id;
            this.dataPacket(pk);
        }
    }

    public void setAttribute(Attribute attribute) {
        UpdateAttributesPacket pk = new UpdateAttributesPacket();
        pk.entries = new Attribute[]{attribute};
        pk.entityId = this.id;
        this.dataPacket(pk);
    }

    @Override
    public void setMovementSpeed(float speed) {
        this.setMovementSpeed(speed, true);
    }

    public void setMovementSpeed(float speed, boolean send) {
        if (speed < 0.0f) {
            this.server.getLogger().debug("Invalid setMovementSpeed: " + speed);
            return;
        }
        super.setMovementSpeed(speed);
        if (this.spawned && send) {
            this.setAttribute(Attribute.getAttribute(5).setValue(speed).setDefaultValue(speed));
        }
    }

    public void sendMovementSpeed(float speed) {
        Attribute attribute = Attribute.getAttribute(5).setValue(speed);
        this.setAttribute(attribute);
    }

    public Entity getKiller() {
        return this.killer;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (!this.spawned || this.closed || !this.isAlive()) {
            return false;
        }
        if (this.isSpectator() || this.isCreative() && source.getCause() != EntityDamageEvent.DamageCause.SUICIDE) {
            source.setCancelled();
            return false;
        }
        if (source.getCause() == EntityDamageEvent.DamageCause.FALL && this.getAllowFlight()) {
            source.setCancelled();
            return false;
        }
        if (super.attack(source)) {
            if (this.getLastDamageCause() == source && this.spawned) {
                Entity damager;
                if (source instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)source).getDamager()) instanceof Player) {
                    ((Player)damager).foodData.updateFoodExpLevel(0.1);
                }
                EntityEventPacket pk = new EntityEventPacket();
                pk.eid = this.id;
                pk.event = 2;
                this.dataPacket(pk);
            }
            return true;
        }
        return false;
    }

    public boolean dropItem(Item item) {
        if (!this.spawned || !this.isAlive()) {
            return false;
        }
        if (item.isNull()) {
            this.server.getLogger().debug(this.username + " attempted to drop a null item (" + item + ')');
            return true;
        }
        this.setUsingItem(false);
        Vector3 motion = this.getDirectionVector().multiply(0.4);
        EntityItem entityItem = this.level.dropAndGetItem(this.add(0.0, 1.3, 0.0), item, motion, 40);
        if (entityItem != null) {
            entityItem.droppedBy = this;
        }
        return true;
    }

    public EntityItem dropAndGetItem(Item item) {
        if (!this.spawned || !this.isAlive()) {
            return null;
        }
        if (item.isNull()) {
            this.server.getLogger().debug(this.getName() + " attempted to drop a null item (" + item + ')');
            return null;
        }
        this.setUsingItem(false);
        Vector3 motion = this.getDirectionVector().multiply(0.4);
        EntityItem entityItem = this.level.dropAndGetItem(this.add(0.0, 1.3, 0.0), item, motion, 40);
        if (entityItem != null) {
            entityItem.droppedBy = this;
        }
        return entityItem;
    }

    public void sendPosition(Vector3 pos) {
        this.sendPosition(pos, this.yaw);
    }

    public void sendPosition(Vector3 pos, double yaw) {
        this.sendPosition(pos, yaw, this.pitch);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch) {
        this.sendPosition(pos, yaw, pitch, 0);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch, int mode) {
        this.sendPosition(pos, yaw, pitch, mode, null);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch, int mode, Player[] targets) {
        MovePlayerPacket pk = new MovePlayerPacket();
        pk.eid = this.getId();
        pk.x = (float)pos.x;
        pk.y = (float)(pos.y + (double)this.getBaseOffset());
        pk.z = (float)pos.z;
        pk.headYaw = (float)yaw;
        pk.pitch = (float)pitch;
        pk.yaw = (float)yaw;
        pk.mode = mode;
        pk.onGround = this.onGround;
        if (this.riding != null) {
            pk.ridingEid = this.riding.getId();
            pk.mode = 3;
        }
        this.ySize = 0.0f;
        if (targets != null) {
            Server.broadcastPacket(targets, (DataPacket)pk);
        } else {
            this.clientMovements.clear();
            this.dataPacket(pk);
        }
    }

    private void sendPositionToViewers(double x, double y, double z, double yaw, double pitch, double headYaw) {
        MovePlayerPacket pk = new MovePlayerPacket();
        pk.eid = this.getId();
        pk.x = (float)x;
        pk.y = (float)(y + (double)this.getBaseOffset());
        pk.z = (float)z;
        pk.headYaw = (float)headYaw;
        pk.pitch = (float)pitch;
        pk.yaw = (float)yaw;
        pk.mode = 0;
        pk.onGround = this.onGround;
        if (this.riding != null) {
            pk.ridingEid = this.riding.getId();
            pk.mode = 3;
        }
        this.ySize = 0.0f;
        Server.broadcastPacket(this.getViewers().values(), (DataPacket)pk);
    }

    @Override
    protected void checkChunks() {
        if (this.chunk == null || this.chunk.getX() != this.getChunkX() || this.chunk.getZ() != this.getChunkZ()) {
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            this.chunk = this.level.getChunk(this.getChunkX(), this.getChunkZ(), true);
            if (!this.justCreated) {
                Map<Integer, Player> newChunk = this.level.getChunkPlayers(this.getChunkX(), this.getChunkZ());
                newChunk.remove(this.loaderId);
                for (Player player : new ArrayList(this.hasSpawned.values())) {
                    if (!newChunk.containsKey(player.loaderId)) {
                        this.despawnFrom(player);
                        continue;
                    }
                    newChunk.remove(player.loaderId);
                }
                for (Player player : newChunk.values()) {
                    this.spawnTo(player);
                }
            }
            if (this.chunk == null) {
                return;
            }
            this.chunk.addEntity(this);
        }
    }

    protected boolean checkTeleportPosition() {
        return this.checkTeleportPosition(false);
    }

    protected boolean checkTeleportPosition(boolean enderPearl) {
        if (this.teleportPosition != null) {
            int chunkX = this.teleportPosition.getChunkX();
            int chunkZ = this.teleportPosition.getChunkZ();
            for (int X = -1; X <= 1; ++X) {
                for (int Z = -1; Z <= 1; ++Z) {
                    long index = Level.chunkHash(chunkX + X, chunkZ + Z);
                    if (this.usedChunks.containsKey(index) && this.usedChunks.get(index).booleanValue()) continue;
                    return false;
                }
            }
            this.spawnToAll();
            if (!enderPearl) {
                this.forceMovement = this.teleportPosition;
            }
            this.teleportPosition = null;
            return true;
        }
        return false;
    }

    protected void sendPlayStatus(int status) {
        PlayStatusPacket pk = new PlayStatusPacket();
        pk.status = status;
        this.dataPacket(pk);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!this.isOnline()) {
            return false;
        }
        Location to = location;
        if (cause != null) {
            Location from = this.getLocation();
            PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return false;
            }
            to = event.getTo();
        }
        if (super.teleport(to.getY() == (double)to.getFloorY() ? to.add(0.0, 1.0E-5, 0.0) : to, null)) {
            this.removeAllWindows();
            this.formOpen = false;
            this.teleportPosition = this;
            if (cause != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                this.forceMovement = this.teleportPosition;
            }
            if (this.dimensionChangeInProgress) {
                this.dimensionChangeInProgress = false;
            } else {
                this.sendPosition(this, this.yaw, this.pitch, 2);
                this.checkTeleportPosition(cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL);
                this.dummyBossBars.values().forEach(DummyBossBar::reshow);
            }
            this.resetFallDistance();
            this.nextChunkOrderRun = 0;
            this.resetClientMovement();
            this.stopFishing(false);
            return true;
        }
        return false;
    }

    @Deprecated
    public void teleportImmediate(Location location) {
        this.teleportImmediate(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Deprecated
    public void teleportImmediate(Location location, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(location, null);
    }

    public int showFormWindow(FormWindow window) {
        return this.showFormWindow(window, this.formWindowCount++);
    }

    public int showFormWindow(FormWindow window, int id) {
        if (this.formOpen) {
            return 0;
        }
        ModalFormRequestPacket packet = new ModalFormRequestPacket();
        packet.formId = id;
        packet.data = window.getJSONData();
        this.formWindows.put(packet.formId, window);
        this.dataPacket(packet);
        this.formOpen = true;
        return id;
    }

    public int addServerSettings(FormWindow window) {
        int id = this.formWindowCount++;
        this.serverSettings.put(id, window);
        return id;
    }

    @Deprecated
    public long createBossBar(String text, int length) {
        return this.createBossBar(new DummyBossBar.Builder(this).text(text).length(length).build());
    }

    public long createBossBar(DummyBossBar dummyBossBar) {
        this.dummyBossBars.put(dummyBossBar.getBossBarId(), dummyBossBar);
        dummyBossBar.create();
        return dummyBossBar.getBossBarId();
    }

    public DummyBossBar getDummyBossBar(long bossBarId) {
        return this.dummyBossBars.getOrDefault(bossBarId, null);
    }

    public Map<Long, DummyBossBar> getDummyBossBars() {
        return this.dummyBossBars;
    }

    @Deprecated
    public void updateBossBar(String text, int length, long bossBarId) {
        if (this.dummyBossBars.containsKey(bossBarId)) {
            DummyBossBar bossBar = this.dummyBossBars.get(bossBarId);
            bossBar.setText(text);
            bossBar.setLength(length);
        }
    }

    public void removeBossBar(long bossBarId) {
        if (this.dummyBossBars.containsKey(bossBarId)) {
            this.dummyBossBars.get(bossBarId).destroy();
            this.dummyBossBars.remove(bossBarId);
        }
    }

    public int getWindowId(Inventory inventory) {
        if (this.windows.containsKey(inventory)) {
            return (Integer)this.windows.get(inventory);
        }
        return -1;
    }

    public Inventory getWindowById(int id) {
        return (Inventory)this.windowIndex.get(id);
    }

    public int addWindow(Inventory inventory) {
        return this.addWindow(inventory, null);
    }

    public int addWindow(Inventory inventory, Integer forceId) {
        return this.addWindow(inventory, forceId, false);
    }

    public int addWindow(Inventory inventory, Integer forceId, boolean isPermanent) {
        return this.addWindow(inventory, forceId, isPermanent, false);
    }

    public int addWindow(Inventory inventory, Integer forceId, boolean isPermanent, boolean alwaysOpen) {
        int cnt;
        if (this.windows.containsKey(inventory)) {
            return (Integer)this.windows.get(inventory);
        }
        if (forceId == null) {
            this.windowCnt = cnt = Math.max(4, ++this.windowCnt % 99);
        } else {
            cnt = forceId;
        }
        this.windows.forcePut(inventory, cnt);
        if (isPermanent) {
            this.permanentWindows.add(cnt);
        }
        if (this.spawned && inventory.open(this)) {
            return cnt;
        }
        if (!alwaysOpen) {
            this.removeWindow(inventory);
            return -1;
        }
        inventory.getViewers().add(this);
        return cnt;
    }

    public Optional<Inventory> getTopWindow() {
        for (Map.Entry entry : this.windows.entrySet()) {
            if (this.permanentWindows.contains(entry.getValue())) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public void removeWindow(Inventory inventory) {
        this.removeWindow(inventory, false);
    }

    protected void removeWindow(Inventory inventory, boolean isResponse) {
        inventory.close(this);
        if (!this.permanentWindows.contains(this.getWindowId(inventory))) {
            this.windows.remove(inventory);
        }
    }

    public void sendAllInventories() {
        for (Inventory inv : this.windows.keySet()) {
            inv.sendContents(this);
            if (!(inv instanceof PlayerInventory)) continue;
            ((PlayerInventory)inv).sendArmorContents(this);
        }
    }

    protected void addDefaultWindows() {
        this.addWindow(this.getInventory(), 0, true, true);
        this.playerUIInventory = new PlayerUIInventory(this);
        this.addWindow(this.playerUIInventory, 124, true);
        this.addWindow(this.offhandInventory, 119, true, true);
        this.craftingGrid = this.playerUIInventory.getCraftingGrid();
        this.addWindow(this.craftingGrid, -1);
    }

    public PlayerUIInventory getUIInventory() {
        return this.playerUIInventory;
    }

    public PlayerCursorInventory getCursorInventory() {
        return this.playerUIInventory.getCursorInventory();
    }

    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    public void setCraftingGrid(CraftingGrid grid) {
        this.craftingGrid = grid;
        this.addWindow(grid, -1);
    }

    public void resetCraftingGridType() {
        if (this.playerUIInventory != null) {
            Item[] drops;
            if (this.craftingGrid != null) {
                drops = this.inventory.addItem(this.craftingGrid.getContents().values().toArray(new Item[0]));
                this.craftingGrid.clearAll();
                for (Item drop : drops) {
                    this.level.dropItem(this, drop);
                }
            }
            drops = this.inventory.addItem(this.playerUIInventory.getCursorInventory().getItemFast(0));
            this.playerUIInventory.getCursorInventory().clear(0);
            for (Item drop : drops) {
                this.level.dropItem(this, drop);
            }
            this.moveBlockUIContents(2);
            this.moveBlockUIContents(3);
            this.moveBlockUIContents(4);
            this.moveBlockUIContents(6);
            this.playerUIInventory.clearAll();
            if (this.craftingGrid instanceof BigCraftingGrid && this.connected) {
                this.craftingGrid = this.playerUIInventory.getCraftingGrid();
                this.addWindow(this.craftingGrid, -1);
            }
        }
        this.craftingType = 0;
    }

    private void moveBlockUIContents(int window) {
        Inventory inventory = this.getWindowById(window);
        if (inventory != null && !(inventory instanceof ContainerInventory)) {
            Item[] drops = this.inventory.addItem(inventory.getContents().values().toArray(new Item[0]));
            inventory.clearAll();
            for (Item drop : drops) {
                this.level.dropItem(this, drop);
            }
        }
    }

    public void removeAllWindows() {
        this.removeAllWindows(false);
    }

    public void removeAllWindows(boolean permanent) {
        for (Map.Entry entry : new ArrayList(this.windowIndex.entrySet())) {
            if (!permanent && this.permanentWindows.contains(entry.getKey())) continue;
            this.removeWindow((Inventory)entry.getValue());
        }
    }

    public int getClosingWindowId() {
        return this.closingWindowId;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public void onChunkChanged(FullChunk chunk) {
        this.usedChunks.remove(Level.chunkHash(chunk.getX(), chunk.getZ()));
    }

    @Override
    public void onChunkLoaded(FullChunk chunk) {
    }

    @Override
    public void onChunkPopulated(FullChunk chunk) {
    }

    @Override
    public void onChunkUnloaded(FullChunk chunk) {
    }

    @Override
    public void onBlockChanged(Vector3 block) {
    }

    @Override
    public int getLoaderId() {
        return this.loaderId;
    }

    @Override
    public boolean isLoaderActive() {
        return this.connected;
    }

    public static BatchPacket getChunkCacheFromData(int chunkX, int chunkZ, int subChunkCount, byte[] payload, int dimension) {
        LevelChunkPacket pk = new LevelChunkPacket();
        pk.chunkX = chunkX;
        pk.chunkZ = chunkZ;
        pk.dimension = dimension;
        pk.subChunkCount = subChunkCount;
        pk.data = payload;
        pk.tryEncode();
        byte[] buf = pk.getBuffer();
        BinaryStream batched = new BinaryStream(new byte[5 + buf.length]).reset();
        batched.putUnsignedVarInt(buf.length);
        batched.put(buf);
        try {
            byte[] bytes = batched.getBuffer();
            BatchPacket compress = new BatchPacket();
            compress.payload = Server.getInstance().useSnappy ? SnappyCompression.compress(bytes) : Zlib.deflateRaw(bytes, Server.getInstance().networkCompressionLevel);
            return compress;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isFoodEnabled() {
        return !this.isCreative() && !this.isSpectator() && this.foodEnabled;
    }

    public void setFoodEnabled(boolean foodEnabled) {
        this.foodEnabled = foodEnabled;
    }

    public PlayerFood getFoodData() {
        return this.foodData;
    }

    public void setDimension(int dimension) {
        if (!this.loggedIn) {
            return;
        }
        this.dimensionChangeInProgress = true;
        this.awaitingDimensionAck = true;
        ChangeDimensionPacket changeDimensionPacket = new ChangeDimensionPacket();
        changeDimensionPacket.dimension = dimension;
        changeDimensionPacket.x = (float)this.x;
        changeDimensionPacket.y = (float)this.y;
        changeDimensionPacket.z = (float)this.z;
        changeDimensionPacket.respawn = !this.isAlive();
        this.dataPacket(changeDimensionPacket);
        NetworkChunkPublisherUpdatePacket chunkPublisherUpdatePacket = new NetworkChunkPublisherUpdatePacket();
        chunkPublisherUpdatePacket.position = this.asBlockVector3();
        chunkPublisherUpdatePacket.radius = this.chunkRadius << 4;
        this.dataPacket(chunkPublisherUpdatePacket);
        this.dimensionFix560 = true;
    }

    @Override
    protected void preSwitchLevel() {
        this.unloadChunks(true);
    }

    @Override
    protected void afterSwitchLevel() {
        SetSpawnPositionPacket spawnPosition = new SetSpawnPositionPacket();
        spawnPosition.spawnType = 1;
        Vector3 spawn = this.level.getProvider().getSpawn();
        spawnPosition.x = spawn.getFloorX();
        spawnPosition.y = spawn.getFloorY();
        spawnPosition.z = spawn.getFloorZ();
        spawnPosition.dimension = this.level.getDimension();
        this.dataPacket(spawnPosition);
        this.level.sendTime(this);
        this.level.sendWeather(this);
        GameRulesChangedPacket packet = new GameRulesChangedPacket();
        packet.gameRulesMap = this.level.getGameRules().getGameRules();
        this.dataPacket(packet);
    }

    public void setCheckMovement(boolean checkMovement) {
        this.checkMovement = checkMovement;
    }

    public boolean isCheckingMovement() {
        return this.checkMovement;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public synchronized Locale getLocale() {
        return this.locale.get();
    }

    @Override
    public void setSprinting(boolean value) {
        this.setSprinting(value, true);
    }

    public void setSprinting(boolean value, boolean send) {
        if (this.isSprinting() != value) {
            super.setSprinting(value);
            this.setMovementSpeed(value ? this.getMovementSpeed() * 1.3f : this.getMovementSpeed() / 1.3f, send);
        }
    }

    public void transfer(InetSocketAddress address) {
        this.transfer(address.getAddress().getHostAddress(), address.getPort());
    }

    public void transfer(String hostName, int port) {
        TransferPacket pk = new TransferPacket();
        pk.address = hostName;
        pk.port = port;
        this.dataPacket(pk);
    }

    public LoginChainData getLoginChainData() {
        return this.loginChainData;
    }

    public boolean pickupEntity(Entity entity, boolean near) {
        EntityXPOrb xpOrb;
        if (!this.spawned || !this.isAlive() || !this.isOnline() || this.isSpectator() || entity.isClosed()) {
            return false;
        }
        if (near) {
            Item item;
            EntityItem entityItem;
            if (entity instanceof EntityArrow && ((EntityArrow)entity).hadCollision) {
                EntityArrow a = (EntityArrow)entity;
                ItemArrow item2 = (ItemArrow)Item.get(262, (Integer)a.getData());
                if (!this.isCreative() && !this.inventory.canAddItem(item2)) {
                    return false;
                }
                InventoryPickupArrowEvent ev = new InventoryPickupArrowEvent(this.inventory, a);
                int pickupMode = a.getPickupMode();
                if (pickupMode == -1 || pickupMode == 0 || pickupMode == 2 && !this.isCreative()) {
                    ev.setCancelled();
                }
                this.server.getPluginManager().callEvent(ev);
                if (pickupMode == -1) {
                    entity.close();
                }
                if (ev.isCancelled()) {
                    return false;
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                if (!this.isCreative()) {
                    this.inventory.addItem(item2);
                }
                entity.close();
                return true;
            }
            if (entity instanceof EntityThrownTrident) {
                if (!((EntityThrownTrident)entity).hadCollision) {
                    if (entity.noClip) {
                        if (!this.equals(((EntityProjectile)entity).shootingEntity)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (!((EntityThrownTrident)entity).shotByPlayer()) {
                    return false;
                }
                Item item3 = ((EntityThrownTrident)entity).getItem();
                if (((EntityProjectile)entity).shootingEntity != null && item3.hasEnchantment(31) && !this.equals(((EntityProjectile)entity).shootingEntity)) {
                    return false;
                }
                if (!this.isCreative() && !this.inventory.canAddItem(item3)) {
                    return false;
                }
                InventoryPickupTridentEvent ev = new InventoryPickupTridentEvent(this.inventory, (EntityThrownTrident)entity);
                int pickupMode = ((EntityThrownTrident)entity).getPickupMode();
                if (pickupMode == -1 || pickupMode == 0 || pickupMode == 2 && !this.isCreative()) {
                    ev.setCancelled();
                }
                this.server.getPluginManager().callEvent(ev);
                if (pickupMode == -1) {
                    entity.close();
                }
                if (ev.isCancelled()) {
                    return false;
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                if (!this.isCreative()) {
                    int favSlot = ((EntityThrownTrident)entity).getFavoredSlot();
                    if (favSlot != -1 && !this.isCreative() && this.inventory.getItemFast(favSlot).getId() == 0) {
                        this.inventory.setItem(favSlot, item3.clone());
                    } else {
                        this.inventory.addItem(item3);
                    }
                }
                entity.close();
                return true;
            }
            if (entity instanceof EntityItem && (entityItem = (EntityItem)entity).getPickupDelay() <= 0 && (item = entityItem.getItem()) != null) {
                if (!this.isCreative() && !this.inventory.canAddItem(item)) {
                    return false;
                }
                InventoryPickupItemEvent ev = new InventoryPickupItemEvent(this.inventory, entityItem);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                switch (item.getId()) {
                    case 17: 
                    case 162: {
                        this.awardAchievement("mineWood");
                        break;
                    }
                    case 264: {
                        this.awardAchievement("diamonds");
                        if (entityItem.droppedBy == null || entityItem.droppedBy == this) break;
                        entityItem.droppedBy.awardAchievement("diamondsToYou");
                        break;
                    }
                    case 334: {
                        this.awardAchievement("killCow");
                        break;
                    }
                    case 369: {
                        this.awardAchievement("blazeRod");
                    }
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                this.inventory.addItem(item);
                entity.close();
                return true;
            }
        }
        if (this.pickedXPOrb < this.server.getTick() && entity instanceof EntityXPOrb && (xpOrb = (EntityXPOrb)entity).getPickupDelay() <= 0 && this.boundingBox.isVectorInside(entity)) {
            Item offhand;
            int exp = xpOrb.getExp();
            entity.close();
            this.getLevel().addLevelEvent(this, 1051);
            this.pickedXPOrb = this.server.getTick();
            IntArrayList itemsWithMending = new IntArrayList();
            for (int i = 0; i < 4; ++i) {
                if (!this.inventory.getArmorItem(i).hasEnchantment(26)) continue;
                itemsWithMending.add(this.inventory.getSize() + i);
            }
            if (this.inventory.getItemInHandFast().hasEnchantment(26)) {
                itemsWithMending.add(this.inventory.getHeldItemIndex());
            }
            if ((offhand = this.getOffhandInventory().getItem(0)).getId() == 513 && offhand.hasEnchantment(26)) {
                itemsWithMending.add(-1);
            }
            if (!itemsWithMending.isEmpty()) {
                Item repaired;
                int itemToRepair = itemsWithMending.getInt(Utils.random.nextInt(itemsWithMending.size()));
                boolean isOffhand = itemToRepair == -1;
                Item item = repaired = isOffhand ? offhand : this.inventory.getItem(itemToRepair);
                if (repaired instanceof ItemDurable && repaired.getDamage() > 0) {
                    int dmg = repaired.getDamage() - (exp << 1);
                    if (dmg < 0) {
                        dmg = 0;
                    }
                    repaired.setDamage(dmg);
                    if (isOffhand) {
                        this.getOffhandInventory().setItem(0, repaired);
                    } else {
                        this.inventory.setItem(itemToRepair, repaired);
                    }
                    return true;
                }
            }
            this.addExperience(exp);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Player)) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.getUniqueId(), other.getUniqueId()) && this.getId() == other.getId();
    }

    public boolean isBreakingBlock() {
        return this.breakingBlock != null;
    }

    public void showXboxProfile(String xuid) {
        ShowProfilePacket pk = new ShowProfilePacket();
        pk.xuid = xuid;
        this.dataPacket(pk);
    }

    public void startFishing(Item fishingRod) {
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", this.x)).add(new DoubleTag("", this.y + (double)this.getEyeHeight())).add(new DoubleTag("", this.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(this.yaw / 180.0 + Math.PI) * Math.cos(this.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(this.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(this.yaw / 180.0 * Math.PI) * Math.cos(this.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)this.yaw)).add(new FloatTag("", (float)this.pitch)));
        double f = 1.1;
        EntityFishingHook fishingHook = (EntityFishingHook)Entity.createEntity(77, this.chunk, nbt, this);
        fishingHook.setMotion(new Vector3(-Math.sin(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * f * f, -Math.sin(Math.toRadians(this.pitch)) * f * f, Math.cos(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * f * f));
        ProjectileLaunchEvent ev = new ProjectileLaunchEvent(fishingHook);
        this.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            fishingHook.close();
        } else {
            this.fishing = fishingHook;
            fishingHook.rod = fishingRod;
            fishingHook.checkLure();
            fishingHook.spawnToAll();
            this.level.addLevelSoundEvent((Vector3)this, 40, -1, "minecraft:player", false, false);
        }
    }

    public void stopFishing(boolean click) {
        if (this.fishing != null && click) {
            this.fishing.reelLine();
        } else if (this.fishing != null) {
            this.fishing.close();
        }
        this.fishing = null;
    }

    @Override
    public boolean doesTriggerPressurePlate() {
        return this.gamemode != 3;
    }

    public int getTimeSinceRest() {
        return this.timeSinceRest;
    }

    public void setTimeSinceRest(int ticks) {
        this.timeSinceRest = ticks;
    }

    @Override
    public String toString() {
        return "Player(name='" + this.getName() + "', location=" + super.toString() + ')';
    }

    @Override
    public void setAirTicks(int ticks) {
        if (this.airTicks != ticks && (this.spawned || ticks > this.airTicks)) {
            this.airTicks = ticks;
            this.setDataPropertyAndSendOnlyToSelf(new ShortEntityData(7, ticks));
        }
    }

    private void syncHeldItem() {
        InventorySlotPacket pk = new InventorySlotPacket();
        pk.slot = this.inventory.getHeldItemIndex();
        pk.item = this.inventory.getItem(pk.slot);
        pk.inventoryId = 0;
        this.dataPacket(pk);
    }

    void resetPacketCounters() {
        if (this.needSendAdventureSettings) {
            this.needSendAdventureSettings = false;
            this.adventureSettings.update(false);
        }
        if (this.needSendData) {
            this.needSendData = false;
            this.sendData(this);
        }
        if (this.needSendFoodLevel) {
            this.needSendFoodLevel = false;
            this.foodData.sendFoodLevel();
        }
        if (this.needSendInventory && this.spawned) {
            this.needSendInventory = false;
            this.getCursorInventory().sendContents(this);
            this.sendAllInventories();
        }
        if (this.needSendHeldItem && this.spawned) {
            this.needSendHeldItem = false;
            this.syncHeldItem();
        }
    }

    public boolean canEat(boolean update) {
        if (this.foodData.getLevel() < this.foodData.getMaxLevel() || this.isCreative() || this.server.getDifficulty() == 0) {
            return true;
        }
        if (update) {
            this.needSendFoodLevel = true;
        }
        return false;
    }

    public NetworkPlayerSession getNetworkSession() {
        return this.networkSession;
    }

    @Override
    public final boolean canSaveToStorage() {
        return false;
    }

    public boolean sneakToBlockInteract() {
        return this.isSneaking() || this.flySneaking;
    }

    public void setHudElementVisibility(boolean visible, HudElement ... elements) {
        SetHudPacket pk = new SetHudPacket();
        pk.elements.addAll(Arrays.asList(elements));
        pk.visible = visible;
        this.dataPacket(pk);
    }

    @Override
    public void setGliding(boolean value) {
        this.fireworkBoostTicks = 0;
        super.setGliding(value);
    }

    public void closeFormWindows() {
        this.formWindows.clear();
        this.dataPacket(new ClientboundCloseFormPacket());
    }

    @Generated
    public boolean isInventoryOpen() {
        return this.inventoryOpen;
    }

    @Generated
    public boolean isCanTickShield() {
        return this.canTickShield;
    }

    @Generated
    public void setCanTickShield(boolean canTickShield) {
        this.canTickShield = canTickShield;
    }

    @Generated
    public boolean isFormOpen() {
        return this.formOpen;
    }

    @Generated
    public void setNeedSendData(boolean needSendData) {
        this.needSendData = needSendData;
    }

    @Generated
    public void setNeedSendInventory(boolean needSendInventory) {
        this.needSendInventory = needSendInventory;
    }

    static {
        PRE_LOGIN_PACKETS = Sets.newHashSet((byte)-1, (byte)1, (byte)-63, (byte)69, (byte)113, (byte)84, (byte)8, (byte)-127, (byte)-100, (byte)4);
    }
}

