/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.InterruptibleThread;
import cn.nukkit.Server;
import cn.nukkit.utils.ServerKiller;
import com.google.common.base.Preconditions;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Nukkit {
    @Generated
    private static final Logger log = LogManager.getLogger(Nukkit.class);
    public static final Properties GIT_INFO = Nukkit.getGitInfo();
    public static final String VERSION = Nukkit.getVersion();
    public static final String API_VERSION = "1.1.0";
    public static final String PATH = System.getProperty("user.dir") + '/';
    public static final String DATA_PATH = System.getProperty("user.dir") + '/';
    public static final String PLUGIN_PATH = DATA_PATH + "plugins";
    public static final long START_TIME = System.currentTimeMillis();
    public static boolean TITLE = true;
    public static int DEBUG = 1;

    public static void main(String[] args) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("log4j.skipJansi", "false");
        System.getProperties().putIfAbsent("io.netty.allocator.type", "unpooled");
        System.setProperty("leveldb.mmap", "true");
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpSpec = parser.accepts("help", "Shows this page").forHelp();
        OptionSpecBuilder titleSpec = parser.accepts("enable-title", "Enables title at the top of the window");
        ArgumentAcceptingOptionSpec<String> vSpec = parser.accepts("v", "Set verbosity of logging").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> verbositySpec = parser.accepts("verbosity", "Set verbosity of logging").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> languageSpec = parser.accepts("language", "Set a predefined language").withOptionalArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        if (options.has(helpSpec)) {
            try {
                parser.printHelpOn(System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        InternalLoggerFactory.setDefaultFactory(Log4J2LoggerFactory.INSTANCE);
        ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.PARANOID);
        TITLE = options.has(titleSpec);
        String verbosity = options.valueOf(vSpec);
        if (verbosity == null) {
            verbosity = options.valueOf(verbositySpec);
        }
        if (verbosity != null) {
            try {
                Level level = Level.valueOf(verbosity);
                Nukkit.setLogLevel(level);
            }
            catch (Exception level) {
                // empty catch block
            }
        }
        String language = options.valueOf(languageSpec);
        try {
            if (TITLE) {
                System.out.print("\u001b]0;Nukkit " + Nukkit.getVersion() + '\u0007');
            }
            new Server(PATH, DATA_PATH, PLUGIN_PATH, language);
        }
        catch (Throwable t2) {
            log.throwing(t2);
        }
        if (TITLE) {
            System.out.print("\u001b]0;Stopping Server...\u0007");
        }
        log.info("Stopping other threads...");
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!(thread instanceof InterruptibleThread)) continue;
            log.debug("Stopping {} thread", (Object)thread.getClass().getSimpleName());
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        ServerKiller killer = new ServerKiller(10L);
        killer.start();
        if (TITLE) {
            System.out.print("\u001b]0;Server Stopped\u0007");
        }
        System.exit(0);
    }

    private static Properties getGitInfo() {
        InputStream gitFileStream = Nukkit.class.getClassLoader().getResourceAsStream("git.properties");
        if (gitFileStream == null) {
            log.debug("Unable to find git.properties");
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(gitFileStream);
        }
        catch (IOException e) {
            log.debug("Unable to load git.properties", (Throwable)e);
            return null;
        }
        return properties;
    }

    private static String getVersion() {
        String commitId;
        StringBuilder version = new StringBuilder();
        version.append("git-");
        if (GIT_INFO == null || (commitId = GIT_INFO.getProperty("git.commit.id.abbrev")) == null || commitId.isEmpty()) {
            return version.append("null").toString();
        }
        return version.append(commitId).toString();
    }

    public static void setLogLevel(Level level) {
        Preconditions.checkNotNull(level, "level");
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        LoggerConfig loggerConfig = ctx.getConfiguration().getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static Level getLogLevel() {
        return ((LoggerContext)LogManager.getContext(false)).getConfiguration().getLoggerConfig("").getLevel();
    }
}

