/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Player;
import cn.nukkit.network.protocol.UpdateAbilitiesPacket;
import cn.nukkit.network.protocol.UpdateAdventureSettingsPacket;
import cn.nukkit.network.protocol.types.AbilityLayer;
import cn.nukkit.network.protocol.types.PlayerAbility;
import java.util.EnumMap;
import java.util.Map;

public class AdventureSettings
implements Cloneable {
    public static final int PERMISSION_NORMAL = 0;
    public static final int PERMISSION_OPERATOR = 1;
    public static final int PERMISSION_HOST = 2;
    public static final int PERMISSION_AUTOMATION = 3;
    public static final int PERMISSION_ADMIN = 4;
    private final Map<Type, Boolean> values = new EnumMap<Type, Boolean>(Type.class);
    private Player player;

    public AdventureSettings(Player player) {
        this.player = player;
    }

    public AdventureSettings clone(Player newPlayer) {
        try {
            AdventureSettings settings = (AdventureSettings)super.clone();
            settings.player = newPlayer;
            return settings;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AdventureSettings set(Type type, boolean value) {
        this.values.put(type, value);
        return this;
    }

    public boolean get(Type type) {
        Boolean value = this.values.get((Object)type);
        return value == null ? type.getDefaultValue() : value.booleanValue();
    }

    public void update() {
        this.update(true);
    }

    void update(boolean reset) {
        UpdateAbilitiesPacket packet = new UpdateAbilitiesPacket();
        packet.setEntityId(this.player.getId());
        packet.setCommandPermission(this.player.isOp() ? UpdateAbilitiesPacket.CommandPermission.OPERATOR : UpdateAbilitiesPacket.CommandPermission.NORMAL);
        packet.setPlayerPermission(this.player.isOp() && !this.player.isSpectator() ? UpdateAbilitiesPacket.PlayerPermission.OPERATOR : UpdateAbilitiesPacket.PlayerPermission.MEMBER);
        AbilityLayer layer = new AbilityLayer();
        layer.setLayerType(AbilityLayer.Type.BASE);
        layer.getAbilitiesSet().addAll(PlayerAbility.VALUES);
        for (Type type : Type.values()) {
            if (!type.isAbility() || !this.get(type)) continue;
            layer.getAbilityValues().add(type.getAbility());
        }
        layer.getAbilityValues().add(PlayerAbility.WALK_SPEED);
        layer.getAbilityValues().add(PlayerAbility.FLY_SPEED);
        if (this.player.isCreative()) {
            layer.getAbilityValues().add(PlayerAbility.INSTABUILD);
        }
        if (this.player.isOp()) {
            layer.getAbilityValues().add(PlayerAbility.OPERATOR_COMMANDS);
        }
        layer.setWalkSpeed(0.1f);
        layer.setFlySpeed(0.05f);
        packet.getAbilityLayers().add(layer);
        if (this.player.isSpectator()) {
            AbilityLayer spectator = new AbilityLayer();
            spectator.setLayerType(AbilityLayer.Type.SPECTATOR);
            spectator.getAbilitiesSet().addAll(PlayerAbility.VALUES);
            spectator.getAbilitiesSet().remove((Object)PlayerAbility.FLY_SPEED);
            spectator.getAbilitiesSet().remove((Object)PlayerAbility.WALK_SPEED);
            for (Type type : Type.values()) {
                if (!type.isAbility() || !this.get(type)) continue;
                spectator.getAbilityValues().add(type.getAbility());
            }
            if (this.player.isOp()) {
                layer.getAbilityValues().add(PlayerAbility.OPERATOR_COMMANDS);
            }
            packet.getAbilityLayers().add(spectator);
        }
        UpdateAdventureSettingsPacket adventurePacket = new UpdateAdventureSettingsPacket();
        adventurePacket.setAutoJump(this.get(Type.AUTO_JUMP));
        adventurePacket.setImmutableWorld(this.get(Type.WORLD_IMMUTABLE));
        adventurePacket.setNoMvP(this.get(Type.NO_MVP));
        adventurePacket.setNoPvM(this.get(Type.NO_PVM));
        adventurePacket.setShowNameTags(this.get(Type.SHOW_NAME_TAGS));
        this.player.dataPacket(packet);
        this.player.dataPacket(adventurePacket);
        if (reset) {
            this.player.resetInAirTicks();
        }
    }

    public static enum Type {
        WORLD_IMMUTABLE(null, false),
        NO_PVM(null, false),
        NO_MVP(PlayerAbility.INVULNERABLE, false),
        SHOW_NAME_TAGS(null, false),
        AUTO_JUMP(null, true),
        ALLOW_FLIGHT(PlayerAbility.MAY_FLY, false),
        NO_CLIP(PlayerAbility.NO_CLIP, false),
        WORLD_BUILDER(PlayerAbility.WORLD_BUILDER, false),
        FLYING(PlayerAbility.FLYING, false),
        MUTED(PlayerAbility.MUTED, false),
        MINE(PlayerAbility.MINE, true),
        DOORS_AND_SWITCHED(PlayerAbility.DOORS_AND_SWITCHES, true),
        OPEN_CONTAINERS(PlayerAbility.OPEN_CONTAINERS, true),
        ATTACK_PLAYERS(PlayerAbility.ATTACK_PLAYERS, true),
        ATTACK_MOBS(PlayerAbility.ATTACK_MOBS, true),
        OPERATOR(PlayerAbility.OPERATOR_COMMANDS, false),
        TELEPORT(PlayerAbility.TELEPORT, false),
        BUILD(PlayerAbility.BUILD, true),
        PRIVILEGED_BUILDER(PlayerAbility.PRIVILEGED_BUILDER, false),
        DEFAULT_LEVEL_PERMISSIONS(null, false);

        private final PlayerAbility ability;
        private final boolean defaultValue;

        private Type(PlayerAbility ability, boolean defaultValue) {
            this.ability = ability;
            this.defaultValue = defaultValue;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public PlayerAbility getAbility() {
            return this.ability;
        }

        public boolean isAbility() {
            return this.ability != null;
        }
    }
}

